/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import data.DataSource;
import data.DataSourceException;
import data.ExternalDataSource;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import misc.LoggedException;
import numerics.RealMatrix;
import tools.BufferedInflaterInputStream;
import tools.EndianNeutralDataInputStream;

public class MetaImageHeader
extends ImageHeader {
    private static Logger logger = Logger.getLogger("camino.imaging.MetaImageHeader");
    public final ObjectType objectType = ObjectType.IMAGE;
    public final int nDims = 3;
    public final boolean binaryData = true;
    public boolean compressedData = false;
    public boolean intelByteOrder = false;
    public RealMatrix transformation = RealMatrix.identity(3);
    public double[] offset = new double[]{0.0, 0.0, 0.0};
    public double[] rotationCentre = new double[]{0.0, 0.0, 0.0};
    public AnatomicalOrientation anatomicalOrientation = AnatomicalOrientation.LPI;
    public double[] spacing = new double[]{1.0, 1.0, 1.0};
    public int[] dimSize = new int[]{1, 1, 1};
    public int channels = 1;
    public DataType dataType = DataType.DOUBLE;
    public String dataFile = "LOCAL";
    public String localDataFile = "";
    public int dataByteOffset = 0;

    public static MetaImageHeader readHeader(String string) throws IOException {
        Object object;
        if (!string.endsWith(".mha") && !string.endsWith(".mhd")) {
            object = new File(string + ".mha");
            if (((File)object).exists()) {
                string = string + ".mha";
            } else {
                object = new File(string + ".mhd");
                if (((File)object).exists()) {
                    string = string + ".mhd";
                } else {
                    throw new FileNotFoundException("Can't find file " + string + ".mha or " + string + ".mhd");
                }
            }
        }
        object = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 1024));
        MetaImageHeader metaImageHeader = MetaImageHeader.readHeader((DataInput)object);
        ((FilterInputStream)object).close();
        if (metaImageHeader.dataFile.equals("LOCAL")) {
            metaImageHeader.localDataFile = string;
        } else {
            String string2 = "";
            String string3 = File.separator;
            int n = string.lastIndexOf(string3);
            if (n > -1) {
                string2 = string.substring(0, n + 1);
            }
            metaImageHeader.localDataFile = string2 + metaImageHeader.dataFile;
        }
        return metaImageHeader;
    }

    public static MetaImageHeader readHeader(DataInput dataInput) throws IOException {
        MetaImageHeader metaImageHeader = new MetaImageHeader();
        boolean bl = false;
        byte by = new String("\n").getBytes()[0];
        byte by2 = new String("\r").getBytes()[0];
        int n = 0;
        while (!bl) {
            String string;
            String[] stringArray;
            int n2;
            String string2 = "";
            String string3 = "";
            byte[] byArray = new byte[2048];
            int n3 = 0;
            do {
                n2 = dataInput.readByte();
                byArray[n3++] = n2;
            } while (n2 != by);
            n += n3;
            n2 = n3 - 1;
            if (byArray[n3 - 1] == by2) {
                --n2;
            }
            if ((stringArray = (string = new String(byArray, 0, n2, "US-ASCII")).trim().split("\\s*=\\s*")).length != 2) {
                throw new LoggedException("Header line\n" + string + "\nis not a valid Meta header " + " field. Meta fields are of the form \"Key = Value\"");
            }
            metaImageHeader.setHeaderValue(stringArray[0].trim(), stringArray[1].trim());
            if (!stringArray[0].equals("ElementDataFile")) continue;
            bl = true;
        }
        if (metaImageHeader.dataFile.equals("LOCAL")) {
            metaImageHeader.dataByteOffset = n;
        }
        return metaImageHeader;
    }

    public void setHeaderValue(String string, String string2) {
        if (string.equalsIgnoreCase("ObjectType")) {
            ObjectType objectType = ObjectType.getObjectType(string2);
            if (objectType != ObjectType.IMAGE) {
                throw new LoggedException("Only image type is supported");
            }
        } else if (string.equalsIgnoreCase("NDims")) {
            int n = Integer.parseInt(string2);
            if (n != 3) {
                throw new LoggedException("only 3D images are supported.");
            }
        } else if (string.equalsIgnoreCase("BinaryData")) {
            boolean bl = Boolean.parseBoolean(string2);
            if (!bl) {
                throw new LoggedException("ASCII data is not supported.");
            }
        } else if (string.equalsIgnoreCase("CompressedData")) {
            this.compressedData = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("BinaryDataByteOrderMSB")) {
            this.intelByteOrder = !Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("ElementByteOrderMSB")) {
            this.intelByteOrder = !Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("TransformMatrix")) {
            String[] stringArray = string2.split("\\s+");
            this.transformation = new RealMatrix(3, 3);
            for (int i = 0; i < 9; ++i) {
                this.transformation.entries[i / 3][i % 3] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("Offset")) {
            String[] stringArray = string2.split("\\s+");
            this.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.offset[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("Position")) {
            String[] stringArray = string2.split("\\s+");
            this.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.offset[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("Origin")) {
            String[] stringArray = string2.split("\\s+");
            this.offset = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.offset[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("CenterOfRotation")) {
            String[] stringArray = string2.split("\\s+");
            this.rotationCentre = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.rotationCentre[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("AnatomicalOrientation")) {
            this.anatomicalOrientation = AnatomicalOrientation.getAnatomicalOrientation(string2);
        } else if (string.equalsIgnoreCase("ElementSpacing")) {
            String[] stringArray = string2.split("\\s+");
            this.spacing = new double[3];
            for (int i = 0; i < 3; ++i) {
                this.spacing[i] = Double.parseDouble(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("DimSize")) {
            String[] stringArray = string2.split("\\s+");
            this.dimSize = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.dimSize[i] = Integer.parseInt(stringArray[i]);
            }
        } else if (string.equalsIgnoreCase("ElementNumberOfChannels")) {
            this.channels = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("ElementType")) {
            this.dataType = DataType.getDataType(string2);
        } else if (string.equalsIgnoreCase("ElementDataFile")) {
            this.dataFile = string2;
        } else {
            logger.warning("Unrecognized header field " + string + " ignored");
        }
    }

    public void writeHeader(String string) throws IOException {
        if (!string.endsWith(".mha") && !string.endsWith(".mhd")) {
            string = this.dataFile.equalsIgnoreCase("LOCAL") ? string + ".mhd" : string + ".mha";
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string), 1024));
        this.writeHeader(dataOutputStream);
        dataOutputStream.close();
    }

    public void writeHeader(DataOutput dataOutput) throws IOException {
        dataOutput.write(new String("ObjectType = " + (Object)((Object)this.objectType) + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("NDims = 3\n").getBytes("US-ASCII"));
        dataOutput.write(new String("BinaryData = " + MetaImageHeader.titleCaseBool(true) + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("CompressedData = " + MetaImageHeader.titleCaseBool(this.compressedData) + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("BinaryDataByteOrderMSB = " + MetaImageHeader.titleCaseBool(!this.intelByteOrder) + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("TransformMatrix = " + MetaImageHeader.flatMatrixString(this.transformation) + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("Offset = " + this.offset[0] + " " + this.offset[1] + " " + this.offset[2] + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("CenterOfRotation = " + this.rotationCentre[0] + " " + this.rotationCentre[1] + " " + this.rotationCentre[2] + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("AnatomicalOrientation = " + (Object)((Object)this.anatomicalOrientation) + "\n").getBytes("US-ASCII"));
        String string = "ElementSpacing = " + this.spacing[0] + " " + this.spacing[1] + " " + this.spacing[2] + "\n";
        dataOutput.write(string.getBytes("US-ASCII"));
        String string2 = "DimSize = " + this.dimSize[0] + " " + this.dimSize[1] + " " + this.dimSize[2] + "\n";
        dataOutput.write(new String(string2).getBytes("US-ASCII"));
        dataOutput.write(new String("ElementNumberOfChannels = " + this.channels + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("ElementType = " + (Object)((Object)this.dataType) + "\n").getBytes("US-ASCII"));
        dataOutput.write(new String("ElementDataFile = " + this.dataFile + "\n").getBytes("US-ASCII"));
    }

    public String caminoDataTypeString() {
        if (this.dataType == DataType.UCHAR) {
            return "char";
        }
        if (this.dataType == DataType.CHAR) {
            return "byte";
        }
        if (this.dataType == DataType.SHORT) {
            return "short";
        }
        if (this.dataType == DataType.INT) {
            return "int";
        }
        if (this.dataType == DataType.FLOAT) {
            return "float";
        }
        if (this.dataType == DataType.DOUBLE) {
            return "double";
        }
        if (this.dataType == DataType.USHORT) {
            return "ushort";
        }
        if (this.dataType == DataType.UINT) {
            return "uint";
        }
        if (this.dataType == DataType.LONG) {
            return "long";
        }
        throw new LoggedException("File does not have a supported Camino data type");
    }

    private static String titleCaseBool(boolean bl) {
        if (bl) {
            return "True";
        }
        return "False";
    }

    private static String flatMatrixString(RealMatrix realMatrix) {
        String string = "";
        double[][] dArray = realMatrix.entries;
        for (int i = 0; i < realMatrix.rows(); ++i) {
            for (int j = 0; j < realMatrix.columns(); ++j) {
                string = string + dArray[i][j] + " ";
            }
        }
        return string.trim();
    }

    @Override
    public int xDataDim() {
        return this.dimSize[0];
    }

    @Override
    public int yDataDim() {
        return this.dimSize[1];
    }

    @Override
    public int zDataDim() {
        return this.dimSize[2];
    }

    @Override
    public int[] getDataDims() {
        return new int[]{this.dimSize[0], this.dimSize[1], this.dimSize[2]};
    }

    @Override
    public double xVoxelDim() {
        return this.spacing[0];
    }

    @Override
    public double yVoxelDim() {
        return this.spacing[1];
    }

    @Override
    public double zVoxelDim() {
        return this.spacing[2];
    }

    @Override
    public double[] getVoxelDims() {
        return new double[]{this.spacing[0], this.spacing[1], this.spacing[2]};
    }

    @Override
    public int components() {
        return this.channels > 0 ? this.channels : 1;
    }

    @Override
    public double[] getOrigin() {
        return new double[]{this.offset[0], this.offset[1], this.offset[2]};
    }

    @Override
    public DataSource getImageDataSource() {
        if (this.compressedData) {
            logger.warning("Compressed Meta IO is untested, use with caution");
            try {
                FileInputStream fileInputStream = new FileInputStream(this.localDataFile);
                int n = 0;
                while (n < this.dataByteOffset) {
                    fileInputStream.skip(this.dataByteOffset - n);
                }
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream, ExternalDataSource.FILEBUFFERSIZE / 2));
                zipInputStream.getNextEntry();
                EndianNeutralDataInputStream endianNeutralDataInputStream = new EndianNeutralDataInputStream(new BufferedInflaterInputStream(zipInputStream, ExternalDataSource.FILEBUFFERSIZE / 2), this.intelByteOrder);
                return new VoxelOrderDataSource(endianNeutralDataInputStream, this.channels, this.caminoDataTypeString());
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(this.localDataFile, this.channels, this.caminoDataTypeString(), this.intelByteOrder, this.dataByteOffset);
        return voxelOrderDataSource;
    }

    @Override
    public double[][][][] readVolumeData() {
        int n = this.dimSize[0];
        int n2 = this.dimSize[1];
        int n3 = this.dimSize[2];
        double[][][][] dArray = new double[n][n2][n3][this.channels];
        try {
            DataSource dataSource = this.getImageDataSource();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        double[] dArray2 = dataSource.nextVoxel();
                        for (int i2 = 0; i2 < this.channels; ++i2) {
                            dArray[k][j][i][i2] = dArray2[i2];
                        }
                    }
                }
            }
        }
        catch (DataSourceException dataSourceException) {
            throw new LoggedException(dataSourceException);
        }
        return dArray;
    }

    @Override
    public double[][][] readVolume(int n) {
        if (n < 0 || n >= this.components()) {
            throw new LoggedException("Attempted to read non-existent component " + n);
        }
        int n2 = this.dimSize[0];
        int n3 = this.dimSize[1];
        int n4 = this.dimSize[2];
        double[][][] dArray = new double[n2][n3][n4];
        try {
            DataSource dataSource = this.getImageDataSource();
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        double[] dArray2 = dataSource.nextVoxel();
                        dArray[k][j][i] = dArray2[n];
                    }
                }
            }
        }
        catch (DataSourceException dataSourceException) {
            throw new LoggedException(dataSourceException);
        }
        return dArray;
    }

    public static enum AnatomicalOrientation {
        LAS,
        LAI,
        LPS,
        LPI,
        RAS,
        RAI,
        RPS,
        RPI;


        public static AnatomicalOrientation getAnatomicalOrientation(String string) {
            for (AnatomicalOrientation anatomicalOrientation : AnatomicalOrientation.values()) {
                if (!string.equals(anatomicalOrientation.name())) continue;
                return anatomicalOrientation;
            }
            throw new LoggedException("Unsupported Anatomical Orientation " + string);
        }
    }

    public static enum ObjectType {
        IMAGE("Image");

        private final String typeName;

        private ObjectType(String string2) {
            this.typeName = string2;
        }

        public String toString() {
            return this.typeName;
        }

        public static ObjectType getObjectType(String string) {
            for (ObjectType objectType : ObjectType.values()) {
                if (!string.equals(objectType.typeName)) continue;
                return objectType;
            }
            throw new LoggedException("Unsupported Meta object type: '" + string + "'");
        }
    }

    public static enum DataType {
        UCHAR("MET_UCHAR", 2),
        CHAR("MET_CHAR", 132),
        SHORT("MET_SHORT", 4),
        USHORT("MET_USHORT", 130),
        INT("MET_INT", 8),
        UINT("MET_UINT", 136),
        FLOAT("MET_FLOAT", 16),
        DOUBLE("MET_DOUBLE", 64),
        LONG("MET_LONG", 199);

        private final String typeName;
        private final int index;

        private DataType(String string2, int n2) {
            this.typeName = string2;
            this.index = n2;
        }

        public String toString() {
            return this.typeName;
        }

        public static DataType getDataType(String string) {
            for (DataType dataType : DataType.values()) {
                if (!string.equals(dataType.typeName)) continue;
                return dataType;
            }
            throw new LoggedException("Unsupported Meta data type " + string);
        }
    }
}

