/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EndianCorrectOutputStream
extends DataOutputStream {
    private boolean bigendian = true;

    public EndianCorrectOutputStream(String string, boolean bl) throws FileNotFoundException, SecurityException {
        super(new FileOutputStream(string));
        this.bigendian = bl;
    }

    public EndianCorrectOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.bigendian = bl;
    }

    public void writeShortCorrect(short s) throws IOException {
        if (this.bigendian) {
            this.writeShort(s);
        } else {
            int n = s & 0xFF;
            int n2 = s >> 8 & 0xFF;
            this.writeShort((short)(n << 8 | n2));
        }
    }

    public short flipShort(short s) {
        int n = s & 0xFF;
        int n2 = s >> 8 & 0xFF;
        return (short)(n << 8 | n2);
    }

    public void writeIntCorrect(int n) throws IOException {
        if (this.bigendian) {
            this.writeInt(n);
        } else {
            int n2 = n & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n >> 16 & 0xFF;
            int n5 = n >> 24 & 0xFF;
            this.writeInt(n2 << 24 | n3 << 16 | n4 << 8 | n5);
        }
    }

    public int flipInt(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public void writeLongCorrect(long l) throws IOException {
        if (this.bigendian) {
            this.writeLong(l);
        } else {
            this.writeLong(this.flipLong(l));
        }
    }

    public long flipLong(long l) {
        long l2 = l & 0xFFL;
        long l3 = l >> 8 & 0xFFL;
        long l4 = l >> 16 & 0xFFL;
        long l5 = l >> 24 & 0xFFL;
        long l6 = l >> 32 & 0xFFL;
        long l7 = l >> 40 & 0xFFL;
        long l8 = l >> 48 & 0xFFL;
        long l9 = l >> 56 & 0xFFL;
        return l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9;
    }

    public void writeFloatCorrect(float f) throws IOException {
        if (this.bigendian) {
            this.writeFloat(f);
        } else {
            int n = Float.floatToIntBits(f);
            int n2 = this.flipInt(n);
            this.writeInt(n2);
        }
    }

    public float flipFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        int n2 = this.flipInt(n);
        return Float.intBitsToFloat(n2);
    }

    public void writeDoubleCorrect(double d) throws IOException {
        if (this.bigendian) {
            this.writeDouble(d);
        } else {
            long l = Double.doubleToLongBits(d);
            long l2 = this.flipLong(l);
            this.writeLong(l2);
        }
    }

    public double flipDouble(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = this.flipLong(l);
        return Double.longBitsToDouble(l2);
    }
}

