/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import misc.LoggedException;
import tools.BufferedInflaterInputStream;
import tools.EndianNeutralDataInputStream;

public abstract class ExternalDataSource
implements DataSource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static int FILEBUFFERSIZE = 24000000;
    protected int numComponents;
    protected int datatype;
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int CHAR = 6;
    public static final int USHORT = 7;
    public static final int UINT = 8;
    protected EndianNeutralDataInputStream dataIn;

    protected ExternalDataSource() {
    }

    protected void initFileInput(String string, boolean bl, int n) {
        if (string == null) {
            this.logger.info("reading data from standard input");
            this.dataIn = new EndianNeutralDataInputStream(new BufferedInputStream(System.in, FILEBUFFERSIZE), bl);
        } else {
            if (string.endsWith(".gz") || string.endsWith(".zip")) {
                this.initCompressedFileInput(string, bl, n);
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.dataIn = new EndianNeutralDataInputStream(new BufferedInputStream(fileInputStream, FILEBUFFERSIZE), bl);
                for (int i = 0; i < n; i += this.dataIn.skipBytes(n - i)) {
                }
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
        }
    }

    protected void initCompressedFileInput(String string, boolean bl, int n) {
        if (string == null) {
            throw new LoggedException("Compressed input on stdin is not supported. Try piping output from gunzip -c <file> or specify the input file.");
        }
        try {
            InflaterInputStream inflaterInputStream;
            FileInputStream fileInputStream = new FileInputStream(string);
            if (string.endsWith(".gz")) {
                inflaterInputStream = new GZIPInputStream((InputStream)new BufferedInputStream(fileInputStream, FILEBUFFERSIZE / 3), FILEBUFFERSIZE / 3);
                this.dataIn = new EndianNeutralDataInputStream(new BufferedInflaterInputStream(inflaterInputStream, FILEBUFFERSIZE / 3), bl);
            } else if (string.endsWith(".zip")) {
                inflaterInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream, FILEBUFFERSIZE / 2));
                ((ZipInputStream)inflaterInputStream).getNextEntry();
                this.dataIn = new EndianNeutralDataInputStream(new BufferedInflaterInputStream(inflaterInputStream, FILEBUFFERSIZE / 2), bl);
            }
            for (int i = 0; i < n; i += this.dataIn.skipBytes(n - i)) {
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static int getDataTypeCode(String string) throws DataSourceException {
        if (string.equals("byte")) {
            return 0;
        }
        if (string.equals("char")) {
            return 6;
        }
        if (string.equals("short")) {
            return 1;
        }
        if (string.equals("int")) {
            return 2;
        }
        if (string.equals("ushort")) {
            return 7;
        }
        if (string.equals("uint")) {
            return 8;
        }
        if (string.equals("long")) {
            return 3;
        }
        if (string.equals("float")) {
            return 4;
        }
        if (string.equals("double")) {
            return 5;
        }
        throw new DataSourceException("Unrecognized data type String: " + string);
    }

    public static String typeString(int n) {
        if (n == 0) {
            return "byte";
        }
        if (n == 6) {
            return "char";
        }
        if (n == 1) {
            return "short";
        }
        if (n == 2) {
            return "int";
        }
        if (n == 7) {
            return "ushort";
        }
        if (n == 8) {
            return "uint";
        }
        if (n == 3) {
            return "long";
        }
        if (n == 4) {
            return "float";
        }
        if (n == 5) {
            return "double";
        }
        return "unknown type";
    }
}

