/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSource;
import data.DataSourceException;
import data.DataSynthesizer;
import data.ModelPDF;
import data.VoxelOrderDataSource;
import imaging.Scheme;
import numerics.MTRandom;

public abstract class DataSynthFromInput
implements DataSource {
    protected VoxelOrderDataSource dataSource;
    protected Scheme imParams;
    protected double snr;
    protected int seed;
    protected int DATAITEMSPERVOXEL;

    public DataSynthFromInput() {
    }

    public DataSynthFromInput(String string, String string2, Scheme scheme, double d) {
        this.init(string, string2, scheme, d, 0);
    }

    public DataSynthFromInput(String string, String string2, Scheme scheme, double d, int n) {
        this.init(string, string2, scheme, d, n);
    }

    protected void init(String string, String string2, Scheme scheme, double d, int n) {
        this.imParams = scheme;
        this.snr = d;
        this.dataSource = new VoxelOrderDataSource(string, this.DATAITEMSPERVOXEL, string2);
        this.seed = n;
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        double[] dArray = this.dataSource.nextVoxel();
        double d = dArray[0];
        double d2 = Math.exp(dArray[1]);
        if (d < 0.0) {
            return new double[this.imParams.numMeasurements()];
        }
        ModelPDF modelPDF = this.getNextModel(dArray);
        DataSynthesizer dataSynthesizer = new DataSynthesizer(modelPDF, this.imParams, this.snr, 1, new MTRandom(this.seed));
        ++this.seed;
        double[] dArray2 = dataSynthesizer.nextVoxel();
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = d2 * dArray2[i];
        }
        return dArray3;
    }

    protected abstract ModelPDF getNextModel(double[] var1);

    @Override
    public boolean more() {
        return this.dataSource.more();
    }
}

