/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.BootstrapDataSynthesizer;
import data.DataSource;
import data.DataSourceException;
import data.DataSynthFromInput;
import data.DataSynthesizer;
import imaging.Scheme;
import java.util.Random;
import numerics.MTRandom;

public class BootstrapDataSynthFromInput
extends BootstrapDataSynthesizer
implements DataSource {
    protected DataSynthFromInput inputSource;
    protected Scheme impars;
    protected double snr;

    public BootstrapDataSynthFromInput(DataSynthFromInput dataSynthFromInput, int n, Scheme scheme, int n2, double d, Random random) {
        super(n);
        this.impars = scheme;
        this.inputSource = dataSynthFromInput;
        this.snr = d;
        this.init(n2, scheme.numMeasurements(), random);
    }

    public BootstrapDataSynthFromInput(DataSynthFromInput dataSynthFromInput, int n, Scheme scheme, int n2, double d, int n3) {
        this(dataSynthFromInput, n, scheme, n2, d, new MTRandom(n3));
    }

    @Override
    protected void getNextSourceVoxel() throws DataSourceException {
        if (this.reachedEndOfFile) {
            this.noMoreData = true;
            throw new DataSourceException("No more voxels in data source.");
        }
        double[] dArray = this.inputSource.nextVoxel();
        if (this.snr > 0.0) {
            int n;
            double d = this.impars.geoMeanZeroMeas(dArray);
            double[] dArray2 = new double[this.components];
            for (n = 0; n < this.components; ++n) {
                dArray2[n] = dArray[n] / d;
            }
            for (n = 0; n < this.repeats; ++n) {
                System.arraycopy(dArray2, 0, this.next[n], 0, this.components);
                this.next[n] = DataSynthesizer.addNoise(this.next[n], 1.0 / this.snr, this.ran);
                for (int i = 0; i < this.components; ++i) {
                    this.next[n][i] = d * this.next[n][i];
                }
            }
        } else {
            for (int i = 0; i < this.repeats; ++i) {
                System.arraycopy(dArray, 0, this.next[i], 0, this.components);
            }
        }
        if (!this.inputSource.more()) {
            this.reachedEndOfFile = true;
        }
    }
}

