/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import data.VoxelOrderDataSource;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class VoxelToScanner {
    private static Logger logger = Logger.getLogger("camino.apps.VoxelToScanner");
    private static int components = 1;
    private static OutputManager om;

    public static void main(String[] stringArray) {
        int n;
        CL_Initializer.inputDataType = "float";
        OutputManager.outputDataType = "float";
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-components")) continue;
            components = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i);
            CL_Initializer.markAsParsed(i + 1);
        }
        CL_Initializer.checkParsing(stringArray);
        om = new OutputManager();
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, components, CL_Initializer.inputDataType);
        double[][] dArray = new double[components][CL_Initializer.numVoxels];
        for (n = 0; n < CL_Initializer.numVoxels; ++n) {
            try {
                double[] dArray2 = voxelOrderDataSource.nextVoxel();
                for (int i = 0; i < components; ++i) {
                    dArray[i][n] = dArray2[i];
                }
                continue;
            }
            catch (Exception exception) {
                LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            }
        }
        for (n = 0; n < components; ++n) {
            om.output(dArray[n]);
        }
        om.close();
    }
}

