/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.ModelFit;
import data.OutputManager;
import inverters.EvenSphHarmFitter;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;

public class VoxelClassify {
    private static Logger logger = Logger.getLogger("camino.apps.VoxelClassify");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        if (CL_Initializer.f1 > 0.0) {
            OutputManager.outputDataType = "int";
        }
        om = new OutputManager();
        EvenSphHarmFitter evenSphHarmFitter = new EvenSphHarmFitter(CL_Initializer.imPars, CL_Initializer.maxOrder);
        while (CL_Initializer.data.more()) {
            Object[] objectArray;
            try {
                double[] dArray = CL_Initializer.data.nextVoxel();
                objectArray = evenSphHarmFitter.fit(dArray);
                StackTraceElement stackTraceElement = objectArray[0];
                double d = Math.exp((double)objectArray[1]);
                double[] dArray2 = evenSphHarmFitter.getF_TestProbabilities((double[])objectArray, dArray);
                if (CL_Initializer.f1 > 0.0) {
                    try {
                        int n = ModelFit.isBG(d) || stackTraceElement < 0.0 ? -1 : (CL_Initializer.CSFTHRESHOLD > 0.0 && d > CL_Initializer.CSFTHRESHOLD ? 0 : evenSphHarmFitter.selectModel(dArray2, CL_Initializer.f1, CL_Initializer.f2, CL_Initializer.f3));
                        om.output(new double[]{n});
                    }
                    catch (Exception exception) {
                        LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
                    }
                    continue;
                }
                double[] dArray3 = new double[]{(double)objectArray[0], (double)objectArray[1]};
                om.output(dArray3);
                om.output(dArray2);
            }
            catch (Exception exception) {
                objectArray = exception.getStackTrace();
                String string = new String();
                logger.warning(exception.toString() + "  (Program will continue)");
                for (int i = 0; i < objectArray.length; ++i) {
                    string = string + objectArray[i] + "\n";
                }
                logger.warning(string);
            }
        }
        om.close();
    }
}

