/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.DataSource;
import data.OutputManager;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import misc.LoggedException;
import numerics.MTRandom;
import numerics.Point3D;
import numerics.RealMatrix;
import tools.CL_Initializer;
import tools.FileInput;
import tractography.BallStickTractographyImage;
import tractography.BayesDiracTractographyImage;
import tractography.DT_TractographyImage;
import tractography.DataModel;
import tractography.FACT_TendFibreTracker;
import tractography.FibreTracker;
import tractography.FreeFormROI;
import tractography.LinIntDTEulerFibreTracker;
import tractography.LinIntVectorEulerFibreTracker;
import tractography.NC_ProbFibreTracker;
import tractography.NonIntProbFibreTracker;
import tractography.NonInterpolatedFibreTracker;
import tractography.PD_TractographyImage;
import tractography.PICoPDF;
import tractography.PICoTractographyImage;
import tractography.PointListROI;
import tractography.RegionOfInterest;
import tractography.RepBS_DT_TractographyImage;
import tractography.StreamlineROI_Filter;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractographyImage;
import tractography.Voxel;
import tractography.VoxelList;
import tractography.WildBS_DT_TractographyImage;

public class StreamlineTractography {
    protected static int DEFAULT_PICO_ITERATIONS = 5000;
    private static Logger logger = Logger.getLogger("camino.apps.StreamlineTractography");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        if (stringArray.length == 0) {
            System.exit(0);
        }
        ImageType imageType = null;
        PICoPDF pICoPDF = PICoPDF.BINGHAM;
        String string = "dt";
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string2 = null;
        double d = 0.0;
        double d2 = 1.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = Math.cos(1.3962634015954636);
        double d14 = 0.0;
        String string3 = null;
        boolean bl7 = false;
        String string4 = null;
        RegionOfInterest regionOfInterest = null;
        int n11 = -1;
        int n12 = -1;
        String string5 = null;
        long l = System.currentTimeMillis();
        MTRandom mTRandom = null;
        String string6 = null;
        double d15 = 0.0;
        double d16 = 0.0;
        DataModel dataModel = DataModel.CYL_SYMM_DT;
        String string7 = null;
        String string8 = "double";
        CL_Initializer.inputDataType = "double";
        CL_Initializer.pointSetInd = 1;
        CL_Initializer.CL_init(stringArray);
        if (CL_Initializer.inputModel == null) {
            throw new LoggedException("An input model is required.");
        }
        if (CL_Initializer.inputModel.equals("bootstrap")) {
            if (CL_Initializer.bsDataFiles == null) {
                imageType = ImageType.WILD_BOOTSTRAP;
            } else {
                if (CL_Initializer.bsDataFiles.length == 1) {
                    throw new LoggedException("Can't do repetition bootstrap with a single image");
                }
                imageType = ImageType.BOOTSTRAP;
            }
            CL_Initializer.inputDataType = "float";
        }
        if (CL_Initializer.inputModel.equals("pico")) {
            imageType = ImageType.PICO;
        } else if (CL_Initializer.inputModel.equals("dt")) {
            imageType = ImageType.TENSOR;
        } else if (CL_Initializer.inputModel.equals("multitensor")) {
            imageType = ImageType.TENSOR;
        } else if (CL_Initializer.inputModel.equals("pds")) {
            imageType = ImageType.PDS;
        } else if (CL_Initializer.inputModel.equals("ballstick")) {
            imageType = ImageType.BALL_STICK;
        } else if (CL_Initializer.inputModel.equals("bayesdirac")) {
            CL_Initializer.inputDataType = "float";
            imageType = ImageType.BAYES_DIRAC;
        }
        boolean bl8 = OutputManager.gzipOut;
        RealMatrix realMatrix = null;
        RealMatrix realMatrix2 = null;
        boolean bl9 = true;
        boolean bl10 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-bsmodel")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-wildbsmodel")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-inputdatatype")) {
                CL_Initializer.inputDataType = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedpointmm")) {
                d9 = Double.parseDouble(stringArray[i + 1]);
                d10 = Double.parseDouble(stringArray[i + 2]);
                d11 = Double.parseDouble(stringArray[i + 3]);
                CL_Initializer.markAsParsed(i, 4);
                continue;
            }
            if (stringArray[i].equals("-seedpointvox")) {
                d9 = Double.parseDouble(stringArray[i + 1]);
                d10 = Double.parseDouble(stringArray[i + 2]);
                d11 = Double.parseDouble(stringArray[i + 3]);
                bl7 = true;
                CL_Initializer.markAsParsed(i, 4);
                continue;
            }
            if (stringArray[i].equals("-seedindex")) {
                int n13 = Integer.parseInt(stringArray[i + 1]);
                if (n13 <= 0) {
                    throw new LoggedException("Invalid seed index specified. Minimum index is 1");
                }
                n11 = n13 - 1;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-regionindex")) {
                n12 = Integer.parseInt(stringArray[i + 1]) - 1;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedfile")) {
                string3 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-seedlist")) {
                string4 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-randomseed") || stringArray[i].equals("-seed")) {
                l = Long.parseLong(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-anisthresh")) {
                d12 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-anisfile")) {
                string5 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-ipthresh")) {
                d13 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-curvethresh")) {
                d13 = Math.cos(Math.PI * Double.parseDouble(stringArray[i + 1]) / 180.0);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-stepsize")) {
                d14 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputtracts")) {
                if (i < stringArray.length - 1) {
                    if (stringArray[i + 1].equals("oogl")) {
                        bl2 = true;
                        CL_Initializer.markAsParsed(i, 2);
                        continue;
                    }
                    if (stringArray[i + 1].equals("ooglbinary")) {
                        bl3 = true;
                        bl2 = true;
                        CL_Initializer.markAsParsed(i, 2);
                        continue;
                    }
                    if (stringArray[i + 1].equals("voxels")) {
                        bl = true;
                        CL_Initializer.markAsParsed(i, 2);
                        continue;
                    }
                    if (stringArray[i + 1].equals("raw")) {
                        CL_Initializer.markAsParsed(i, 2);
                        continue;
                    }
                    CL_Initializer.markAsParsed(i);
                    continue;
                }
                CL_Initializer.markAsParsed(i, 1);
                continue;
            }
            if (stringArray[i].equals("-iterations")) {
                n4 = Integer.parseInt(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-pdf")) {
                CL_Initializer.markAsParsed(i);
                if (i == stringArray.length - 1) {
                    throw new LoggedException("Missing PDF type");
                }
                pICoPDF = PICoPDF.getPDF(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i + 1);
                continue;
            }
            if (stringArray[i].equals("-datamodel")) {
                dataModel = DataModel.getModel(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-curvepriork")) {
                d15 = Double.parseDouble(stringArray[i + 1]);
                d16 = 0.0;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-curvepriorg")) {
                d16 = Double.parseDouble(stringArray[i + 1]);
                d15 = 0.0;
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-extpriorfile")) {
                string7 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-extpriordatatype")) {
                string8 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputroot")) {
                string6 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-interpolated") || stringArray[i].equals("-interpolate")) {
                bl4 = true;
                CL_Initializer.markAsParsed(i);
                if (stringArray.length <= i + 1 || !stringArray[i + 1].equals("vectors")) continue;
                bl5 = true;
                CL_Initializer.markAsParsed(i + 1);
                continue;
            }
            if (stringArray[i].equals("-tendffile")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-tend")) {
                bl6 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-tendf")) {
                d = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-tendg")) {
                d2 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-transformation")) {
                realMatrix = StreamlineTractography.readMatrix(stringArray[i + 1]);
                realMatrix2 = StreamlineTractography.invertAffine(realMatrix);
                CL_Initializer.markAsParsed(i, 2);
                bl9 = false;
                continue;
            }
            if (!stringArray[i].equals("-silent")) continue;
            bl10 = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        if (string6 == null) {
            om = new OutputManager();
        }
        n8 = CL_Initializer.dataDims[0];
        n9 = CL_Initializer.dataDims[1];
        n10 = CL_Initializer.dataDims[2];
        d6 = CL_Initializer.voxelDims[0];
        d7 = CL_Initializer.voxelDims[1];
        d8 = CL_Initializer.voxelDims[2];
        if (bl9) {
            if (string3 != null) {
                try {
                    ImageHeader imageHeader = ImageHeader.readHeader(string3);
                    n5 = imageHeader.xDataDim();
                    n6 = imageHeader.yDataDim();
                    n7 = imageHeader.zDataDim();
                    d3 = imageHeader.xVoxelDim();
                    d4 = imageHeader.yVoxelDim();
                    d5 = imageHeader.zVoxelDim();
                    if (d3 < 0.0 || d4 < 0.0 || d5 < 0.0) {
                        logger.warning("Negative voxel size specified in seed file. Using absolute values.");
                        d3 = Math.abs(d3);
                        d4 = Math.abs(d4);
                        d5 = Math.abs(d5);
                    }
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
                if (n8 == 0 && n9 == 0 && n10 == 0) {
                    logger.info("No diffusion data dimensions given. Using seed space dimensions.");
                    n8 = n5;
                    n9 = n6;
                    n10 = n7;
                } else if (n8 != n5 || n9 != n6 || n10 != n7) {
                    bl9 = false;
                }
                if (d6 == 0.0 && d7 == 0.0 && d8 == 0.0) {
                    logger.info("No diffusion voxel dimensions given. Using seed space dimensions.");
                    d6 = d3;
                    d7 = d4;
                    d8 = d5;
                } else if (d6 != d3 || d7 != d4 || d8 != d5) {
                    bl9 = false;
                }
            } else {
                n5 = n8;
                n6 = n9;
                n7 = n10;
                d3 = d6;
                d4 = d7;
                d5 = d8;
            }
            if (n8 == 0 || n9 == 0 || n10 == 0) {
                throw new LoggedException("No data dimensions specified");
            }
            if (d6 == 0.0 || d7 == 0.0 || d8 == 0.0) {
                throw new LoggedException("No data dimensions specified");
            }
        }
        if (!bl9) {
            if (n8 == 0 || n9 == 0 || n10 == 0 || d6 == 0.0 || d7 == 0.0 || d8 == 0.0) {
                throw new LoggedException("Voxel and data dimensions of diffusion space must be specified when the seed space is not aligned to the diffusion space");
            }
            if (string3 != null) {
                try {
                    ImageHeader imageHeader = ImageHeader.readHeader(string3);
                    n5 = imageHeader.xDataDim();
                    n6 = imageHeader.yDataDim();
                    n7 = imageHeader.zDataDim();
                    d3 = Math.abs(imageHeader.xVoxelDim());
                    d4 = Math.abs(imageHeader.yVoxelDim());
                    d5 = Math.abs(imageHeader.zVoxelDim());
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
        }
        if (d14 == 0.0) {
            d14 = d8 / 10.0;
        }
        if (n11 > -1 && n12 > -1) {
            throw new LoggedException("Both -seedindex and -regionindex specified. Only one may be used.");
        }
        if (imageType != ImageType.TENSOR && d12 > 0.0 && string5 == null) {
            throw new LoggedException("Input model is not tensors, anisotropy map (-anisfile) must be supplied when -anisthresh is used");
        }
        mTRandom = new MTRandom(l);
        if (!imageType.probabilistic) {
            if (n4 != 0) {
                logger.warning("Iterations is set to " + n4 + " but input model is not probabilistic. " + "Proceeding with deterministic tracking.");
            }
            n4 = 1;
        } else if (n4 == 0) {
            n4 = DEFAULT_PICO_ITERATIONS;
        }
        if (string3 != null) {
            short[][][] sArray = StreamlineTractography.readShortVolume(string3);
            regionOfInterest = new FreeFormROI(sArray, d3, d4, d5);
        } else if (string4 != null) {
            regionOfInterest = PointListROI.readPoints(string4, new int[]{n5, n6, n7}, new double[]{d3, d4, d5});
        } else {
            short[][][] sArray = new short[n8][n9][n10];
            if (bl7) {
                sArray[(int)d9][(int)d10][(int)d11] = 1;
            } else {
                sArray[(int)(d9 / d6)][(int)(d10 / d7)][(int)(d11 / d8)] = 1;
            }
            regionOfInterest = new FreeFormROI(sArray, d6, d7, d8);
        }
        int n14 = regionOfInterest.numberOfRegions();
        int[][][] nArray = new int[n8][n9][n10];
        int[][][] nArray2 = new int[n8][n9][n10];
        for (n3 = 0; n3 < n10; ++n3) {
            for (n2 = 0; n2 < n9; ++n2) {
                for (n = 0; n < n8; ++n) {
                    nArray[n][n2][n3] = 0;
                    nArray2[n][n2][n3] = 1;
                }
            }
        }
        if (CL_Initializer.bgMaskFile != null) {
            CL_Initializer.initMaskSource();
            for (n3 = 0; n3 < n10; ++n3) {
                for (n2 = 0; n2 < n9; ++n2) {
                    for (n = 0; n < n8; ++n) {
                        double d17 = CL_Initializer.bgMask.nextVoxel()[0];
                        nArray[n][n2][n3] = d17 > 0.0 ? 0 : -1;
                        nArray2[n][n2][n3] = d17 > 0.0 ? 1 : 0;
                    }
                }
            }
        }
        if (CL_Initializer.voxelClassMap != null) {
            nArray = new int[n8][n9][n10];
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.voxelClassMap, 1, "int");
            for (n2 = 0; n2 < n10; ++n2) {
                for (n = 0; n < n9; ++n) {
                    for (int i = 0; i < n8; ++i) {
                        nArray[i][n][n2] = (int)voxelOrderDataSource.nextVoxel()[0];
                    }
                }
            }
        }
        double[][][] dArray = null;
        if (string5 != null) {
            if (ImageHeader.imageExists(string5)) {
                try {
                    ImageHeader imageHeader = ImageHeader.readHeader(string5);
                    dArray = imageHeader.readVolume(0);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            } else {
                dArray = new double[n8][n9][n10];
                VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string5, 1, CL_Initializer.inputDataType);
                for (n = 0; n < n10; ++n) {
                    for (int i = 0; i < n9; ++i) {
                        for (int j = 0; j < n8; ++j) {
                            dArray[j][i][n] = voxelOrderDataSource.nextVoxel()[0];
                        }
                    }
                }
            }
        }
        FibreTracker fibreTracker = null;
        TractographyImage tractographyImage = null;
        if (imageType.probabilistic) {
            switch (imageType) {
                case BOOTSTRAP: {
                    CL_Initializer.initImagingScheme();
                    if (string.equals("dt") || string.equals("multitensor")) {
                        tractographyImage = RepBS_DT_TractographyImage.getBS_TractographyImage(CL_Initializer.bsDataFiles, CL_Initializer.inputDataType, CL_Initializer.imPars, CL_Initializer.inversionIndices, nArray, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8}, mTRandom);
                        break;
                    }
                    throw new LoggedException("Unsupported bootstrap model : " + string);
                }
                case WILD_BOOTSTRAP: {
                    CL_Initializer.initImagingScheme();
                    if (string.equals("dt")) {
                        tractographyImage = WildBS_DT_TractographyImage.getBS_TractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.imPars, nArray, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8}, mTRandom);
                        break;
                    }
                    throw new LoggedException("Unsupported bootstrap model : " + string);
                }
                case PICO: {
                    tractographyImage = PICoTractographyImage.getPICoTractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.numPDsIO, pICoPDF, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8}, mTRandom);
                    break;
                }
                case BAYES_DIRAC: {
                    CL_Initializer.initImagingScheme();
                    BayesDiracTractographyImage bayesDiracTractographyImage = BayesDiracTractographyImage.getBayesDiracTractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.imPars, dataModel, nArray2, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8}, CL_Initializer.pointSetInd, mTRandom);
                    if (d15 > 0.0) {
                        bayesDiracTractographyImage.setCurvePriorKappa(d15);
                    }
                    if (d16 > 0.0) {
                        bayesDiracTractographyImage.setCurvePriorGamma(d16);
                    }
                    if (string7 != null) {
                        PICoTractographyImage pICoTractographyImage = PICoTractographyImage.getPICoTractographyImage(string7, string8, CL_Initializer.numPDsIO, pICoPDF, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8}, mTRandom);
                        bayesDiracTractographyImage.setExternalPriors(pICoTractographyImage);
                    }
                    tractographyImage = bayesDiracTractographyImage;
                    break;
                }
                default: {
                    throw new LoggedException("Unsupported image type : " + (Object)((Object)imageType));
                }
            }
            fibreTracker = bl4 ? new NC_ProbFibreTracker(tractographyImage, d14, d13, mTRandom) : new NonIntProbFibreTracker(tractographyImage, d13, mTRandom);
        } else {
            switch (imageType) {
                case PDS: {
                    tractographyImage = PD_TractographyImage.getPD_TractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.numPDsIO, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8});
                    if (bl4) {
                        fibreTracker = new LinIntVectorEulerFibreTracker(tractographyImage, d14, d13);
                        break;
                    }
                    fibreTracker = new NonInterpolatedFibreTracker(tractographyImage, d13);
                    break;
                }
                case BALL_STICK: {
                    tractographyImage = BallStickTractographyImage.getBallStickTractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8});
                    if (bl4) {
                        fibreTracker = new LinIntVectorEulerFibreTracker(tractographyImage, d14, d13);
                        break;
                    }
                    fibreTracker = new NonInterpolatedFibreTracker(tractographyImage, d13);
                    break;
                }
                case TENSOR: {
                    tractographyImage = DT_TractographyImage.getDT_TractographyImage(CL_Initializer.inputFile, CL_Initializer.inputDataType, CL_Initializer.numPDsIO, dArray, d12, new int[]{n8, n9, n10}, new double[]{d6, d7, d8});
                    if (bl4 && bl5) {
                        fibreTracker = new LinIntVectorEulerFibreTracker(tractographyImage, d14, d13);
                        break;
                    }
                    if (bl4) {
                        fibreTracker = new LinIntDTEulerFibreTracker((DT_TractographyImage)tractographyImage, d14, d13);
                        break;
                    }
                    if (bl6) {
                        if (string2 != null) {
                            try {
                                ImageHeader imageHeader = ImageHeader.readHeader(string2);
                                fibreTracker = new FACT_TendFibreTracker((DT_TractographyImage)tractographyImage, d13, imageHeader.readVolume(0), d2);
                                break;
                            }
                            catch (IOException iOException) {
                                throw new LoggedException(iOException);
                            }
                        }
                        fibreTracker = new FACT_TendFibreTracker((DT_TractographyImage)tractographyImage, d13, d, d2);
                        break;
                    }
                    fibreTracker = new NonInterpolatedFibreTracker(tractographyImage, d13);
                    break;
                }
                default: {
                    throw new LoggedException("Unsupported image type : " + (Object)((Object)imageType));
                }
            }
        }
        StreamlineROI_Filter streamlineROI_Filter = new StreamlineROI_Filter(n5, n6, n7, d3, d4, d5);
        if (!bl) {
            streamlineROI_Filter.setResampleTracts(false);
        }
        if (realMatrix != null) {
            streamlineROI_Filter.setTransIntoSeedSpace(realMatrix2);
        }
        int n15 = 0;
        for (int i = 0; i < regionOfInterest.numberOfRegions(); ++i) {
            if (n12 > -1 && i != n12) continue;
            RegionOfInterest regionOfInterest2 = regionOfInterest.getRegion(i);
            int n16 = i + 1;
            Point3D[] point3DArray = StreamlineTractography.transformPoints(regionOfInterest2.getSeedPoints(), realMatrix);
            PointListROI pointListROI = new PointListROI(point3DArray, new int[]{n8, n9, n10}, new double[]{d6, d7, d8});
            Voxel[] voxelArray = pointListROI.getVoxels();
            if (n11 == -1) {
                if (!bl10) {
                    System.err.println("Processing ROI " + n16 + " of " + n14);
                }
            } else {
                if (point3DArray.length + n15 - 1 < n11) {
                    n15 += point3DArray.length;
                    continue;
                }
                if (n15 > n11) break;
                if (!bl10) {
                    System.err.println("Processing ROI " + n16 + " of " + n14);
                }
            }
            FileOutputStream fileOutputStream = null;
            DataOutputStream dataOutputStream = null;
            try {
                if (string6 == null) {
                    dataOutputStream = om.getOutputStream();
                } else if (bl2) {
                    if (bl8) {
                        fileOutputStream = new FileOutputStream(string6 + n16 + ".oogl.gz");
                        dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)fileOutputStream, 0x1000000));
                    } else {
                        fileOutputStream = new FileOutputStream(string6 + n16 + ".oogl");
                        dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x1000000));
                    }
                } else if (bl) {
                    if (bl8) {
                        fileOutputStream = new FileOutputStream(string6 + n16 + ".Bshort.gz");
                        dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)fileOutputStream, 0x1000000));
                    } else {
                        fileOutputStream = new FileOutputStream(string6 + n16 + ".Bshort");
                        dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x1000000));
                    }
                } else if (bl8) {
                    fileOutputStream = new FileOutputStream(string6 + n16 + ".Bfloat.gz");
                    dataOutputStream = new DataOutputStream(new GZIPOutputStream((OutputStream)fileOutputStream, 0x1000000));
                } else {
                    fileOutputStream = new FileOutputStream(string6 + n16 + ".Bfloat");
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x1000000));
                }
                if (bl2) {
                    dataOutputStream.write(new String("LIST\n").getBytes());
                }
                for (int j = 0; j < point3DArray.length; ++j) {
                    if (n11 > -1 && n15 != n11) {
                        ++n15;
                        continue;
                    }
                    ++n15;
                    if (!bl10) {
                        System.err.print("\rProcessing seed " + (j + 1) + " of " + point3DArray.length);
                    }
                    Point3D point3D = point3DArray[j];
                    int n17 = voxelArray[j].x;
                    int n18 = voxelArray[j].y;
                    int n19 = voxelArray[j].z;
                    int n20 = tractographyImage.numberOfPDs(n17, n18, n19);
                    n20 = n20 == 0 ? 1 : n20;
                    for (int k = 0; k < n20; ++k) {
                        for (int i2 = 0; i2 < n4; ++i2) {
                            TractCollection tractCollection = streamlineROI_Filter.processTracts(fibreTracker.trackFromSeed(point3D, k));
                            Tract tract = tractCollection.getTract(0);
                            if (bl2) {
                                if (bl3) {
                                    tract.writeOOGL_BinaryVECT(dataOutputStream);
                                    continue;
                                }
                                dataOutputStream.write(tract.toOOGLVECT().getBytes());
                                continue;
                            }
                            if (bl) {
                                VoxelList voxelList = tract.toVoxelList(d3, d4, d5);
                                voxelList.writeVoxelList(dataOutputStream);
                                continue;
                            }
                            tract.writeRaw(dataOutputStream);
                        }
                    }
                }
                if (!bl10) {
                    System.err.println("\n");
                }
                if (string6 == null) continue;
                dataOutputStream.close();
                continue;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        if (om != null) {
            om.close();
        }
    }

    protected static short[][][] readShortVolume(String string) {
        try {
            short[][][] sArray = null;
            ImageHeader imageHeader = ImageHeader.readHeader(string);
            int n = imageHeader.xDataDim();
            int n2 = imageHeader.yDataDim();
            int n3 = imageHeader.zDataDim();
            sArray = new short[n][n2][n3];
            DataSource dataSource = imageHeader.getImageDataSource();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        double d = dataSource.nextVoxel()[0];
                        if (!(d > 0.0)) continue;
                        if (d > 32767.0) {
                            throw new LoggedException("Maximum value allowed for seeds / waypoints / targets is 32767");
                        }
                        sArray[k][j][i] = (short)Math.round(d);
                    }
                }
            }
            return sArray;
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    private static RealMatrix readMatrix(String string) {
        FileInput fileInput = new FileInput(string);
        double[][] dArray = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            String[] stringArray = fileInput.readString().split("\\s+");
            for (int j = 0; j < 4; ++j) {
                dArray[i][j] = Double.parseDouble(stringArray[j]);
            }
        }
        RealMatrix realMatrix = new RealMatrix(4, 4);
        realMatrix.entries = dArray;
        return realMatrix;
    }

    private static Point3D[] transformPoints(Point3D[] point3DArray, RealMatrix realMatrix) {
        if (realMatrix == null) {
            return point3DArray;
        }
        double[][] dArray = realMatrix.entries;
        int n = point3DArray.length;
        Point3D[] point3DArray2 = new Point3D[n + 1];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[3];
        for (int i = 0; i < n; ++i) {
            dArray2[0] = point3DArray[i].x;
            dArray2[1] = point3DArray[i].y;
            dArray2[2] = point3DArray[i].z;
            dArray2[3] = 1.0;
            dArray3[0] = dArray[0][0] * dArray2[1] + dArray[0][1] * dArray2[0] + dArray[0][2] * dArray2[2] + dArray[0][3] * dArray2[3];
            dArray3[1] = dArray[1][0] * dArray2[1] + dArray[1][1] * dArray2[0] + dArray[1][2] * dArray2[2] + dArray[1][3] * dArray2[3];
            dArray3[2] = dArray[2][0] * dArray2[1] + dArray[2][1] * dArray2[0] + dArray[2][2] * dArray2[2] + dArray[2][3] * dArray2[3];
            point3DArray2[i] = new Point3D(dArray3);
        }
        return point3DArray2;
    }

    private static RealMatrix invertAffine(RealMatrix realMatrix) {
        throw new LoggedException("-transformation option is not yet supported");
    }

    public static enum ImageType {
        PICO(true),
        BOOTSTRAP(true),
        WILD_BOOTSTRAP(true),
        BAYES_DIRAC(true),
        BAYES_MCMC(true),
        TENSOR(false),
        PDS(false),
        BALL_STICK(false);

        final boolean probabilistic;

        private ImageType(boolean bl) {
            this.probabilistic = bl;
        }
    }
}

