/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.DataSource;
import data.VoxelOrderDataSource;
import imaging.ImageHeader;
import imaging.MetaImageHeader;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.Vector3D;
import tools.CL_Initializer;

public class RGB_ScalarImage {
    public static final int BUFFERSIZE = 0x1000000;
    protected Vector3D[][][][] vectors = null;
    protected double[][][] scalarVol = null;
    protected double[][][] normScalarVol = null;
    private double[][][] red = null;
    private double[][][] green = null;
    private double[][][] blue = null;
    private static Logger logger = Logger.getLogger("camino.apps.RGB_ScalarImage");
    protected int xDataDim = 0;
    protected int yDataDim = 0;
    protected int zDataDim = 0;
    protected double xVoxelDim = 1.0;
    protected double yVoxelDim = 1.0;
    protected double zVoxelDim = 1.0;
    protected double minScalarValue = 0.0;
    protected double maxScalarValue = 0.0;
    private double gsGamma = 1.0;
    private double rgbGamma = 1.0;

    public RGB_ScalarImage(Vector3D[][][][] vector3DArray, double[] dArray, double[][][] dArray2, double d, double d2) {
        this.vectors = vector3DArray;
        this.scalarVol = dArray2;
        this.xDataDim = vector3DArray.length;
        this.yDataDim = vector3DArray[0].length;
        this.zDataDim = vector3DArray[0][0].length;
        this.xVoxelDim = dArray[0];
        this.yVoxelDim = dArray[1];
        this.zVoxelDim = dArray[2];
        this.setNormalizedScalars(d, d2);
        this.calculateRGB();
    }

    public void writeImage(String string) throws IOException {
        if (string.endsWith(".mha") || string.endsWith(".mhd")) {
            this.writeMeta(string);
        } else if (string.endsWith(".vtk")) {
            this.writeVTK(string);
        } else {
            logger.warning("No recognized extension to file " + string + " - image not written");
        }
    }

    public void writeMeta(String string) throws IOException {
        String string2 = null;
        string2 = string.endsWith(".mha") ? string : string + ".mha";
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string2), 0x1000000));
        MetaImageHeader metaImageHeader = new MetaImageHeader();
        metaImageHeader.dataType = MetaImageHeader.DataType.UCHAR;
        metaImageHeader.channels = 3;
        metaImageHeader.dimSize[0] = this.xDataDim;
        metaImageHeader.dimSize[1] = this.yDataDim;
        metaImageHeader.dimSize[2] = this.zDataDim;
        metaImageHeader.spacing[0] = this.xVoxelDim;
        metaImageHeader.spacing[1] = this.yVoxelDim;
        metaImageHeader.spacing[2] = this.zVoxelDim;
        metaImageHeader.dataFile = "LOCAL";
        metaImageHeader.writeHeader(dataOutputStream);
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    int n = this.rgbIndex(k, j, i);
                    dataOutputStream.writeByte((byte)(n >> 16));
                    dataOutputStream.writeByte((byte)(n >> 8 & 0xFF));
                    dataOutputStream.writeByte((byte)(n & 0xFF));
                }
            }
        }
        dataOutputStream.close();
    }

    public void writeVTK(String string) throws IOException {
        String string2 = null;
        string2 = string.endsWith(".vtk") ? string : string + ".vtk";
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string2), 0x1000000));
        dataOutputStream.write(new String("# vtk DataFile Version 2.0\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("Camino RGB-scalar image\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("BINARY\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("DATASET STRUCTURED_POINTS\n").getBytes("US-ASCII"));
        String string3 = "DIMENSIONS " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim + "\n";
        dataOutputStream.write(new String(string3).getBytes("US-ASCII"));
        String string4 = "SPACING " + this.xVoxelDim + " " + this.yVoxelDim + " " + this.zVoxelDim + "\n";
        dataOutputStream.write(string4.getBytes("US-ASCII"));
        dataOutputStream.write(new String("ORIGIN 0 0 0\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("POINT_DATA " + this.xDataDim * this.yDataDim * this.zDataDim + "\n").getBytes("US-ASCII"));
        dataOutputStream.write(new String("COLOR_SCALARS scalars 3\n").getBytes("US-ASCII"));
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    int n = this.rgbIndex(k, j, i);
                    dataOutputStream.writeByte((byte)(n >> 16));
                    dataOutputStream.writeByte((byte)(n >> 8 & 0xFF));
                    dataOutputStream.writeByte((byte)(n & 0xFF));
                }
            }
        }
        dataOutputStream.close();
    }

    protected final int rgbIndex(int n, int n2, int n3) {
        double d = Math.pow(this.red[n][n2][n3], this.rgbGamma);
        double d2 = Math.pow(this.green[n][n2][n3], this.rgbGamma);
        double d3 = Math.pow(this.blue[n][n2][n3], this.rgbGamma);
        double d4 = Math.pow(this.normScalarVol[n][n2][n3], this.gsGamma);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n4 = (int)(255.0 * d4 * d);
        n5 = (int)(255.0 * d4 * d2);
        n6 = (int)(255.0 * d4 * d3);
        return n6 + 256 * (n5 + 256 * n4);
    }

    void calculateScalarRange(double d) {
        int n;
        int n2;
        int n3 = 0;
        double[] dArray = new double[this.xDataDim * this.yDataDim * this.zDataDim];
        for (n2 = 0; n2 < this.zDataDim; ++n2) {
            for (n = 0; n < this.yDataDim; ++n) {
                for (int i = 0; i < this.xDataDim; ++i) {
                    dArray[n3++] = this.scalarVol[i][n][n2];
                }
            }
        }
        Arrays.sort(dArray);
        n2 = (int)(d * (double)dArray.length);
        n = dArray.length - n2 - 1;
        this.minScalarValue = dArray[n2];
        this.maxScalarValue = dArray[n];
        if (!(this.maxScalarValue < Double.MAX_VALUE)) {
            while (n >= 0 && !(this.maxScalarValue <= Double.MAX_VALUE)) {
                this.maxScalarValue = dArray[--n];
            }
        }
        if (!(this.minScalarValue > -1.7976931348623157E308)) {
            while (n2 < dArray.length - 1 && !(this.minScalarValue >= -1.7976931348623157E308)) {
                this.minScalarValue = dArray[++n2];
            }
        }
    }

    public void setNormalizedScalars(double d) {
        if (!(d >= 0.0) || !(d < 1.0)) {
            throw new LoggedException("Fraction of scalar values to exclude was : " + d);
        }
        this.calculateScalarRange(d);
        this.setNormalizedScalars();
    }

    public void setNormalizedScalars(double d, double d2) {
        if (d == d2) {
            this.calculateScalarRange(0.005);
        } else {
            this.minScalarValue = d;
            this.maxScalarValue = d2;
        }
        this.setNormalizedScalars();
    }

    private void setNormalizedScalars() {
        this.normScalarVol = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.normScalarVol[k][j][i] = this.scalarVol[k][j][i] < this.minScalarValue ? 0.0 : (this.scalarVol[k][j][i] > this.maxScalarValue ? 1.0 : (this.maxScalarValue - this.minScalarValue != 0.0 ? (this.scalarVol[k][j][i] - this.minScalarValue) / (this.maxScalarValue - this.minScalarValue) : 1.0));
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        DataSource dataSource;
        Object object;
        CL_Initializer.inputDataType = "double";
        CL_Initializer.maxTensorComponents = 1;
        CL_Initializer.inputModel = "dteig";
        CL_Initializer.numPDsIO = -1;
        CL_Initializer.CL_init(stringArray);
        String string = "meta";
        String string2 = "";
        String string3 = "bingham";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string4 = null;
        double d6 = 1.0;
        double d7 = 1.0;
        int n4 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-outputroot")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-outputformat")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-scalarrange")) {
                d4 = Double.parseDouble(stringArray[i + 1]);
                d5 = Double.parseDouble(stringArray[i + 2]);
                CL_Initializer.markAsParsed(i, 3);
            }
            if (stringArray[i].equals("-scalarfile")) {
                string4 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-gsgamma")) {
                d6 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-rgbgamma")) {
                d7 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
            }
            if (stringArray[i].equals("-e1")) {
                n4 = 0;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-e2")) {
                n4 = 1;
                CL_Initializer.markAsParsed(i);
            }
            if (stringArray[i].equals("-e3")) {
                n4 = 2;
                CL_Initializer.markAsParsed(i);
            }
            if (!stringArray[i].equals("-pdf")) continue;
            string3 = stringArray[i + 1];
            CL_Initializer.markAsParsed(i, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        if (CL_Initializer.numPDsIO < 0) {
            CL_Initializer.numPDsIO = CL_Initializer.inputModel.equals("pds") ? 3 : 1;
        }
        n = CL_Initializer.dataDims[0];
        n2 = CL_Initializer.dataDims[1];
        n3 = CL_Initializer.dataDims[2];
        d = CL_Initializer.voxelDims[0];
        d2 = CL_Initializer.voxelDims[1];
        d3 = CL_Initializer.voxelDims[2];
        double[][][] dArray = null;
        if (string4 != null) {
            object = null;
            dataSource = null;
            if (ImageHeader.imageExists(string4)) {
                try {
                    object = ImageHeader.readHeader(string4);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
                int[] nArray = new int[]{n, n2, n3};
                double[] dArray2 = new double[]{d, d2, d3};
                ImageHeader.checkDims(string4, nArray, dArray2);
                n = nArray[0];
                n2 = nArray[1];
                n3 = nArray[2];
                d = Math.abs(dArray2[0]);
                d2 = Math.abs(dArray2[1]);
                d3 = Math.abs(dArray2[2]);
                dataSource = ((ImageHeader)object).getImageDataSource();
            } else {
                dataSource = new VoxelOrderDataSource(string4, 1, CL_Initializer.inputDataType);
            }
            dArray = new double[n][n2][n3];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        dArray[k][j][i] = dataSource.nextVoxel()[0];
                    }
                }
            }
        }
        object = null;
        if (CL_Initializer.inputModel.equals("dteig")) {
            dataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 12 * CL_Initializer.maxTensorComponents, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromTensorEigenSys(dataSource, new int[]{n, n2, n3}, new double[]{d, d2, d3}, dArray, d4, d5, n4);
        } else if (CL_Initializer.inputModel.equals("pds")) {
            dataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 6 + 8 * CL_Initializer.numPDsIO, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromSphFuncPDs(dataSource, new int[]{n, n2, n3}, new double[]{d, d2, d3}, dArray, d4, d5);
        } else if (CL_Initializer.inputModel.equals("pico")) {
            int n5 = 1;
            if (string3.equals("bingham")) {
                n5 = 2;
            }
            if (string3.equals("acg")) {
                n5 = 3;
            }
            VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 1 + (10 + n5) * CL_Initializer.numPDsIO, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromPICoPDFs(voxelOrderDataSource, CL_Initializer.numPDsIO, n5, new int[]{n, n2, n3}, new double[]{d, d2, d3}, dArray, d4, d5);
        } else if (CL_Initializer.inputModel.equals("ballstick")) {
            dataSource = new VoxelOrderDataSource(CL_Initializer.inputFile, 7, CL_Initializer.inputDataType);
            object = RGB_ScalarImage.imageFromBallStick(dataSource, new int[]{n, n2, n3}, new double[]{d, d2, d3}, dArray, d4, d5);
        } else {
            throw new LoggedException("Unrecognized input model " + CL_Initializer.inputModel);
        }
        ((RGB_ScalarImage)object).setScalarGamma(d6);
        ((RGB_ScalarImage)object).setRGB_Gamma(d7);
        try {
            if (string.equals("meta")) {
                ((RGB_ScalarImage)object).writeMeta(string2);
            } else if (string.equals("vtk")) {
                ((RGB_ScalarImage)object).writeVTK(string2);
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    protected void calculateRGB() {
        if (this.red == null) {
            this.red = new double[this.xDataDim][this.yDataDim][this.zDataDim];
            this.green = new double[this.xDataDim][this.yDataDim][this.zDataDim];
            this.blue = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        }
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    double d = Math.abs(this.vectors[k][j][i][0].x);
                    double d2 = Math.abs(this.vectors[k][j][i][0].y);
                    double d3 = Math.abs(this.vectors[k][j][i][0].z);
                    if (this.vectors[k][j][i].length > 1) {
                        Vector3D vector3D = new Vector3D(Math.abs(this.vectors[k][j][i][0].x) + Math.abs(this.vectors[k][j][i][1].x), Math.abs(this.vectors[k][j][i][0].y) + Math.abs(this.vectors[k][j][i][1].y), Math.abs(this.vectors[k][j][i][0].z) + Math.abs(this.vectors[k][j][i][1].z)).normalized();
                        d = vector3D.x;
                        d2 = vector3D.y;
                        d3 = vector3D.z;
                    }
                    this.red[k][j][i] = d;
                    this.green[k][j][i] = d2;
                    this.blue[k][j][i] = d3;
                }
            }
        }
    }

    public static RGB_ScalarImage imageFromSphFuncPDs(VoxelOrderDataSource voxelOrderDataSource, int[] nArray, double[] dArray, double[][][] dArray2, double d, double d2) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        double[][][] dArray3 = new double[n][n2][n3];
        Vector3D[][][][] vector3DArray = new Vector3D[n][n2][n3][];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    double[] dArray4 = voxelOrderDataSource.nextVoxel();
                    Vector3D vector3D = null;
                    Vector3D vector3D2 = null;
                    vector3D = new Vector3D(dArray4[6], dArray4[7], dArray4[8]);
                    dArray3[k][j][i] = Math.abs(dArray4[10] + dArray4[13]);
                    if (!(dArray3[k][j][i] > 0.0)) {
                        dArray3[k][j][i] = 0.0;
                    }
                    if (dArray4[2] >= 2.0) {
                        vector3D2 = new Vector3D(dArray4[14], dArray4[15], dArray4[16]);
                    }
                    vector3DArray[k][j][i] = vector3D2 == null ? new Vector3D[]{vector3D} : new Vector3D[]{vector3D, vector3D2};
                }
            }
        }
        if (dArray2 == null) {
            dArray2 = dArray3;
        }
        return new RGB_ScalarImage(vector3DArray, dArray, dArray2, d, d2);
    }

    public static RGB_ScalarImage imageFromPICoPDFs(VoxelOrderDataSource voxelOrderDataSource, int n, int n2, int[] nArray, double[] dArray, double[][][] dArray2, double d, double d2) {
        return RGB_ScalarImage.imageFromPICoPDFs(voxelOrderDataSource, n, n2, nArray, dArray, dArray2, d, d2, 0);
    }

    public static RGB_ScalarImage imageFromPICoPDFs(VoxelOrderDataSource voxelOrderDataSource, int n, int n2, int[] nArray, double[] dArray, double[][][] dArray2, double d, double d2, int n3) {
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        Vector3D[][][][] vector3DArray = new Vector3D[n4][n5][n6][];
        double[][][] dArray3 = new double[n4][n5][n6];
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n4; ++k) {
                    int n7;
                    double[] dArray4 = voxelOrderDataSource.nextVoxel();
                    int n8 = (int)dArray4[0];
                    Vector3D vector3D = new Vector3D(dArray4[2 + 3 * n3], dArray4[3 + 3 * n3], dArray4[4 + 3 * n3]);
                    Vector3D vector3D2 = null;
                    for (n7 = 0; n7 < n2; ++n7) {
                        double[] dArray5 = dArray3[k][j];
                        int n9 = i;
                        dArray5[n9] = dArray5[n9] + Math.abs(dArray4[11 + n7]);
                    }
                    if (n8 >= 2) {
                        n7 = 11 + n2;
                        vector3D2 = new Vector3D(dArray4[n7 + 1 + 3 * n3], dArray4[n7 + 2 + 3 * n3], dArray4[n7 + 3 + 3 * n3]);
                        double d3 = 0.0;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            d3 += Math.abs(dArray4[n7 + 10 + i2]);
                        }
                        dArray3[k][j][i] = (dArray3[k][j][i] + d3) / 2.0;
                    }
                    vector3DArray[k][j][i] = vector3D2 == null ? new Vector3D[]{vector3D} : new Vector3D[]{vector3D, vector3D2};
                }
            }
        }
        if (dArray2 == null) {
            dArray2 = dArray3;
        }
        return new RGB_ScalarImage(vector3DArray, dArray, dArray2, d, d2);
    }

    public static RGB_ScalarImage imageFromBallStick(VoxelOrderDataSource voxelOrderDataSource, int[] nArray, double[] dArray, double[][][] dArray2, double d, double d2) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        double[][][] dArray3 = new double[n][n2][n3];
        Vector3D[][][][] vector3DArray = new Vector3D[n][n2][n3][];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    double[] dArray4 = voxelOrderDataSource.nextVoxel();
                    Object var17_15 = null;
                    vector3DArray[k][j][i] = new Vector3D[]{new Vector3D(dArray4[4], dArray4[5], dArray4[6])};
                    dArray3[k][j][i] = Math.abs(dArray4[3]);
                    if (dArray3[k][j][i] >= 0.0) continue;
                    dArray3[k][j][i] = 0.0;
                }
            }
        }
        if (dArray2 == null) {
            dArray2 = dArray3;
        }
        return new RGB_ScalarImage(vector3DArray, dArray, dArray2, d, d2);
    }

    public static RGB_ScalarImage imageFromTensorEigenSys(VoxelOrderDataSource voxelOrderDataSource, int[] nArray, double[] dArray, double[][][] dArray2, double d, double d2) {
        return RGB_ScalarImage.imageFromTensorEigenSys(voxelOrderDataSource, nArray, dArray, dArray2, d, d2, 0);
    }

    public static RGB_ScalarImage imageFromTensorEigenSys(VoxelOrderDataSource voxelOrderDataSource, int[] nArray, double[] dArray, double[][][] dArray2, double d, double d2, int n) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        Vector3D[][][][] vector3DArray = new Vector3D[n2][n3][n4][];
        double[][][] dArray3 = new double[n2][n3][n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double[] dArray4 = voxelOrderDataSource.nextVoxel();
                    Vector3D vector3D = null;
                    switch (n) {
                        case 0: {
                            vector3D = new Vector3D(dArray4[1], dArray4[2], dArray4[3]);
                            break;
                        }
                        case 1: {
                            vector3D = new Vector3D(dArray4[5], dArray4[6], dArray4[7]);
                            break;
                        }
                        case 2: {
                            vector3D = new Vector3D(dArray4[9], dArray4[10], dArray4[11]);
                            break;
                        }
                        default: {
                            throw new LoggedException("Invalid eigenvector index " + n);
                        }
                    }
                    Vector3D vector3D2 = null;
                    double d3 = (dArray4[0] + dArray4[4] + dArray4[8]) / 3.0;
                    if (d3 > 0.0) {
                        dArray3[k][j][i] = Math.sqrt(1.5 * ((dArray4[0] - d3) * (dArray4[0] - d3) + (dArray4[4] - d3) * (dArray4[4] - d3) + (dArray4[8] - d3) * (dArray4[8] - d3)) / (dArray4[0] * dArray4[0] + dArray4[4] * dArray4[4] + dArray4[8] * dArray4[8]));
                    }
                    if (!(dArray3[k][j][i] >= 0.0) || !(dArray3[k][j][i] < 1.0)) {
                        if (dArray3[k][j][i] < 0.0) {
                            dArray3[k][j][i] = 0.0;
                        } else if (dArray3[k][j][i] > 1.0) {
                            dArray3[k][j][i] = 1.0;
                        }
                    }
                    if (dArray4.length > 12 && (d3 = (dArray4[12] + dArray4[16] + dArray4[20]) / 3.0) > 0.0) {
                        switch (n) {
                            case 0: {
                                vector3D2 = new Vector3D(dArray4[13], dArray4[14], dArray4[15]);
                                break;
                            }
                            case 1: {
                                vector3D2 = new Vector3D(dArray4[17], dArray4[18], dArray4[19]);
                                break;
                            }
                            case 2: {
                                vector3D2 = new Vector3D(dArray4[21], dArray4[22], dArray4[23]);
                                break;
                            }
                            default: {
                                throw new LoggedException("Invalid eigenvector index " + n);
                            }
                        }
                        double d4 = Math.sqrt(1.5 * ((dArray4[12] - d3) * (dArray4[12] - d3) + (dArray4[16] - d3) * (dArray4[16] - d3) + (dArray4[20] - d3) * (dArray4[20] - d3)) / (dArray4[12] * dArray4[12] + dArray4[16] * dArray4[16] + dArray4[20] * dArray4[20]));
                        if (d4 < 0.0) {
                            d4 = 0.0;
                        } else if (d4 > 1.0) {
                            d4 = 1.0;
                        }
                        dArray3[k][j][i] = (dArray3[k][j][i] + d4) / 2.0;
                    }
                    vector3DArray[k][j][i] = vector3D2 == null ? new Vector3D[]{vector3D} : new Vector3D[]{vector3D, vector3D2};
                }
            }
        }
        if (dArray2 == null) {
            dArray2 = dArray3;
        }
        return new RGB_ScalarImage(vector3DArray, dArray, dArray2, d, d2);
    }

    public void setRGB_Gamma(double d) {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException("Cannot use gamma value " + d);
        }
        this.rgbGamma = d;
    }

    public double rgbGamma() {
        return this.rgbGamma;
    }

    public void setScalarGamma(double d) {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException("Cannot use gamma value " + d);
        }
        this.gsGamma = d;
    }

    public double scalarGamma() {
        return this.gsGamma;
    }

    public double[] getVoxelDims() {
        return new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim};
    }
}

