/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import imaging.Scheme;
import java.util.logging.Logger;
import misc.SphericalPoints;
import numerics.RealMatrix;
import sphfunc.BasisSumFactory;
import sphfunc.LinearBasisFunction;
import sphfunc.LinearBasisSum;
import sphfunc.RBF_Sum;
import sphfunc.TuchRBF_Sum;
import tools.CL_Initializer;

public class QBallMX {
    private static Logger logger = Logger.getLogger("apps/QBallMX");
    private static double dataSmoothSigma = 0.1308996938995747;
    private static OutputManager om;

    public static void main(String[] stringArray) {
        RealMatrix realMatrix;
        Object object;
        int n;
        int n2;
        CL_Initializer.CL_init(stringArray);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-smoothingsigma")) continue;
            dataSmoothSigma = Double.parseDouble(stringArray[n2 + 1]);
            CL_Initializer.markAsParsed(n2, 2);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        om = new OutputManager();
        n2 = CL_Initializer.basisType;
        LinearBasisSum linearBasisSum = BasisSumFactory.getBasisSum(n2);
        LinearBasisFunction linearBasisFunction = null;
        logger.info("BASIS FUNCTION SETTINGS:");
        logger.info(linearBasisSum.getSettings());
        Scheme scheme = CL_Initializer.imPars;
        double[][] dArray = scheme.getNormNonZeroQs();
        int n3 = dArray.length;
        double[][] dArray2 = SphericalPoints.getElecPointSet(linearBasisSum.numBasisFunctions());
        int n4 = dArray2.length;
        RealMatrix realMatrix2 = new RealMatrix(n3, linearBasisSum.numBasisFunctions());
        for (int i = 0; i < linearBasisSum.numBasisFunctions(); ++i) {
            linearBasisFunction = linearBasisSum.basisFunction(i);
            for (n = 0; n < n3; ++n) {
                realMatrix2.setEntry(n, i, linearBasisFunction.getRadius(dArray[n][0], dArray[n][1], dArray[n][2]));
            }
        }
        RealMatrix realMatrix3 = new RealMatrix(n4, linearBasisSum.numBasisFunctions());
        for (n = 0; n < linearBasisSum.numBasisFunctions(); ++n) {
            linearBasisFunction = linearBasisSum.basisFunction(n);
            for (int i = 0; i < n4; ++i) {
                realMatrix3.setEntry(i, n, linearBasisFunction.greatCircleIntegral(dArray2[i]));
            }
        }
        if (n2 != 1) {
            object = new RealMatrix(n4, linearBasisSum.numBasisFunctions());
            for (int i = 0; i < linearBasisSum.numBasisFunctions(); ++i) {
                linearBasisFunction = linearBasisSum.basisFunction(i);
                for (int j = 0; j < n4; ++j) {
                    ((RealMatrix)object).setEntry(j, i, linearBasisFunction.getRadius(dArray2[j][0], dArray2[j][1], dArray2[j][2]));
                }
            }
            RealMatrix realMatrix4 = ((RealMatrix)object).pseudoInv();
            if (n2 == 1) {
                realMatrix4 = QBallMX.tuchsNormalization(realMatrix4, n4);
            }
            RealMatrix realMatrix5 = realMatrix2.pseudoInv();
            realMatrix = realMatrix4.product(realMatrix3);
            realMatrix = realMatrix.product(realMatrix5);
        } else {
            RBF_Sum.setPoints(dArray);
            TuchRBF_Sum.setSigma(dataSmoothSigma);
            linearBasisSum = BasisSumFactory.getBasisSum(n2);
            logger.info("SMOOTHING FUNCTION SETTINGS:");
            logger.info(linearBasisSum.getSettings());
            object = new RealMatrix(n3, linearBasisSum.numBasisFunctions());
            for (int i = 0; i < linearBasisSum.numBasisFunctions(); ++i) {
                linearBasisFunction = linearBasisSum.basisFunction(i);
                for (int j = 0; j < n3; ++j) {
                    ((RealMatrix)object).setEntry(j, i, linearBasisFunction.getRadius(dArray[j][0], dArray[j][1], dArray[j][2]));
                }
            }
            realMatrix2 = realMatrix2.pseudoInv();
            object = QBallMX.tuchsNormalization((RealMatrix)object, n3);
            realMatrix = realMatrix3.product(realMatrix2);
            realMatrix = realMatrix.product((RealMatrix)object);
        }
        object = new double[realMatrix.columns()];
        for (int i = 0; i < realMatrix.rows(); ++i) {
            for (int j = 0; j < realMatrix.columns(); ++j) {
                object[j] = realMatrix.entries[i][j];
            }
            om.output((double[])object);
        }
        om.close();
    }

    private static RealMatrix tuchsNormalization(RealMatrix realMatrix, int n) {
        int n2;
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < n; ++i) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + realMatrix.entry(n2, i);
            }
        }
        RealMatrix realMatrix2 = new RealMatrix(n, n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                d = realMatrix.entry(i, j) / dArray[j];
                realMatrix2.setEntry(j, i, d);
            }
        }
        return realMatrix2;
    }
}

