/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.FileOutput;

public class PointSetToScheme {
    private static final Logger logger = Logger.getLogger("apps.PointSetToScheme");

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        double d = CL_Initializer.modQ;
        double d2 = CL_Initializer.diffusionTime;
        int n = CL_Initializer.M;
        int n2 = CL_Initializer.N;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Locale.setDefault(Locale.UK);
        double d3 = 0.0;
        boolean bl4 = false;
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-fixedbvalue")) {
                n = Integer.parseInt(stringArray[i + 1]);
                n2 = Integer.parseInt(stringArray[i + 2]);
                d3 = Double.parseDouble(stringArray[i + 3]);
                d2 = Double.parseDouble(stringArray[i + 4]);
                d = Math.sqrt(d3 / d2);
                CL_Initializer.markAsParsed(i, 5);
                continue;
            }
            if (stringArray[i].equals("-usegradmod")) {
                bl4 = true;
                logger.info("Gradient direction magnitude will be incorporated into b-values");
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipx")) {
                bl = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipy")) {
                bl2 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (!stringArray[i].equals("-flipz")) continue;
            bl3 = true;
            CL_Initializer.markAsParsed(i);
        }
        CL_Initializer.checkParsing(stringArray);
        try {
            int n3;
            double[][] dArray = PointSetToScheme.readPoints(CL_Initializer.inputFile, bl, bl2, bl3);
            double[] dArray2 = PointSetToScheme.getPointModulus(dArray);
            dArray = PointSetToScheme.normalizePoints(dArray);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(d2 + "\n");
            stringBuffer.append(n2 + n + "\n");
            for (n3 = 0; n3 < n; ++n3) {
                stringBuffer.append("0.0\n0.0\n0.0\n");
            }
            n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (bl4) {
                        stringBuffer.append(decimalFormat.format(dArray[i][j] * d * dArray2[i]) + "\n");
                        continue;
                    }
                    if (dArray2[i] != 0.0 && !(Math.abs(1.0 - dArray2[i]) < 1.0E-5)) {
                        n3 = 1;
                    }
                    stringBuffer.append(decimalFormat.format(dArray[i][j] * d) + "\n");
                }
            }
            if (OutputManager.outputFile == null) {
                System.out.print(stringBuffer.toString());
            } else {
                FileOutput fileOutput = new FileOutput(OutputManager.outputFile);
                fileOutput.writeString(stringBuffer.toString());
                fileOutput.close();
            }
            if (n3 != 0) {
                logger.warning("Some measurements have non-unit gradient directions. Directions have been normalized to unit length");
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
    }

    public static double[][] readPoints(String string) throws IOException {
        return PointSetToScheme.readPoints(string, false, false, false);
    }

    public static double[][] readPoints(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Object object;
        Vector<String> vector = new Vector<String>();
        Scanner scanner = null;
        scanner = string == null ? new Scanner(System.in) : new Scanner(new File(string));
        scanner.useDelimiter("\r\n|\n");
        while (scanner.hasNext()) {
            String string2 = scanner.next();
            if (string2.length() <= 0) continue;
            vector.add(string2);
        }
        scanner.close();
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        try {
            object = ((String)vector.elementAt(0)).trim().split("\\s+");
            n = Integer.parseInt(object[0]);
            if (n == (vector.size() - 1) / 3 || n == vector.size() - 1) {
                bl4 = true;
            } else {
                if (((String[])object).length != 3) {
                    throw new LoggedException("Unknown point set format");
                }
                n = vector.size();
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = vector.size();
        }
        if (bl4) {
            try {
                Double.parseDouble(((String)vector.elementAt(1)).trim());
                bl5 = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl5 = false;
            }
        }
        object = new double[n][3];
        if (bl5) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double d = Double.parseDouble((String)vector.elementAt(i * 3 + j + 1));
                    object[i][j] = (String)d;
                }
            }
        } else {
            int n2 = bl4 ? 1 : 0;
            for (int i = 0; i < n; ++i) {
                String[] stringArray = ((String)vector.elementAt(i + n2)).trim().split("\\s+");
                if (stringArray.length > 3) {
                    throw new LoggedException("Unknown point set format");
                }
                for (int j = 0; j < 3; ++j) {
                    double d = Double.parseDouble(stringArray[j]);
                    object[i][j] = (String)d;
                }
            }
        }
        return object;
    }

    public static double[] getPointModulus(double[][] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.sqrt(dArray[i][0] * dArray[i][0] + dArray[i][1] * dArray[i][1] + dArray[i][2] * dArray[i][2]);
        }
        return dArray2;
    }

    public static double[][] normalizePoints(double[][] dArray) {
        int n = dArray.length;
        double[][] dArray2 = new double[n][3];
        for (int i = 0; i < n; ++i) {
            double d = Math.sqrt(dArray[i][0] * dArray[i][0] + dArray[i][1] * dArray[i][1] + dArray[i][2] * dArray[i][2]);
            if (Math.abs(1.0 - d) > 1.0E-6 && d > 0.0) {
                dArray[i][0] = dArray[i][0] / d;
                dArray[i][1] = dArray[i][1] / d;
                dArray[i][2] = dArray[i][2] / d;
            }
            for (int j = 0; j < 3; ++j) {
                if (dArray[i][j] != 0.0) continue;
                dArray[i][j] = Math.abs(dArray[i][j]);
            }
        }
        return dArray;
    }
}

