/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.FracAnis;
import apps.ModelFit;
import data.OutputManager;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import tools.CL_Initializer;

public class MeanDiff {
    private static Logger logger = Logger.getLogger("camino.apps.TraceD");
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.inputModel = "dt";
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initTensorDataSource();
        om = new OutputManager();
        while (CL_Initializer.data.more()) {
            try {
                int n;
                double[] dArray = CL_Initializer.data.nextVoxel();
                DT[] dTArray = FracAnis.getTensorList(dArray, CL_Initializer.inputModel);
                double[] dArray2 = new double[dTArray.length];
                if (dArray[0] >= 0.0 && !ModelFit.isBG(Math.exp(dArray[1]))) {
                    for (n = 0; n < dTArray.length; ++n) {
                        dArray2[n] = dTArray[n].trace() / 3.0;
                    }
                } else {
                    for (n = 0; n < dTArray.length; ++n) {
                        dArray2[n] = 0.0;
                    }
                }
                om.output(dArray2);
            }
            catch (Exception exception) {
                LoggedException.logExceptionWarning(exception, Thread.currentThread().getName());
            }
        }
        om.close();
    }
}

