/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.VoxelOrderDataSource;
import inverters.EvenSphHarmFitter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tools.CL_Initializer;

public class F_TestThresholdSelector
extends JPanel {
    private JFrame frame;
    private JPanel thresholdSelectionPanel;
    private JPanel sliceSelectionPanel;
    private TopPanel topPanel;
    private JList sliceList;
    private boolean autoUpdate = false;
    private boolean updateNeeded = false;
    private FTestThresholdSelectionPanel thresholdPanel;
    private BufferedImage slice;
    private static final int XY = 100;
    private static final int XZ = 200;
    private static final int YZ = 300;
    private int sliceOrientation = -1;
    private double f1 = 0.0;
    private double f2 = 0.0;
    private double f3 = 0.0;
    private static final double DEFAULT_F1 = 1.0E-20;
    private static final double DEFAULT_F2 = 1.0E-6;
    private static final double DEFAULT_F3 = 1.0E-6;
    private double BACKGROUNDTHRESHOLD = 0.0;
    private double CSFTHRESHOLD = -1.0;
    private double[][][][] fStats;
    private int[][][] classes;
    private int xSize;
    private int ySize;
    private int zSize;
    private int order;
    private int xySliceMarker = 0;
    private int xzSliceMarker = 0;
    private int yzSliceMarker = 0;
    private double xScale = 0.0;
    private double yScale = 0.0;
    private double[] fractions = null;
    private final MouseAdapter mouseClickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            F_TestThresholdSelector.this.setSliceMarkers(mouseEvent);
        }
    };

    public F_TestThresholdSelector(double[][][][] dArray, int n, double d, double d2) {
        this(dArray, CL_Initializer.maxOrder, CL_Initializer.BACKGROUNDTHRESHOLD, CL_Initializer.CSFTHRESHOLD, 1.0E-20, 1.0E-6, 1.0E-6);
    }

    public F_TestThresholdSelector(double[][][][] dArray, int n, double d, double d2, double d3, double d4, double d5) {
        this.f1 = d3;
        this.f2 = d4;
        this.f3 = d5;
        this.BACKGROUNDTHRESHOLD = d;
        this.CSFTHRESHOLD = d2;
        this.fStats = dArray;
        this.xSize = this.fStats[0].length;
        this.ySize = this.fStats[0][0].length;
        this.zSize = this.fStats[0][0][0].length;
        this.order = n;
        this.classes = new int[this.xSize][this.ySize][this.zSize];
        this.frame = new JFrame("F Test Threshold Selection");
        this.frame.setDefaultCloseOperation(3);
        this.sliceOrientation = 100;
        this.initSliceSelectionPanel();
        this.addMouseListener(this.mouseClickListener);
        this.thresholdSelectionPanel = new FTestThresholdSelectionPanel(this);
        this.topPanel = new TopPanel(this);
        this.update();
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.getContentPane().add((Component)this.sliceSelectionPanel, "East");
        this.frame.getContentPane().add((Component)this.thresholdSelectionPanel, "South");
        this.frame.getContentPane().add((Component)this.topPanel, "North");
        this.frame.pack();
        this.frame.setSize(600, 600);
        this.frame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.UK);
        CL_Initializer.inputDataType = "double";
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        int n = CL_Initializer.dataDims[0];
        int n2 = CL_Initializer.dataDims[1];
        int n3 = CL_Initializer.dataDims[2];
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new RuntimeException("F_TestThresholdSelector -inputfile <data file> -datadims [x y z] [-order <max order>] [-bgthresh <voxels with q0 below this set to background] [-csfthresh <voxels with q0 above this set to order 0, default infinity>]");
        }
        int n4 = CL_Initializer.maxOrder / 2 * (CL_Initializer.maxOrder / 2 + 1) / 2 + 2;
        double[][][][] dArray = F_TestThresholdSelector.loadData(CL_Initializer.inputFile, n, n2, n3, n4, CL_Initializer.inputDataType);
        if (CL_Initializer.f1 > 0.0) {
            double d = CL_Initializer.f1;
            double d2 = CL_Initializer.f2;
            double d3 = CL_Initializer.f3;
            F_TestThresholdSelector f_TestThresholdSelector = new F_TestThresholdSelector(dArray, CL_Initializer.maxOrder, CL_Initializer.BACKGROUNDTHRESHOLD, CL_Initializer.CSFTHRESHOLD, d, d2, d3);
        } else {
            F_TestThresholdSelector f_TestThresholdSelector = new F_TestThresholdSelector(dArray, CL_Initializer.maxOrder, CL_Initializer.BACKGROUNDTHRESHOLD, CL_Initializer.CSFTHRESHOLD);
        }
    }

    public static double[][][][] loadData(String string, int n, int n2, int n3, int n4, String string2) {
        double[][][][] dArray = new double[n4][n][n2][n3];
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n4, string2);
        try {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        double[] dArray2 = voxelOrderDataSource.nextVoxel();
                        for (int i2 = 0; i2 < n4; ++i2) {
                            dArray[i2][k][j][i] = dArray2[i2];
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        return dArray;
    }

    private void setUpdateNeeded() {
        this.updateNeeded = true;
        if (this.autoUpdate) {
            this.update();
        }
    }

    public boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public void toggleAutoUpdate() {
        this.autoUpdate = !this.autoUpdate;
    }

    public void update() {
        this.doModelSelection();
        this.setSlice();
        this.topPanel.setFractions(this.fractions);
        this.updateNeeded = false;
    }

    public void setFTestThresholds(double d, double d2, double d3) {
        this.f1 = d;
        this.f2 = d2;
        this.f3 = d3;
        this.setUpdateNeeded();
    }

    public void setSliceOrientation(int n) {
        this.sliceOrientation = n;
        this.setSliceListModel();
        this.setSlice();
    }

    public void setSliceMarkers(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.xySliceMarker = 0;
            this.xzSliceMarker = 0;
            this.yzSliceMarker = 0;
            this.repaint();
            return;
        }
        int n = (int)Math.round((double)mouseEvent.getX() / this.xScale);
        int n2 = (int)Math.round((double)mouseEvent.getY() / this.yScale);
        switch (this.sliceOrientation) {
            case 100: {
                this.xySliceMarker = this.sliceList.getSelectedIndex();
                this.xzSliceMarker = n2 < this.ySize - 1 ? this.ySize - n2 - 1 : 0;
                this.yzSliceMarker = n < this.xSize - 1 ? n : 0;
                break;
            }
            case 200: {
                this.xzSliceMarker = this.sliceList.getSelectedIndex();
                this.xySliceMarker = n2 < this.zSize - 1 ? this.zSize - n2 - 1 : 0;
                this.yzSliceMarker = n < this.xSize - 1 ? n : 0;
                break;
            }
            case 300: {
                this.yzSliceMarker = this.sliceList.getSelectedIndex();
                this.xySliceMarker = this.zSize - n2 - 1;
                this.xzSliceMarker = n < this.ySize - 1 ? n : 0;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
        this.repaint();
    }

    private void initSliceSelectionPanel() {
        this.sliceList = new JList();
        this.sliceSelectionPanel = new JPanel(new BorderLayout());
        this.setSliceListModel();
        this.sliceList.setBackground(Color.white);
        this.sliceList.setFixedCellWidth(22);
        this.sliceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (F_TestThresholdSelector.this.sliceList.getSelectedIndex() > -1) {
                    F_TestThresholdSelector.this.setSlice();
                }
            }
        });
        this.sliceList.setSelectionMode(0);
        this.sliceList.setPrototypeCellValue("10000");
        JScrollPane jScrollPane = new JScrollPane(this.sliceList);
        this.sliceSelectionPanel.add(jScrollPane);
    }

    protected void setSliceListModel() {
        DefaultListModel<Integer> defaultListModel = new DefaultListModel<Integer>();
        int n = 0;
        switch (this.sliceOrientation) {
            case 100: {
                n = this.zSize;
                break;
            }
            case 200: {
                n = this.ySize;
                break;
            }
            case 300: {
                n = this.xSize;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(new Integer(i));
        }
        this.sliceList.setModel(defaultListModel);
        switch (this.sliceOrientation) {
            case 100: {
                this.sliceList.setSelectedIndex(this.xySliceMarker);
                break;
            }
            case 200: {
                this.sliceList.setSelectedIndex(this.xzSliceMarker);
                break;
            }
            case 300: {
                this.sliceList.setSelectedIndex(this.yzSliceMarker);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
    }

    public void setSlice() {
        int n = this.sliceList.getSelectedIndex();
        switch (this.sliceOrientation) {
            case 100: {
                this.slice = new BufferedImage(this.xSize, this.ySize, 1);
                for (int i = 0; i < this.xSize; ++i) {
                    for (int j = 0; j < this.ySize; ++j) {
                        int n2;
                        int n3 = n2 = 40 * (this.classes[i][j][n] + 1);
                        int n4 = n2;
                        int n5 = 128;
                        int n6 = n4 + 256 * (n3 + 256 * n2);
                        this.slice.setRGB(i, this.ySize - 1 - j, n6);
                    }
                }
                break;
            }
            case 200: {
                this.slice = new BufferedImage(this.xSize, this.zSize, 1);
                for (int i = 0; i < this.xSize; ++i) {
                    for (int j = 0; j < this.zSize; ++j) {
                        int n7;
                        int n8 = n7 = 40 * (this.classes[i][n][j] + 1);
                        int n9 = n7;
                        int n10 = 128;
                        int n11 = n9 + 256 * (n8 + 256 * n7);
                        this.slice.setRGB(i, this.zSize - 1 - j, n11);
                    }
                }
                break;
            }
            case 300: {
                this.slice = new BufferedImage(this.ySize, this.zSize, 1);
                for (int i = 0; i < this.ySize; ++i) {
                    for (int j = 0; j < this.zSize; ++j) {
                        int n12;
                        int n13 = n12 = 40 * (this.classes[n][i][j] + 1);
                        int n14 = n12;
                        int n15 = 128;
                        int n16 = n14 + 256 * (n13 + 256 * n12);
                        this.slice.setRGB(i, this.zSize - 1 - j, n16);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
        this.repaint();
    }

    private void doModelSelection() {
        int n;
        int[] nArray = new int[this.order / 2 + 1];
        int n2 = 0;
        for (n = 0; n < this.zSize; ++n) {
            for (int i = 0; i < this.ySize; ++i) {
                for (int j = 0; j < this.xSize; ++j) {
                    double d = this.fStats[0][j][i][n];
                    double d2 = Math.exp(this.fStats[1][j][i][n]);
                    if (d < 0.0 || d2 < this.BACKGROUNDTHRESHOLD) {
                        this.classes[j][i][n] = -1;
                    } else if (this.CSFTHRESHOLD > 0.0 && d2 > this.CSFTHRESHOLD) {
                        this.classes[j][i][n] = 0;
                    } else {
                        double[] dArray = new double[this.fStats.length - 2];
                        for (int k = 0; k < dArray.length; ++k) {
                            dArray[k] = this.fStats[k + 2][j][i][n];
                        }
                        this.classes[j][i][n] = EvenSphHarmFitter.selectModel(dArray, this.order, this.f1, this.f2, this.f3);
                    }
                    if (this.classes[j][i][n] < 0) continue;
                    int n3 = this.classes[j][i][n] / 2;
                    nArray[n3] = nArray[n3] + 1;
                    ++n2;
                }
            }
        }
        this.fractions = new double[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            this.fractions[n] = (double)nArray[n] / (double)n2;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        this.xScale = dimension.getWidth() / (double)this.slice.getWidth();
        this.yScale = dimension.getHeight() / (double)this.slice.getHeight();
        if (this.xScale < this.yScale) {
            this.yScale = this.xScale;
        } else {
            this.xScale = this.yScale;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.scale(this.xScale, this.yScale);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.drawImage((Image)this.slice, 0, 0, this);
        graphics2D.setColor(Color.red);
        switch (this.sliceOrientation) {
            case 100: {
                if (this.xzSliceMarker > 0) {
                    graphics2D.drawLine(0, this.ySize - 1 - this.xzSliceMarker, this.slice.getWidth() - 1, this.ySize - 1 - this.xzSliceMarker);
                }
                if (this.yzSliceMarker <= 0) break;
                graphics2D.drawLine(this.yzSliceMarker, 0, this.yzSliceMarker, this.slice.getHeight() - 1);
                break;
            }
            case 200: {
                if (this.xySliceMarker > 0) {
                    graphics2D.drawLine(0, this.zSize - 1 - this.xySliceMarker, this.slice.getWidth() - 1, this.zSize - 1 - this.xySliceMarker);
                }
                if (this.yzSliceMarker <= 0) break;
                graphics2D.drawLine(this.yzSliceMarker, 0, this.yzSliceMarker, this.slice.getHeight() - 1);
                break;
            }
            case 300: {
                if (this.xySliceMarker > 0) {
                    graphics2D.drawLine(0, this.zSize - 1 - this.xySliceMarker, this.slice.getWidth() - 1, this.zSize - 1 - this.xySliceMarker);
                }
                if (this.xzSliceMarker <= 0) break;
                graphics2D.drawLine(this.xzSliceMarker, 0, this.xzSliceMarker, this.slice.getHeight() - 1);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognised plane index " + this.sliceOrientation);
            }
        }
    }

    private void saveVCImage(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 0x400000));
            for (int i = 0; i < this.zSize; ++i) {
                for (int j = 0; j < this.ySize; ++j) {
                    for (int k = 0; k < this.xSize; ++k) {
                        dataOutputStream.writeInt(this.classes[k][j][i]);
                    }
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    protected class TopPanel
    extends JPanel {
        private F_TestThresholdSelector container;
        private JButton axialButton;
        private JButton coronalButton;
        private JButton sagittalButton;
        private JButton exitButton;
        private JButton saveButton;
        private JLabel fractionLabel;

        public TopPanel(F_TestThresholdSelector f_TestThresholdSelector2) {
            this.container = f_TestThresholdSelector2;
            this.setLayout(new GridLayout(2, 1));
            this.initComponents();
        }

        private void initComponents() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel(new GridLayout(1, 5));
            this.axialButton = new JButton("AXIAL");
            this.axialButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TopPanel.this.container.setSliceOrientation(100);
                }
            });
            jPanel2.add(this.axialButton);
            this.coronalButton = new JButton("CORONAL");
            this.coronalButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TopPanel.this.container.setSliceOrientation(200);
                }
            });
            jPanel2.add(this.coronalButton);
            this.sagittalButton = new JButton("SAGITTAL");
            this.sagittalButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TopPanel.this.container.setSliceOrientation(300);
                }
            });
            jPanel2.add(this.sagittalButton);
            this.saveButton = new JButton("Save");
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TopPanel.this.save();
                }
            });
            jPanel2.add(this.saveButton);
            this.exitButton = new JButton("Exit");
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            jPanel2.add(this.exitButton);
            this.fractionLabel = new JLabel();
            jPanel.add(this.fractionLabel);
            this.add(jPanel);
            this.add(jPanel2);
        }

        public void save() {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                try {
                    this.container.saveVCImage(jFileChooser.getSelectedFile().getCanonicalPath());
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }

        public void setFractions(double[] dArray) {
            DecimalFormat decimalFormat = new DecimalFormat("00.00");
            String string = "<html>";
            Font font = this.fractionLabel.getFont();
            this.fractionLabel.setFont(new Font(font.getName(), 0, 14));
            double d = 0.0;
            int n = 3;
            if (F_TestThresholdSelector.this.order / 2 + 1 < 3) {
                n = F_TestThresholdSelector.this.order / 2 + 1;
            }
            for (int i = 0; i < n; ++i) {
                string = string + "<FONT COLOR=\"FF6633\"><b>Order " + i * 2 + ":</b> </FONT>" + decimalFormat.format(dArray[i] * 100.0) + " % ";
                d += dArray[i];
                string = string + " &nbsp &nbsp &nbsp &nbsp ";
            }
            string = string + "<FONT COLOR=\"FF6633\"><b>Others:</b> </FONT>" + decimalFormat.format((1.0 - d) * 100.0) + " % ";
            string = string + "</html>";
            this.fractionLabel.setText(string);
        }
    }

    protected class FTestThresholdSelectionPanel
    extends JPanel {
        private double f1 = 0.0;
        private double f2 = 0.0;
        private double f3 = 0.0;
        private JScrollBar f1Controller;
        private JScrollBar f2Controller;
        private JScrollBar f3Controller;
        private JTextField f1Box;
        private JTextField f2Box;
        private JTextField f3Box;
        private int SCROLLRANGE = 50;
        private JButton updateButton;
        private JCheckBox autoUpdateCheck;
        private F_TestThresholdSelector container;

        protected FTestThresholdSelectionPanel(F_TestThresholdSelector f_TestThresholdSelector2) {
            this.container = f_TestThresholdSelector2;
            this.setLayout(new GridLayout(2, 4));
            this.f1 = f_TestThresholdSelector2.f1;
            this.f2 = f_TestThresholdSelector2.f2;
            this.f3 = f_TestThresholdSelector2.f3;
            this.initComponents();
        }

        private void initComponents() {
            this.f1Controller = new JScrollBar(0, this.SCROLLRANGE / 2, 1, 0, this.SCROLLRANGE);
            this.f2Controller = new JScrollBar(0, this.SCROLLRANGE / 2, 1, 0, this.SCROLLRANGE);
            this.f3Controller = new JScrollBar(0, this.SCROLLRANGE / 2, 1, 0, this.SCROLLRANGE);
            this.f1Controller.setUnitIncrement(1);
            this.f1Controller.setBlockIncrement(5);
            this.f2Controller.setUnitIncrement(1);
            this.f2Controller.setBlockIncrement(5);
            this.f3Controller.setUnitIncrement(1);
            this.f3Controller.setBlockIncrement(5);
            this.f1Controller.setValue((int)Math.round(Math.log(this.f1) / Math.log(10.0)) + this.SCROLLRANGE);
            this.f2Controller.setValue((int)Math.round(Math.log(this.f2) / Math.log(10.0)) + this.SCROLLRANGE);
            this.f3Controller.setValue((int)Math.round(Math.log(this.f3) / Math.log(10.0)) + this.SCROLLRANGE);
            this.f1 = Math.pow(10.0, (double)this.f1Controller.getValue() - 50.0);
            this.f2 = Math.pow(10.0, (double)this.f2Controller.getValue() - 50.0);
            this.f3 = Math.pow(10.0, (double)this.f3Controller.getValue() - 50.0);
            this.f1Controller.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    int n = adjustmentEvent.getValue();
                    double d = Math.pow(10.0, n - FTestThresholdSelectionPanel.this.SCROLLRANGE);
                    FTestThresholdSelectionPanel.this.f1 = d;
                    FTestThresholdSelectionPanel.this.syncBoxesToScrollers();
                    FTestThresholdSelectionPanel.this.container.setFTestThresholds(FTestThresholdSelectionPanel.this.f1, FTestThresholdSelectionPanel.this.f2, FTestThresholdSelectionPanel.this.f3);
                }
            });
            this.f2Controller.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    int n = adjustmentEvent.getValue();
                    double d = Math.pow(10.0, n - FTestThresholdSelectionPanel.this.SCROLLRANGE);
                    FTestThresholdSelectionPanel.this.f2 = d;
                    FTestThresholdSelectionPanel.this.syncBoxesToScrollers();
                    FTestThresholdSelectionPanel.this.container.setFTestThresholds(FTestThresholdSelectionPanel.this.f1, FTestThresholdSelectionPanel.this.f2, FTestThresholdSelectionPanel.this.f3);
                }
            });
            this.f3Controller.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    int n = adjustmentEvent.getValue();
                    double d = Math.pow(10.0, n - FTestThresholdSelectionPanel.this.SCROLLRANGE);
                    FTestThresholdSelectionPanel.this.f3 = d;
                    FTestThresholdSelectionPanel.this.syncBoxesToScrollers();
                    FTestThresholdSelectionPanel.this.container.setFTestThresholds(FTestThresholdSelectionPanel.this.f1, FTestThresholdSelectionPanel.this.f2, FTestThresholdSelectionPanel.this.f3);
                }
            });
            this.add(this.f1Controller);
            this.add(this.f2Controller);
            this.add(this.f3Controller);
            this.autoUpdateCheck = new JCheckBox("Auto-Update", this.container.getAutoUpdate());
            this.autoUpdateCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FTestThresholdSelectionPanel.this.container.toggleAutoUpdate();
                }
            });
            this.add(this.autoUpdateCheck);
            this.f1Box = new JTextField();
            this.f1Box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        double d = Double.parseDouble(FTestThresholdSelectionPanel.this.f1Box.getText());
                        FTestThresholdSelectionPanel.this.f1Controller.setValue((int)Math.round(Math.log(d) / Math.log(10.0)) + FTestThresholdSelectionPanel.this.SCROLLRANGE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("NumberFormatException when changing f1");
                    }
                }
            });
            this.f1Box.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    double d = Double.parseDouble(FTestThresholdSelectionPanel.this.f1Box.getText());
                    FTestThresholdSelectionPanel.this.f1Controller.setValue((int)Math.round(Math.log(d) / Math.log(10.0)) + FTestThresholdSelectionPanel.this.SCROLLRANGE);
                }
            });
            this.f2Box = new JTextField();
            this.f2Box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        double d = Double.parseDouble(FTestThresholdSelectionPanel.this.f2Box.getText());
                        FTestThresholdSelectionPanel.this.f2Controller.setValue((int)Math.round(Math.log(d) / Math.log(10.0)) + FTestThresholdSelectionPanel.this.SCROLLRANGE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("NumberFormatException when changing f2");
                    }
                }
            });
            this.f2Box.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    double d = Double.parseDouble(FTestThresholdSelectionPanel.this.f2Box.getText());
                    FTestThresholdSelectionPanel.this.f2Controller.setValue((int)Math.round(Math.log(d) / Math.log(10.0)) + FTestThresholdSelectionPanel.this.SCROLLRANGE);
                }
            });
            this.f3Box = new JTextField();
            this.f3Box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        double d = Double.parseDouble(FTestThresholdSelectionPanel.this.f3Box.getText());
                        FTestThresholdSelectionPanel.this.f3Controller.setValue((int)Math.round(Math.log(d) / Math.log(10.0)) + FTestThresholdSelectionPanel.this.SCROLLRANGE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("NumberFormatException when changing f3");
                    }
                }
            });
            this.f3Box.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    double d = Double.parseDouble(FTestThresholdSelectionPanel.this.f3Box.getText());
                    FTestThresholdSelectionPanel.this.f3Controller.setValue((int)Math.round(Math.log(d) / Math.log(10.0)) + FTestThresholdSelectionPanel.this.SCROLLRANGE);
                }
            });
            this.add(this.f1Box);
            this.add(this.f2Box);
            this.add(this.f3Box);
            this.updateButton = new JButton("Update");
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        FTestThresholdSelectionPanel.this.f1 = Double.parseDouble(FTestThresholdSelectionPanel.this.f1Box.getText());
                        FTestThresholdSelectionPanel.this.f2 = Double.parseDouble(FTestThresholdSelectionPanel.this.f2Box.getText());
                        FTestThresholdSelectionPanel.this.f3 = Double.parseDouble(FTestThresholdSelectionPanel.this.f3Box.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(actionEvent);
                    }
                    FTestThresholdSelectionPanel.this.container.setFTestThresholds(FTestThresholdSelectionPanel.this.f1, FTestThresholdSelectionPanel.this.f2, FTestThresholdSelectionPanel.this.f3);
                    FTestThresholdSelectionPanel.this.container.update();
                }
            });
            this.add(this.updateButton);
            this.syncBoxesToScrollers();
        }

        private void syncBoxesToScrollers() {
            DecimalFormat decimalFormat = new DecimalFormat("0.00E00");
            this.f1Box.setText(decimalFormat.format(this.f1));
            this.f2Box.setText(decimalFormat.format(this.f2));
            this.f3Box.setText(decimalFormat.format(this.f3));
        }
    }
}

