/*
 * Decompiled with CFR 0.152.
 */
package apps;

import java.text.DecimalFormat;
import java.util.Locale;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.CL_Initializer;
import tools.FileInput;
import tools.FileOutput;

public class FSL_ToScheme {
    private static final Logger logger = Logger.getLogger("apps.FSL_ToScheme");

    public static void main(String[] stringArray) {
        int n;
        Locale.setDefault(Locale.UK);
        String string = null;
        String string2 = null;
        String string3 = null;
        double d = 1.0;
        double d2 = 1000000.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 2;
        boolean bl4 = false;
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-bvecfile") || stringArray[i].equals("-bvecs")) {
                string = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-bvalfile") || stringArray[i].equals("-bvals")) {
                string2 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-outputfile")) {
                string3 = stringArray[i + 1];
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-diffusiontime")) {
                d = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-bscale")) {
                d2 = Double.parseDouble(stringArray[i + 1]);
                CL_Initializer.markAsParsed(i, 2);
                continue;
            }
            if (stringArray[i].equals("-usegradmod")) {
                bl4 = true;
                logger.info("Gradient direction magnitude will be incorporated into b-value");
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipx")) {
                bl = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipy")) {
                bl2 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (stringArray[i].equals("-flipz")) {
                bl3 = true;
                CL_Initializer.markAsParsed(i);
                continue;
            }
            if (!stringArray[i].equals("-version")) continue;
            n2 = Integer.parseInt(stringArray[i + 1]);
            CL_Initializer.markAsParsed(i, 2);
        }
        String string4 = "";
        CL_Initializer.checkParsing(stringArray);
        FileInput fileInput = new FileInput(string);
        String[] stringArray2 = fileInput.readString().trim().split("\\s+");
        String[] stringArray3 = fileInput.readString().trim().split("\\s+");
        String[] stringArray4 = fileInput.readString().trim().split("\\s+");
        fileInput.close();
        FileInput fileInput2 = new FileInput(string2);
        String[] stringArray5 = fileInput2.readString().trim().split("\\s+");
        if (stringArray5.length != stringArray2.length) {
            throw new LoggedException("Number of b-vectors and b-values do not match");
        }
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.000000");
        DecimalFormat decimalFormat3 = new DecimalFormat("   0.000E00");
        boolean bl5 = false;
        if (n2 == 0) {
            string4 = string4 + d + "\n";
            string4 = string4 + stringArray2.length + "\n";
            for (n = 0; n < stringArray2.length; ++n) {
                double d3;
                double d4;
                double d5 = Math.sqrt(Double.parseDouble(stringArray5[n]) * d2 / d);
                double d6 = Double.parseDouble(stringArray2[n]);
                double d7 = Math.sqrt(d6 * d6 + (d4 = Double.parseDouble(stringArray3[n])) * d4 + (d3 = Double.parseDouble(stringArray4[n])) * d3);
                if (d7 == 0.0 || Math.abs(1.0 - d7) < 1.0E-5) {
                    d7 = 1.0;
                }
                if (bl4) {
                    d5 *= d7;
                } else if (d7 != 1.0) {
                    bl5 = true;
                }
                double d8 = d6 / d7 * d5;
                if (bl && d8 != 0.0) {
                    d8 = -d8;
                }
                double d9 = d4 / d7 * d5;
                if (bl2 && d9 != 0.0) {
                    d9 = -d9;
                }
                double d10 = d3 / d7 * d5;
                if (bl3 && d10 != 0.0) {
                    d10 = -d10;
                }
                string4 = string4 + decimalFormat2.format(d8) + "\n";
                string4 = string4 + decimalFormat2.format(d9) + "\n";
                string4 = string4 + decimalFormat2.format(d10) + "\n";
            }
        } else if (n2 == 2) {
            string4 = string4 + "VERSION: 2\n";
            for (n = 0; n < stringArray2.length; ++n) {
                double d11;
                double d12;
                double d13 = Double.parseDouble(stringArray2[n]);
                double d14 = Math.sqrt(d13 * d13 + (d12 = Double.parseDouble(stringArray3[n])) * d12 + (d11 = Double.parseDouble(stringArray4[n])) * d11);
                if (d14 == 0.0 || Math.abs(1.0 - d14) < 1.0E-5) {
                    d14 = 1.0;
                }
                if (!bl4 && d14 != 1.0) {
                    bl5 = true;
                }
                if (bl && (d13 /= d14) != 0.0) {
                    d13 = -d13;
                }
                if (bl2 && (d12 /= d14) != 0.0) {
                    d12 = -d12;
                }
                if (bl3 && (d11 /= d14) != 0.0) {
                    d11 = -d11;
                }
                if (d13 == 0.0) {
                    d13 = Math.abs(d13);
                }
                if (d12 == 0.0) {
                    d12 = Math.abs(d12);
                }
                if (d11 == 0.0) {
                    d11 = Math.abs(d11);
                }
                string4 = string4 + decimalFormat.format(d13);
                string4 = string4 + decimalFormat.format(d12);
                string4 = string4 + decimalFormat.format(d11);
                string4 = bl4 ? string4 + decimalFormat3.format(Double.parseDouble(stringArray5[n]) * d2 * d14 * d14) + "\n" : string4 + decimalFormat3.format(Double.parseDouble(stringArray5[n]) * d2) + "\n";
            }
        }
        if (bl5) {
            logger.warning("Some measurements have non-unit gradient directions. Directions have been normalized to unit length");
        }
        if (string3 != null) {
            FileOutput fileOutput = new FileOutput(string3);
            fileOutput.writeString(string4);
            fileOutput.close();
        } else {
            System.out.println(string4);
        }
    }
}

