/*
 * Decompiled with CFR 0.152.
 */
package apps;

import data.OutputManager;
import data.VoxelOrderDataSource;
import java.io.DataOutputStream;
import java.util.logging.Logger;
import numerics.SphericalHarmonics;
import tools.CL_Initializer;

public class DeconvToCamenoFormat {
    private static Logger logger = Logger.getLogger("camino.apps.DeconvToCamenoFormat");
    private static int maxOrder = 8;
    private static String inputDataType = "float";
    private static String outputDataType = "double";
    private static String inputFile = null;
    private static DataOutputStream out = new DataOutputStream(System.out);
    private static OutputManager om;

    public static void main(String[] stringArray) {
        CL_Initializer.CL_init(stringArray);
        CL_Initializer.checkParsing(stringArray);
        om = new OutputManager();
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(inputFile, SphericalHarmonics.evenFuncsUpTo(maxOrder), inputDataType);
        while (voxelOrderDataSource.more()) {
            try {
                double[] dArray = voxelOrderDataSource.nextVoxel();
                double[] dArray2 = new double[dArray.length + 2];
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                int n = 2;
                for (int i = 0; i <= maxOrder; i += 2) {
                    dArray2[n] = dArray[n - 2 + i];
                    for (int j = 1; j <= i; ++j) {
                        dArray2[n + 2 * j - 1] = dArray[n - 2 + i + j];
                        dArray2[n + 2 * j] = -dArray[n - 2 + i - j];
                    }
                    n += 2 * i + 1;
                }
                om.output(dArray2);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        om.close();
    }
}

