/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.relativity;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.physics.relativity.Tensor;

public class Rank4Tensor
extends Tensor {
    protected double[][][][] rank4 = new double[4][4][4][4];

    public boolean equals(Object object) {
        if (object instanceof Rank4Tensor) {
            Rank4Tensor rank4Tensor = (Rank4Tensor)object;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        if (!(Math.abs(this.rank4[i][j][k][0] - rank4Tensor.rank4[i][j][k][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank4[i][j][k][1] - rank4Tensor.rank4[i][j][k][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank4[i][j][k][2] - rank4Tensor.rank4[i][j][k][2]) > GlobalSettings.ZERO_TOL) && !(Math.abs(this.rank4[i][j][k][3] - rank4Tensor.rank4[i][j][k][3]) > GlobalSettings.ZERO_TOL)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public double getComponent(int n, int n2, int n3, int n4) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4 && n3 >= 0 && n3 < 4 && n4 >= 0 && n4 < 4) {
            return this.rank4[n][n2][n3][n4];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2, int n3, int n4, double d) {
        if (n < 0 || n >= 4 || n2 < 0 || n2 >= 4 || n3 < 0 || n3 >= 4 || n4 < 0 || n4 >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank4[n][n2][n3][n4] = d;
    }

    public Rank4Tensor add(Rank4Tensor rank4Tensor) {
        Rank4Tensor rank4Tensor2 = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    rank4Tensor2.setComponent(i, j, k, 0, this.rank4[i][j][k][0] + rank4Tensor.rank4[i][j][k][0]);
                    rank4Tensor2.setComponent(i, j, k, 1, this.rank4[i][j][k][1] + rank4Tensor.rank4[i][j][k][1]);
                    rank4Tensor2.setComponent(i, j, k, 2, this.rank4[i][j][k][2] + rank4Tensor.rank4[i][j][k][2]);
                    rank4Tensor2.setComponent(i, j, k, 3, this.rank4[i][j][k][3] + rank4Tensor.rank4[i][j][k][3]);
                }
            }
        }
        return rank4Tensor2;
    }

    public Rank4Tensor subtract(Rank4Tensor rank4Tensor) {
        Rank4Tensor rank4Tensor2 = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    rank4Tensor2.setComponent(i, j, k, 0, this.rank4[i][j][k][0] - rank4Tensor.rank4[i][j][k][0]);
                    rank4Tensor2.setComponent(i, j, k, 1, this.rank4[i][j][k][1] - rank4Tensor.rank4[i][j][k][1]);
                    rank4Tensor2.setComponent(i, j, k, 2, this.rank4[i][j][k][2] - rank4Tensor.rank4[i][j][k][2]);
                    rank4Tensor2.setComponent(i, j, k, 3, this.rank4[i][j][k][3] - rank4Tensor.rank4[i][j][k][3]);
                }
            }
        }
        return rank4Tensor2;
    }
}

