/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.Complex;
import JSci.maths.DimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;
import JSci.maths.vectors.MathVector;
import JSci.maths.vectors.VectorDimensionException;
import JSci.physics.quantum.KetVector;
import JSci.physics.quantum.Operator;

public final class BraVector
extends MathVector {
    private AbstractComplexVector representation;

    public BraVector(AbstractComplexVector abstractComplexVector) {
        super(abstractComplexVector.dimension());
        this.representation = abstractComplexVector;
    }

    public boolean equals(Object object) {
        return this.representation.equals((Object)((BraVector)((Object)object)).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public KetVector toKetVector() {
        return new KetVector(this.representation.conjugate());
    }

    public AbstractComplexVector getRepresentation() {
        return this.representation;
    }

    public double norm() {
        return this.representation.norm();
    }

    public Object getSet() {
        return this.representation.getSet();
    }

    public AbelianGroup.Member negate() {
        return this.representation.negate();
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof BraVector) {
            return this.add((BraVector)member);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public BraVector add(BraVector braVector) {
        return new BraVector(this.representation.add(braVector.representation));
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof BraVector) {
            return this.subtract((BraVector)member);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public BraVector subtract(BraVector braVector) {
        return new BraVector(this.representation.subtract(braVector.representation));
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        return this.representation.scalarMultiply(member);
    }

    public Complex multiply(KetVector ketVector) {
        int n = this.dimension();
        if (n == ketVector.dimension()) {
            AbstractComplexVector abstractComplexVector = ketVector.getRepresentation();
            Complex complex = this.representation.getComponent(0).multiply(abstractComplexVector.getComponent(0));
            for (int i = 1; i < n; ++i) {
                complex = complex.add(this.representation.getComponent(i).multiply(abstractComplexVector.getComponent(i)));
            }
            return complex;
        }
        throw new VectorDimensionException("Vectors have different dimensions.");
    }

    public BraVector multiply(Operator operator) {
        int n = this.dimension();
        if (n == operator.dimension()) {
            AbstractComplexSquareMatrix abstractComplexSquareMatrix = operator.getRepresentation();
            Complex[] complexArray = new Complex[n];
            for (int i = 0; i < n; ++i) {
                Complex complex = this.representation.getComponent(0).multiply(abstractComplexSquareMatrix.getElement(0, i));
                for (int j = 1; j < n; ++j) {
                    complex = complex.add(this.representation.getComponent(j).multiply(abstractComplexSquareMatrix.getElement(j, i)));
                }
                complexArray[i] = complex;
            }
            return new BraVector((AbstractComplexVector)new ComplexVector(complexArray));
        }
        throw new DimensionException("Operator and vector have different dimensions.");
    }
}

