/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiLepton;
import JSci.physics.particles.AntiMuon;
import JSci.physics.particles.MuonNeutrino;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class AntiMuonNeutrino
extends AntiLepton {
    public double restMass() {
        return 0.0;
    }

    public int charge() {
        return 0;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return -1;
    }

    public int tauLeptonQN() {
        return 0;
    }

    public QuantumParticle anti() {
        return new MuonNeutrino();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof MuonNeutrino;
    }

    public String toString() {
        return new String("Antimuon neutrino");
    }

    public AntiMuon emit(WMinus wMinus) {
        AntiMuon antiMuon = new AntiMuon();
        antiMuon.momentum = this.momentum.subtract(wMinus.momentum);
        return antiMuon;
    }

    public AntiMuon absorb(WPlus wPlus) {
        AntiMuon antiMuon = new AntiMuon();
        antiMuon.momentum = this.momentum.add(wPlus.momentum);
        return antiMuon;
    }

    public AntiMuonNeutrino emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public AntiMuonNeutrino absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

