/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiLepton;
import JSci.physics.particles.AntiMuonNeutrino;
import JSci.physics.particles.Muon;
import JSci.physics.particles.Photon;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class AntiMuon
extends AntiLepton {
    public double restMass() {
        return 105.658357;
    }

    public int charge() {
        return 1;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return -1;
    }

    public int tauLeptonQN() {
        return 0;
    }

    public QuantumParticle anti() {
        return new Muon();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof Muon;
    }

    public String toString() {
        return new String("Antimuon");
    }

    public AntiMuon emit(Photon photon) {
        this.momentum = this.momentum.subtract(photon.momentum);
        return this;
    }

    public AntiMuon absorb(Photon photon) {
        this.momentum = this.momentum.add(photon.momentum);
        return this;
    }

    public AntiMuonNeutrino emit(WPlus wPlus) {
        AntiMuonNeutrino antiMuonNeutrino = new AntiMuonNeutrino();
        antiMuonNeutrino.momentum = this.momentum.subtract(wPlus.momentum);
        return antiMuonNeutrino;
    }

    public AntiMuonNeutrino absorb(WMinus wMinus) {
        AntiMuonNeutrino antiMuonNeutrino = new AntiMuonNeutrino();
        antiMuonNeutrino.momentum = this.momentum.add(wMinus.momentum);
        return antiMuonNeutrino;
    }

    public AntiMuon emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public AntiMuon absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

