/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics;

import JSci.physics.ClassicalParticle3D;

public class RigidBody3D
extends ClassicalParticle3D {
    protected double angMass;
    protected double angx;
    protected double angy;
    protected double angz;
    protected double angxVel;
    protected double angyVel;
    protected double angzVel;

    public void setMomentOfInertia(double d) {
        this.angMass = d;
    }

    public double getMomentOfInertia() {
        return this.angMass;
    }

    public void setAngles(double d, double d2, double d3) {
        this.angx = d;
        this.angy = d2;
        this.angz = d3;
    }

    public double getXAngle() {
        return this.angx;
    }

    public double getYAngle() {
        return this.angy;
    }

    public double getZAngle() {
        return this.angz;
    }

    public void setAngularVelocity(double d, double d2, double d3) {
        this.angxVel = d;
        this.angyVel = d2;
        this.angzVel = d3;
    }

    public double getXAngularVelocity() {
        return this.angxVel;
    }

    public double getYAngularVelocity() {
        return this.angyVel;
    }

    public double getZAngularVelocity() {
        return this.angzVel;
    }

    public void setAngularMomentum(double d, double d2, double d3) {
        this.angxVel = d / this.angMass;
        this.angyVel = d2 / this.angMass;
        this.angzVel = d3 / this.angMass;
    }

    public double getXAngularMomentum() {
        return this.angMass * this.angxVel;
    }

    public double getYAngularMomentum() {
        return this.angMass * this.angyVel;
    }

    public double getZAngularMomentum() {
        return this.angMass * this.angzVel;
    }

    public double energy() {
        return (this.mass * (this.vx * this.vx + this.vy * this.vy + this.vz * this.vz) + this.angMass * (this.angxVel * this.angxVel + this.angyVel * this.angyVel + this.angzVel * this.angzVel)) / 2.0;
    }

    public ClassicalParticle3D move(double d) {
        return this.rotate(d).translate(d);
    }

    public RigidBody3D rotate(double d) {
        this.angx += this.angxVel * d;
        if (this.angx > Math.PI * 2) {
            this.angx -= Math.PI * 2;
        } else if (this.angx < 0.0) {
            this.angx += Math.PI * 2;
        }
        this.angy += this.angyVel * d;
        if (this.angy > Math.PI * 2) {
            this.angy -= Math.PI * 2;
        } else if (this.angy < 0.0) {
            this.angy += Math.PI * 2;
        }
        this.angz += this.angzVel * d;
        if (this.angz > Math.PI * 2) {
            this.angz -= Math.PI * 2;
        } else if (this.angz < 0.0) {
            this.angz += Math.PI * 2;
        }
        return this;
    }

    public RigidBody3D angularAccelerate(double d, double d2, double d3, double d4) {
        this.angxVel += d * d4;
        this.angyVel += d2 * d4;
        this.angzVel += d3 * d4;
        return this;
    }

    public RigidBody3D applyTorque(double d, double d2, double d3, double d4) {
        return this.angularAccelerate(d / this.angMass, d2 / this.angMass, d3 / this.angMass, d4);
    }

    public RigidBody3D applyForce(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.applyTorque(d5 * d3 - d6 * d2, d6 * d - d4 * d3, d4 * d2 - d5 * d, d7);
        double d8 = (d4 * d + d5 * d2 + d6 * d3) / (d4 * d4 + d5 * d5 + d6 * d6);
        this.applyForce(d8 * d4, d8 * d5, d8 * d6, d7);
        return this;
    }
}

