/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics;

import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.Double3Vector;
import JSci.physics.AbstractClassicalParticle;

public class ClassicalParticle3D
extends AbstractClassicalParticle {
    protected double mass;
    protected double x;
    protected double y;
    protected double z;
    protected double vx;
    protected double vy;
    protected double vz;

    public void setMass(double d) {
        this.mass = d;
    }

    public double getMass() {
        return this.mass;
    }

    public void setPosition(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public AbstractDoubleVector getPosition() {
        return new Double3Vector(this.x, this.y, this.z);
    }

    public void setXPosition(double d) {
        this.x = d;
    }

    public double getXPosition() {
        return this.x;
    }

    public void setYPosition(double d) {
        this.y = d;
    }

    public double getYPosition() {
        return this.y;
    }

    public void setZPosition(double d) {
        this.z = d;
    }

    public double getZPosition() {
        return this.z;
    }

    public void setVelocity(double d, double d2, double d3) {
        this.vx = d;
        this.vy = d2;
        this.vz = d3;
    }

    public AbstractDoubleVector getVelocity() {
        return new Double3Vector(this.vx, this.vy, this.vz);
    }

    public double getXVelocity() {
        return this.vx;
    }

    public double getYVelocity() {
        return this.vy;
    }

    public double getZVelocity() {
        return this.vz;
    }

    public double speed() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy + this.vz * this.vz);
    }

    public void setMomentum(double d, double d2, double d3) {
        this.vx = d / this.mass;
        this.vy = d2 / this.mass;
        this.vz = d3 / this.mass;
    }

    public AbstractDoubleVector getMomentum() {
        return new Double3Vector(this.mass * this.vx, this.mass * this.vy, this.mass * this.vz);
    }

    public double getXMomentum() {
        return this.mass * this.vx;
    }

    public double getYMomentum() {
        return this.mass * this.vy;
    }

    public double getZMomentum() {
        return this.mass * this.vz;
    }

    public double energy() {
        return this.mass * (this.vx * this.vx + this.vy * this.vy + this.vz * this.vz) / 2.0;
    }

    public ClassicalParticle3D move(double d) {
        return this.translate(d);
    }

    public ClassicalParticle3D translate(double d) {
        this.x += this.vx * d;
        this.y += this.vy * d;
        this.z += this.vz * d;
        return this;
    }

    public ClassicalParticle3D accelerate(double d, double d2, double d3, double d4) {
        this.vx += d * d4;
        this.vy += d2 * d4;
        this.vz += d3 * d4;
        return this;
    }

    public ClassicalParticle3D applyForce(double d, double d2, double d3, double d4) {
        return this.accelerate(d / this.mass, d2 / this.mass, d3 / this.mass, d4);
    }

    public ClassicalParticle3D gravitate(ClassicalParticle3D classicalParticle3D, double d) {
        double d2 = classicalParticle3D.x - this.x;
        double d3 = classicalParticle3D.y - this.y;
        double d4 = classicalParticle3D.z - this.z;
        double d5 = d2 * d2 + d3 * d3 + d4 * d4;
        double d6 = Math.sqrt(d5);
        double d7 = classicalParticle3D.mass / d5;
        double d8 = this.mass / d5;
        this.vx -= d7 * d2 * d / d6;
        this.vy -= d7 * d3 * d / d6;
        this.vz -= d7 * d4 * d / d6;
        classicalParticle3D.vx += d8 * d2 * d / d6;
        classicalParticle3D.vy += d8 * d3 * d / d6;
        classicalParticle3D.vz += d8 * d4 * d / d6;
        return this;
    }
}

