/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics;

import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;
import JSci.physics.AbstractClassicalParticle;

public class ClassicalParticle
extends AbstractClassicalParticle {
    protected double mass;
    protected AbstractDoubleVector x;
    protected AbstractDoubleVector v;

    public ClassicalParticle(int n) {
        this.x = new DoubleVector(n);
        this.v = new DoubleVector(n);
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public double getMass() {
        return this.mass;
    }

    public void setPosition(AbstractDoubleVector abstractDoubleVector) {
        this.x = abstractDoubleVector;
    }

    public AbstractDoubleVector getPosition() {
        return this.x;
    }

    public void setVelocity(AbstractDoubleVector abstractDoubleVector) {
        this.v = abstractDoubleVector;
    }

    public AbstractDoubleVector getVelocity() {
        return this.v;
    }

    private double speedSqr() {
        return this.v.scalarProduct(this.v);
    }

    public double speed() {
        return this.v.norm();
    }

    public void setMomentum(AbstractDoubleVector abstractDoubleVector) {
        this.v = abstractDoubleVector.scalarDivide(this.mass);
    }

    public AbstractDoubleVector getMomentum() {
        return this.v.scalarMultiply(this.mass);
    }

    public double energy() {
        return this.mass * this.speedSqr() / 2.0;
    }

    public ClassicalParticle move(double d) {
        this.x = this.x.add(this.v.scalarMultiply(d));
        return this;
    }

    public ClassicalParticle accelerate(AbstractDoubleVector abstractDoubleVector, double d) {
        this.v = this.v.add(abstractDoubleVector.scalarMultiply(d));
        return this;
    }

    public ClassicalParticle applyForce(AbstractDoubleVector abstractDoubleVector, double d) {
        return this.accelerate(abstractDoubleVector.scalarDivide(this.mass), d);
    }
}

