package edu.jhu.ece.iacl.processcontrol;

import java.io.File;
import java.io.IOException;
import java.util.*;

import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.Session;

import java.io.InputStream;

public class ProcessControllerNative implements ProcessController {

	long JobSubmitTime;
	Process proc=null;
	ProcessBuilder builder;

	public ProcessControllerNative(List<String> Command)
	{
		System.out.println(Command);
//		String a = null; 
//		ArrayList<String> ExecCommand = new ArrayList<String>();
//		StringTokenizer st = new StringTokenizer(Command);
//		 while (st.hasMoreTokens()) {
//			   a = st.nextToken();
//			   ExecCommand.add(a);
//			}  
		builder  = new ProcessBuilder(Command);
		
		System.out.println(builder.toString());
	}
	
	public boolean Setup(List<String> Command) {
		return true;
	}

	@Override
	public ProcessStatus getStatus() {
		// TODO Auto-generated method stub
		if(proc==null) 
			return null;
		try {
			int e = proc.exitValue();
			return ProcessStatus.DONE;
		} catch(IllegalThreadStateException e) {
			return ProcessStatus.RUNNING;
		}	
	}

	@Override
	public long getSubmissionTime()
	{
		return JobSubmitTime;
	}
	@Override
	public InputStream getStderrFile() {
		// TODO Auto-generated method stub
		return proc.getErrorStream();
	}

	@Override
	public InputStream getStdoutFile() {
		// TODO Auto-generated method stub
		return proc.getInputStream();		
	}

	@Override
	public boolean submit() {
		// TODO Auto-generated method stub
		try {
			proc = builder.start();	
			JobSubmitTime = System.currentTimeMillis();
		} catch(IOException e) {
			proc=null;
			return false;
		}
		return true;
	}

	@Override
	public boolean destroy() {		
		proc.destroy();
		return true;

		// TODO Auto-generated method stub
		//		return false;
	}
	@Override
	public void controlJob(ProcessControlAction Action)
	{
		switch(Action) {
		case HOLD: 
		case RELEASE:
		case RESUME:

			//not supported
			break;
		case TERMINATE:
			destroy();
			break;
		}
	}

	@Override
	public Process getProcess()
	{
		return proc;
	}
	@Override
	public int waitFor() throws InterruptedException 
	{
		System.out.println("WaitFor");
		int w = 1000;
		try{
			w = proc.waitFor();
		}
		catch(InterruptedException e){
			throw e; 
		}	
		return w;
	}


	@Override
	public Integer getExitCode() {		
		try {
			return proc.exitValue();
		} catch(Exception e) {
			return null;
		}		
	}

}
