/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.polynomials.PolynomialBasis;
import JSci.maths.polynomials.RealLagrangeBasis;

public class ChebychevBasis
extends RealLagrangeBasis
implements PolynomialBasis {
    public ChebychevBasis(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this._dim = n;
        this._samplingsX = new double[this._dim];
        int n2 = this._dim - 1;
        for (int i = 0; i < this._dim; ++i) {
            this._samplingsX[i] = Math.cos((double)(2 * i + 1) * Math.PI / (double)(2 * n2 + 2));
        }
        this.buildBasis();
    }
}

