/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.algebras;

import JSci.maths.Complex;
import JSci.maths.algebras.LieAlgebra;
import JSci.maths.fields.ComplexField;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.Double3Vector;
import JSci.maths.vectors.VectorDimensionException;

public final class su2Dim3
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.SQRT_HALF, Complex.ZERO}, {ComplexField.SQRT_HALF, Complex.ZERO, ComplexField.SQRT_HALF}, {Complex.ZERO, ComplexField.SQRT_HALF, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.MINUS_SQRT_HALF_I, Complex.ZERO}, {ComplexField.SQRT_HALF_I, Complex.ZERO, ComplexField.MINUS_SQRT_HALF_I}, {Complex.ZERO, ComplexField.SQRT_HALF_I, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{Complex.ONE, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.MINUS_ONE}};
    private static final AbstractComplexSquareMatrix[] basisMatrices = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3)};
    private static final double[][] g = new double[][]{{-2.0, 0.0, 0.0}, {0.0, -2.0, 0.0}, {0.0, 0.0, -2.0}};
    private static final AbstractDoubleSquareMatrix metricMatrix = new DoubleSquareMatrix(g);
    private static final su2Dim3 _instance = new su2Dim3();

    private su2Dim3() {
        super("su(2) [3]");
    }

    public static final su2Dim3 getInstance() {
        return _instance;
    }

    public AbstractComplexSquareMatrix getElement(AbstractDoubleVector abstractDoubleVector) {
        AbstractComplexMatrix abstractComplexMatrix = basisMatrices[0].scalarMultiply(abstractDoubleVector.getComponent(0));
        abstractComplexMatrix = abstractComplexMatrix.add(basisMatrices[1].scalarMultiply(abstractDoubleVector.getComponent(1)));
        abstractComplexMatrix = abstractComplexMatrix.add(basisMatrices[2].scalarMultiply(abstractDoubleVector.getComponent(2)));
        return (AbstractComplexSquareMatrix)abstractComplexMatrix.scalarMultiply(Complex.I);
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector, AbstractDoubleVector abstractDoubleVector2) {
        if (!(abstractDoubleVector instanceof Double3Vector) || !(abstractDoubleVector2 instanceof Double3Vector)) {
            throw new VectorDimensionException("Vectors must be 3-vectors.");
        }
        return ((Double3Vector)abstractDoubleVector2).multiply((Double3Vector)abstractDoubleVector);
    }

    public double killingForm(AbstractDoubleVector abstractDoubleVector, AbstractDoubleVector abstractDoubleVector2) {
        return abstractDoubleVector.scalarProduct(metricMatrix.multiply(abstractDoubleVector2));
    }

    public AbstractComplexSquareMatrix[] basis() {
        return basisMatrices;
    }

    public AbstractDoubleSquareMatrix cartanMetric() {
        return metricMatrix;
    }
}

