/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Point3D;
import numerics.Vector3D;
import tractography.EightNeighbourInterpolator;
import tractography.ImageInterpolator;
import tractography.TractographyImage;

public final class VectorLinearInterpolator
extends EightNeighbourInterpolator
implements ImageInterpolator {
    private TractographyImage image;

    public VectorLinearInterpolator(TractographyImage tractographyImage) {
        super(tractographyImage.xDataDim(), tractographyImage.yDataDim(), tractographyImage.zDataDim(), tractographyImage.xVoxelDim(), tractographyImage.yVoxelDim(), tractographyImage.zVoxelDim());
        this.image = tractographyImage;
    }

    private Vector3D chooseVector(int n, int n2, int n3, Vector3D vector3D) {
        Vector3D[] vector3DArray = this.image.getPDs(n, n2, n3);
        if (vector3DArray.length == 0) {
            return null;
        }
        if (vector3DArray.length == 1) {
            if (vector3DArray[0].dot(vector3D) > 0.0) {
                return vector3DArray[0];
            }
            return vector3DArray[0].negated();
        }
        int n4 = 0;
        double d = 0.0;
        for (int i = 0; i < vector3DArray.length; ++i) {
            double d2 = Math.abs(vector3DArray[i].dot(vector3D));
            if (!(d2 > d)) continue;
            d = d2;
            n4 = i;
        }
        if (vector3DArray[n4].dot(vector3D) > 0.0) {
            return vector3DArray[n4];
        }
        return vector3DArray[n4].negated();
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, Vector3D vector3D) {
        int n;
        double[] dArray = new double[8];
        int[] nArray = new int[6];
        int n2 = this.setInterpolationVoxels(point3D, dArray, nArray);
        Vector3D[] vector3DArray = new Vector3D[8];
        for (n = 0; n < 8; ++n) {
            int n3 = nArray[n / 4];
            int n4 = nArray[2 + n / 2 % 2];
            int n5 = nArray[4 + n % 2];
            vector3DArray[n] = this.chooseVector(n3, n4, n5, vector3D);
        }
        if (vector3DArray[n2] == null) {
            vector3DArray[n2] = new Vector3D(0.0, 0.0, 0.0);
        }
        for (n = 0; n < 8; ++n) {
            if (vector3DArray[n] != null) continue;
            vector3DArray[n] = vector3DArray[n2];
        }
        Vector3D vector3D2 = vector3DArray[0];
        Vector3D vector3D3 = vector3DArray[1];
        Vector3D vector3D4 = vector3DArray[2];
        Vector3D vector3D5 = vector3DArray[3];
        Vector3D vector3D6 = vector3DArray[4];
        Vector3D vector3D7 = vector3DArray[5];
        Vector3D vector3D8 = vector3DArray[6];
        Vector3D vector3D9 = vector3DArray[7];
        double[] dArray2 = new double[]{vector3D2.x * dArray[0] + vector3D3.x * dArray[1] + vector3D4.x * dArray[2] + vector3D5.x * dArray[3] + vector3D6.x * dArray[4] + vector3D7.x * dArray[5] + vector3D8.x * dArray[6] + vector3D9.x * dArray[7], vector3D2.y * dArray[0] + vector3D3.y * dArray[1] + vector3D4.y * dArray[2] + vector3D5.y * dArray[3] + vector3D6.y * dArray[4] + vector3D7.y * dArray[5] + vector3D8.y * dArray[6] + vector3D9.y * dArray[7], vector3D2.z * dArray[0] + vector3D3.z * dArray[1] + vector3D4.z * dArray[2] + vector3D5.z * dArray[3] + vector3D6.z * dArray[4] + vector3D7.z * dArray[5] + vector3D8.z * dArray[6] + vector3D9.z * dArray[7]};
        return new Vector3D(dArray2).normalized();
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, int n, boolean bl) {
        int n2 = (int)(point3D.x / this.xVoxelDim);
        int n3 = (int)(point3D.y / this.yVoxelDim);
        int n4 = (int)(point3D.z / this.zVoxelDim);
        Vector3D[] vector3DArray = this.image.getPDs(n2, n3, n4);
        if (bl) {
            return this.getTrackingDirection(point3D, vector3DArray[n]);
        }
        return this.getTrackingDirection(point3D, vector3DArray[n].negated());
    }
}

