/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import Jama.Matrix;
import imaging.Scheme;
import inverters.ModelIndex;
import java.text.DecimalFormat;
import java.util.Random;
import misc.DT;
import numerics.ACG_Fitter;
import numerics.BinghamFitter;
import numerics.ConvergenceException;
import numerics.EigenSystem3D;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.Vector3D;
import numerics.WatsonFitter;
import tractography.DT_LookupTableGenerator;

public class TwoTensorLUTGenerator
extends DT_LookupTableGenerator {
    protected double prop;
    protected double rotAngle;

    public TwoTensorLUTGenerator(Scheme scheme, double d, double d2, double d3, double d4, Random random) {
        super(scheme, d, d2, random);
        this.prop = d3;
        this.rotAngle = d4;
    }

    @Override
    public double[][][][] generateLUT(double d, double d2, double d3, int n, ModelIndex modelIndex, boolean bl, boolean bl2, boolean bl3) {
        double d4 = d;
        double d5 = d2;
        double[][][][] dArray = new double[3][1 + (int)Math.round((d2 - d) / d3)][1 + (int)Math.round((d5 - d4) / d3)][];
        double[] dArray2 = new double[]{this.prop, 1.0 - this.prop};
        RealMatrix realMatrix = Rotations.getRotMat(this.e2Vec, this.rotAngle);
        Vector3D vector3D = Rotations.rotateVector(this.e1Vec, realMatrix);
        double d6 = d;
        double d7 = d4;
        int n2 = 0;
        int n3 = 0;
        double d8 = (double)(dArray[0].length * (dArray[0].length + 1)) / 2.0;
        if (this.prop != 0.5) {
            d8 = dArray[0].length * dArray[0][0].length;
        }
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        while (n2 < dArray[0].length) {
            System.err.print("\r ... " + decimalFormat.format(100.0 * (double)n2 * (double)(n2 + 1) / (2.0 * d8)) + "% completed");
            while (n3 < dArray[0][0].length) {
                if (n2 < n3 && this.prop == 0.5) {
                    ++n3;
                    d7 += d3;
                    continue;
                }
                Vector3D[] vector3DArray = new Vector3D[2 * n];
                DT dT = this.getTensor(d6, this.trace, this.ran);
                DT dT2 = this.getTensor(d7, this.trace, this.ran);
                dT2 = dT2.transform(realMatrix);
                DT[][] dTArray = TwoTensorLUTGenerator.getNoisyTensors(new DT[]{dT, dT2}, dArray2, modelIndex, this.imPars, this.snr, n, this.ran);
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    if (dTArray[0][i] == null) continue;
                    double[][] dArray3 = dTArray[0][i].sortedEigenSystem();
                    double[][] dArray4 = dTArray[1][i].sortedEigenSystem();
                    if (dArray3[0][0] < 0.0 || dArray3[0][1] < 0.0 || dArray3[0][2] < 0.0 || dArray4[0][0] < 0.0 || dArray4[0][1] < 0.0 || dArray4[0][2] < 0.0) continue;
                    vector3DArray[2 * n4] = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
                    vector3DArray[2 * n4 + 1] = new Vector3D(dArray4[1][0], dArray4[2][0], dArray4[3][0]);
                    ++n4;
                }
                if ((double)n4 / (double)n < 0.95) {
                    double d9 = (1.0 - (double)n4 / (double)n) * 100.0;
                    System.err.println("Warning: discarding " + d9 + "% of samples at point : (" + d6 + ", " + d7 + ")");
                }
                Vector3D[] vector3DArray2 = new Vector3D[2 * n4];
                for (int i = 0; i < 2 * n4; ++i) {
                    vector3DArray2[i] = vector3DArray[i];
                }
                dArray[0][n2][n3] = bl ? this.getWatsonConcentrationParams(vector3DArray2, this.e1Vec, vector3D) : new double[2];
                dArray[1][n2][n3] = bl2 ? this.getBinghamConcentrationParams(vector3DArray2, this.e1Vec, vector3D) : new double[4];
                dArray[2][n2][n3] = bl3 ? this.getACGConcentrationParams(vector3DArray2, this.e1Vec, vector3D) : new double[6];
                if (this.prop == 0.5 && n2 != n3) {
                    double[] dArray5 = new double[]{dArray[0][n2][n3][1], dArray[0][n2][n3][0]};
                    dArray[0][n3][n2] = dArray5;
                    dArray5 = new double[]{dArray[1][n2][n3][2], dArray[1][n2][n3][3], dArray[1][n2][n3][0], dArray[1][n2][n3][1]};
                    dArray[1][n3][n2] = dArray5;
                    dArray5 = new double[]{dArray[2][n2][n3][3], dArray[2][n2][n3][4], dArray[2][n2][n3][5], dArray[2][n2][n3][0], dArray[2][n2][n3][1], dArray[2][n2][n3][2]};
                    dArray[2][n3][n2] = dArray5;
                }
                ++n3;
                d7 += d3;
            }
            ++n2;
            d6 += d3;
            n3 = 0;
            d7 = d4;
        }
        System.err.println();
        return dArray;
    }

    protected double[] getWatsonConcentrationParams(Vector3D[] vector3DArray, Vector3D vector3D, Vector3D vector3D2) {
        double d;
        int n;
        Vector3D[][] vector3DArray2 = TwoTensorLUTGenerator.sortAxes(vector3DArray, vector3D, vector3D2);
        EigenSystem3D[] eigenSystem3DArray = new EigenSystem3D[2];
        double[] dArray = new double[2];
        Vector3D[] vector3DArray3 = new Vector3D[2];
        for (n = 0; n < 2; ++n) {
            eigenSystem3DArray[n] = WatsonFitter.tBarEigenSystem(vector3DArray2[n]);
            dArray[n] = WatsonFitter.fitKappa(eigenSystem3DArray[n], vector3DArray2[n]);
            vector3DArray3[n] = dArray[n] > 0.0 ? eigenSystem3DArray[n].eigenvectors[0] : eigenSystem3DArray[n].eigenvectors[2];
        }
        n = dArray[0] > dArray[1] ? 0 : 1;
        double d2 = Math.abs(vector3DArray3[n].dot(vector3D));
        if (d2 > (d = Math.abs(vector3DArray3[n].dot(vector3D2)))) {
            return new double[]{dArray[n], dArray[1 - n]};
        }
        return new double[]{dArray[1 - n], dArray[n]};
    }

    protected double[] getBinghamConcentrationParams(Vector3D[] vector3DArray, Vector3D vector3D, Vector3D vector3D2) {
        double d;
        int n;
        Vector3D[][] vector3DArray2 = TwoTensorLUTGenerator.sortAxes(vector3DArray, vector3D, vector3D2);
        EigenSystem3D[] eigenSystem3DArray = new EigenSystem3D[2];
        double[] dArray = new double[4];
        Vector3D[] vector3DArray3 = new Vector3D[6];
        for (n = 0; n < 2; ++n) {
            eigenSystem3DArray[n] = BinghamFitter.tBarEigenSystem(vector3DArray2[n]);
            vector3DArray3[3 * n] = eigenSystem3DArray[n].eigenvectors[0];
            vector3DArray3[3 * n + 1] = eigenSystem3DArray[n].eigenvectors[1];
            vector3DArray3[3 * n + 2] = eigenSystem3DArray[n].eigenvectors[2];
            try {
                double[] dArray2 = BinghamFitter.bngpar(eigenSystem3DArray[n].eigenvalues[1], eigenSystem3DArray[n].eigenvalues[2]);
                dArray[2 * n] = dArray2[0];
                dArray[2 * n + 1] = dArray2[1];
                continue;
            }
            catch (ConvergenceException convergenceException) {
                // empty catch block
            }
        }
        n = Math.abs(dArray[0] + dArray[1]) > Math.abs(dArray[2] + dArray[3]) ? 0 : 1;
        double d2 = Math.abs(vector3DArray3[3 * n].dot(vector3D));
        if (d2 > (d = Math.abs(vector3DArray3[3 * n].dot(vector3D2)))) {
            return new double[]{dArray[2 * n], dArray[2 * n + 1], dArray[2 * (1 - n)], dArray[2 * (1 - n) + 1]};
        }
        return new double[]{dArray[2 * (1 - n)], dArray[2 * (1 - n) + 1], dArray[2 * n], dArray[2 * n + 1]};
    }

    protected double[] getACGConcentrationParams(Vector3D[] vector3DArray, Vector3D vector3D, Vector3D vector3D2) {
        double d;
        int n;
        double[] dArray = new double[6];
        Vector3D[] vector3DArray2 = new Vector3D[2];
        Vector3D[][] vector3DArray3 = TwoTensorLUTGenerator.sortAxes(vector3DArray, vector3D, vector3D2);
        for (n = 0; n < 2; ++n) {
            RealMatrix realMatrix = ACG_Fitter.findA(vector3DArray3[n]);
            Matrix matrix = new Matrix(3, 3);
            matrix.set(0, 0, realMatrix.entries[0][0]);
            matrix.set(0, 1, realMatrix.entries[0][1]);
            matrix.set(0, 2, realMatrix.entries[0][2]);
            matrix.set(1, 0, realMatrix.entries[1][0]);
            matrix.set(1, 1, realMatrix.entries[1][1]);
            matrix.set(1, 2, realMatrix.entries[1][2]);
            matrix.set(2, 0, realMatrix.entries[2][0]);
            matrix.set(2, 1, realMatrix.entries[2][1]);
            matrix.set(2, 2, realMatrix.entries[2][2]);
            EigenSystem3D eigenSystem3D = EigenSystem3D.sort(matrix.eig());
            dArray[3 * n] = eigenSystem3D.eigenvalues[0];
            dArray[3 * n + 1] = eigenSystem3D.eigenvalues[1];
            dArray[3 * n + 2] = eigenSystem3D.eigenvalues[2];
            vector3DArray2[n] = eigenSystem3D.eigenvectors[0];
        }
        n = dArray[0] + dArray[1] + dArray[2] < dArray[3] + dArray[4] + dArray[5] ? 0 : 1;
        double d2 = Math.abs(vector3DArray2[n].dot(vector3D));
        if (d2 > (d = Math.abs(vector3DArray2[n].dot(vector3D2)))) {
            return new double[]{dArray[3 * n], dArray[3 * n + 1], dArray[3 * n + 2], dArray[3 * (1 - n)], dArray[3 * (1 - n) + 1], dArray[3 * (1 - n) + 2]};
        }
        return new double[]{dArray[3 * (1 - n)], dArray[3 * (1 - n) + 1], dArray[3 * (1 - n) + 2], dArray[3 * n], dArray[3 * n + 1], dArray[3 * n + 2]};
    }

    private static Vector3D[][] sortAxes(Vector3D[] vector3DArray, Vector3D vector3D, Vector3D vector3D2) {
        Vector3D vector3D3;
        Object object;
        int n = vector3DArray.length / 2;
        Vector3D[] vector3DArray2 = new Vector3D[n];
        Vector3D[] vector3DArray3 = new Vector3D[n];
        for (int i = 0; i < n; ++i) {
            double d;
            object = vector3DArray[2 * i];
            vector3D3 = vector3DArray[2 * i + 1];
            double d2 = Math.abs(((Vector3D)object).dot(vector3D)) + Math.abs(vector3D3.dot(vector3D2));
            if (d2 > (d = Math.abs(vector3D3.dot(vector3D)) + Math.abs(((Vector3D)object).dot(vector3D2)))) {
                vector3DArray2[i] = object;
                vector3DArray3[i] = vector3D3;
                continue;
            }
            vector3DArray2[i] = vector3D3;
            vector3DArray3[i] = object;
        }
        EigenSystem3D eigenSystem3D = WatsonFitter.tBarEigenSystem(vector3DArray2);
        object = WatsonFitter.tBarEigenSystem(vector3DArray3);
        vector3D3 = eigenSystem3D.eigenvectors[0];
        Vector3D vector3D4 = ((EigenSystem3D)object).eigenvectors[0];
        boolean bl = true;
        for (int i = 0; bl && i < 100; ++i) {
            bl = false;
            for (int j = 0; j < n; ++j) {
                if (!(Math.abs(vector3DArray2[j].dot(vector3D3)) < Math.abs(vector3DArray2[j].dot(vector3D4)))) continue;
                Vector3D vector3D5 = vector3DArray2[j];
                vector3DArray2[j] = vector3DArray3[j];
                vector3DArray3[j] = vector3D5;
                bl = true;
            }
            eigenSystem3D = WatsonFitter.tBarEigenSystem(vector3DArray2);
            object = WatsonFitter.tBarEigenSystem(vector3DArray3);
            vector3D3 = eigenSystem3D.eigenvectors[0];
            vector3D4 = ((EigenSystem3D)object).eigenvectors[0];
        }
        return new Vector3D[][]{vector3DArray2, vector3DArray3};
    }
}

