/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Vector3D;

public class TractographyImage {
    protected final int xDataDim;
    protected final int yDataDim;
    protected final int zDataDim;
    protected final double xVoxelDim;
    protected final double yVoxelDim;
    protected final double zVoxelDim;
    protected final int[][][] numPDs;
    protected final Vector3D[][][][] vectors;
    protected boolean[][][] isotropicMask = null;
    protected final int vecsPerPD;

    public TractographyImage(int[] nArray, double[] dArray, int n) {
        this.xVoxelDim = dArray[0];
        this.yVoxelDim = dArray[1];
        this.zVoxelDim = dArray[2];
        this.xDataDim = nArray[0];
        this.yDataDim = nArray[1];
        this.zDataDim = nArray[2];
        this.vecsPerPD = n;
        this.vectors = new Vector3D[this.xDataDim][this.yDataDim][this.zDataDim][];
        this.numPDs = new int[this.xDataDim][this.yDataDim][this.zDataDim];
    }

    public TractographyImage(Vector3D[][][][] vector3DArray, double[] dArray, int n) {
        this.xVoxelDim = dArray[0];
        this.yVoxelDim = dArray[1];
        this.zVoxelDim = dArray[2];
        this.xDataDim = vector3DArray.length;
        this.yDataDim = vector3DArray[0].length;
        this.zDataDim = vector3DArray[0][0].length;
        this.vecsPerPD = n;
        this.vectors = vector3DArray;
        this.numPDs = new int[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.numPDs[k][j][i] = vector3DArray[k][j][i].length;
                }
            }
        }
        this.computeIsotropicMask();
    }

    public Vector3D[] getPDs(int n, int n2, int n3) {
        if (this.numPDs[n][n2][n3] == 1) {
            return new Vector3D[]{this.vectors[n][n2][n3][0]};
        }
        if (this.numPDs[n][n2][n3] == 0) {
            return new Vector3D[0];
        }
        Vector3D[] vector3DArray = new Vector3D[this.numPDs[n][n2][n3]];
        for (int i = 0; i < this.numPDs[n][n2][n3]; ++i) {
            vector3DArray[i] = this.vectors[n][n2][n3][i * this.vecsPerPD];
        }
        return vector3DArray;
    }

    public Vector3D[] getPDs(int n, int n2, int n3, Vector3D vector3D) {
        return this.getPDs(n, n2, n3);
    }

    public final int numberOfPDs(int n, int n2, int n3) {
        return this.numPDs[n][n2][n3];
    }

    public final int xDataDim() {
        return this.xDataDim;
    }

    public final double xVoxelDim() {
        return this.xVoxelDim;
    }

    public final int yDataDim() {
        return this.yDataDim;
    }

    public final double yVoxelDim() {
        return this.yVoxelDim;
    }

    public final int zDataDim() {
        return this.zDataDim;
    }

    public final double zVoxelDim() {
        return this.zVoxelDim;
    }

    public final double[] getVoxelDims() {
        return new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim};
    }

    public final int[] getDataDims() {
        return new int[]{this.xDataDim, this.yDataDim, this.zDataDim};
    }

    public final void computeIsotropicMask() {
        this.isotropicMask = new boolean[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (this.numPDs[k][j][i] != 0) continue;
                    this.isotropicMask[k][j][i] = true;
                }
            }
        }
    }

    public final void computeIsotropicMask(double[][][] dArray, double d) {
        this.isotropicMask = new boolean[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (this.numPDs[k][j][i] == 0) {
                        this.isotropicMask[k][j][i] = true;
                        continue;
                    }
                    if (this.numPDs[k][j][i] > 1) {
                        this.isotropicMask[k][j][i] = false;
                        continue;
                    }
                    if (!(dArray[k][j][i] < d)) continue;
                    this.isotropicMask[k][j][i] = true;
                }
            }
        }
    }

    public final boolean[][][] getIsotropicMask() {
        return this.isotropicMask;
    }
}

