/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import misc.LoggedException;
import misc.ScalarImage;
import numerics.Point3D;
import tools.ArrayOps;
import tractography.Tract;

public class TractStatisticFilter {
    private final int[] dataDims;
    private final double[] voxelDims;
    private ScalarImage scalars = null;
    private String tractStat = "mean";
    private boolean interpolated = false;
    private boolean tractScalarStatistic;

    public TractStatisticFilter(ScalarImage scalarImage) {
        this.scalars = scalarImage;
        this.dataDims = scalarImage.getDataDims();
        this.voxelDims = scalarImage.getVoxelDims();
        this.tractScalarStatistic = true;
    }

    public TractStatisticFilter(double[][][] dArray, double[] dArray2) {
        this.scalars = new ScalarImage(dArray, dArray2);
        this.dataDims = this.scalars.getDataDims();
        this.voxelDims = this.scalars.getVoxelDims();
        this.tractScalarStatistic = true;
    }

    public TractStatisticFilter(int[] nArray, double[] dArray) {
        this.dataDims = nArray;
        this.voxelDims = dArray;
        this.tractScalarStatistic = false;
    }

    public void setTractStatistic(String string) {
        this.tractStat = string;
    }

    public void setInterpolate(boolean bl) {
        this.interpolated = bl;
        if (this.interpolated && this.scalars != null) {
            this.scalars.setInterpolation("linear");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[] processTract(Tract tract) {
        double[] dArray = null;
        if (this.tractScalarStatistic) {
            double[] dArray2 = null;
            double[] dArray3 = null;
            Point3D[] point3DArray = tract.getPoints();
            dArray2 = this.scalars.valuesAt(point3DArray);
            if (this.tractStat.equals("none")) {
                return dArray2;
            }
            if (this.tractStat.equals("mean")) {
                dArray = dArray3 != null ? new double[]{ArrayOps.weightedMean(dArray2, dArray3)} : new double[]{ArrayOps.mean(dArray2)};
                return dArray;
            } else if (this.tractStat.equals("max")) {
                dArray = new double[]{ArrayOps.max(dArray2)};
                return dArray;
            } else if (this.tractStat.equals("min")) {
                dArray = new double[]{ArrayOps.min(dArray2)};
                return dArray;
            } else if (this.tractStat.equals("median")) {
                dArray = new double[]{ArrayOps.median(dArray2)};
                return dArray;
            } else if (this.tractStat.equals("sum")) {
                dArray = new double[]{ArrayOps.sum(dArray2)};
                return dArray;
            } else if (this.tractStat.equals("var")) {
                dArray = new double[1];
                dArray[0] = dArray3 != null ? ArrayOps.weightedVar(dArray2, dArray3, ArrayOps.weightedMean(dArray2, dArray3)) : ArrayOps.var(dArray2, ArrayOps.mean(dArray2));
                return dArray;
            } else {
                if (!this.tractStat.equals("meanvar")) throw new LoggedException("Unsupported tract statistic: " + this.tractStat);
                dArray = new double[2];
                if (dArray3 != null) {
                    dArray[0] = ArrayOps.weightedMean(dArray2, dArray3);
                    dArray[1] = ArrayOps.weightedVar(dArray2, dArray3, dArray[0]);
                    return dArray;
                } else {
                    dArray[0] = ArrayOps.mean(dArray2);
                    dArray[1] = ArrayOps.var(dArray2, dArray[0]);
                }
            }
            return dArray;
        } else {
            dArray = new double[1];
            if (!this.tractStat.equals("length")) throw new LoggedException("Unsupported tract statistic (may be supported with a scalar image): " + this.tractStat);
            dArray[0] = tract.length();
        }
        return dArray;
    }
}

