/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import misc.LoggedException;
import numerics.Point3D;
import numerics.Vector3D;
import tractography.Tract;
import tractography.Voxel;
import tractography.VoxelList;

public class TractSource {
    private static Logger logger = Logger.getLogger("camino.tractography.TractSource");
    private final DataInputStream din;
    private final boolean inputIsVoxels;
    private Tract nextTract = null;
    private boolean reachedEndOfFile;
    private boolean noMoreTracts;
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;

    public TractSource(String string, String string2, double[] dArray) {
        this(string, string2, dArray[0], dArray[1], dArray[2]);
    }

    public TractSource(String string, String string2, double d, double d2, double d3) {
        int n = 0x1800000;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
        if (string2.equals("voxels")) {
            this.inputIsVoxels = true;
        } else if (string2.equals("raw")) {
            this.inputIsVoxels = false;
        } else {
            throw new LoggedException("Unrecognized input model : " + string2);
        }
        try {
            if (string == null) {
                this.din = new DataInputStream(new BufferedInputStream(System.in, n));
                logger.info("reading data from standard input");
            } else if (string.endsWith(".gz")) {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.din = new DataInputStream(new GZIPInputStream(new BufferedInputStream(fileInputStream, n)));
            } else {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.din = new DataInputStream(new BufferedInputStream(fileInputStream, n));
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        this.init();
    }

    private void init() {
        this.reachedEndOfFile = false;
        this.noMoreTracts = false;
        try {
            this.readNextTract();
            if (this.reachedEndOfFile) {
                this.noMoreTracts = true;
                throw new LoggedException("Input contains no tracts");
            }
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
    }

    private void readNextTract() {
        this.nextTract = this.inputIsVoxels ? this.readTractFromVoxels() : this.readTractFromRaw();
    }

    private Tract readTractFromVoxels() {
        boolean bl = true;
        try {
            int n = this.din.readShort();
            bl = false;
            short s = this.din.readShort();
            Vector3D vector3D = new Vector3D(this.din.readShort(), this.din.readShort(), this.din.readShort());
            Vector3D vector3D2 = new Vector3D(this.din.readShort(), this.din.readShort(), this.din.readShort());
            Voxel[] voxelArray = new Voxel[n];
            for (int i = 0; i < n; ++i) {
                voxelArray[i] = new Voxel(this.din.readShort(), this.din.readShort(), this.din.readShort());
            }
            bl = true;
            return new VoxelList(voxelArray, s, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim, vector3D, vector3D2).toTract();
        }
        catch (Exception exception) {
            if (exception instanceof EOFException) {
                if (!bl) {
                    throw new LoggedException("EOF before whole tract was read");
                }
                this.reachedEndOfFile = true;
                return null;
            }
            throw new LoggedException("Unexpected " + exception + " . Check that input is in VOXEL format");
        }
    }

    private Tract readTractFromRaw() {
        boolean bl = true;
        try {
            int n;
            Tract tract = new Tract(100, 100.0);
            Tract tract2 = new Tract(100, 100.0);
            int n2 = (int)this.din.readFloat();
            bl = false;
            int n3 = (int)this.din.readFloat();
            Point3D[] point3DArray = new Point3D[n2];
            for (n = 0; n < n2; ++n) {
                double d = this.din.readFloat();
                double d2 = this.din.readFloat();
                double d3 = this.din.readFloat();
                point3DArray[n] = new Point3D(d, d2, d3);
            }
            bl = true;
            for (n = n3; n >= 0; --n) {
                tract.addPoint(point3DArray[n]);
            }
            for (n = n3; n < n2; ++n) {
                tract2.addPoint(point3DArray[n]);
            }
            tract2.joinTract(tract);
            return tract2;
        }
        catch (Exception exception) {
            if (exception instanceof EOFException) {
                if (!bl) {
                    throw new LoggedException("EOF before whole tract was read");
                }
                this.reachedEndOfFile = true;
                return null;
            }
            throw new LoggedException("Unexpected " + exception + " . Check that input is in RAW format");
        }
    }

    public Tract nextTract() {
        if (this.noMoreTracts) {
            throw new LoggedException("No more tracts in input");
        }
        Tract tract = this.nextTract;
        this.readNextTract();
        if (this.reachedEndOfFile) {
            this.noMoreTracts = true;
        }
        return tract;
    }

    public boolean more() {
        return !this.noMoreTracts;
    }
}

