/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.io.DataOutputStream;
import java.io.IOException;
import tractography.Tract;

public final class TractCollection {
    private int numberOfTracts;
    private Tract[] tracts;
    private int capacity;
    private double growBy;
    private int totalPoints;

    private void increaseCapacity() {
        this.capacity += (int)((double)this.capacity + (double)this.capacity * this.growBy / 100.0);
        Tract[] tractArray = new Tract[this.capacity];
        for (int i = 0; i < this.numberOfTracts; ++i) {
            tractArray[i] = this.tracts[i];
        }
        this.tracts = tractArray;
    }

    public TractCollection() {
        this.growBy = 100.0;
        this.capacity = 100;
        this.tracts = new Tract[this.capacity];
        this.numberOfTracts = 0;
        this.totalPoints = 0;
    }

    public TractCollection(int n, double d) {
        this.growBy = d;
        this.capacity = n;
        this.tracts = new Tract[this.capacity];
        this.numberOfTracts = 0;
        this.totalPoints = 0;
    }

    public int numberOfTracts() {
        return this.numberOfTracts;
    }

    public int totalPoints() {
        return this.totalPoints;
    }

    public void addTract(Tract tract) {
        this.tracts[this.numberOfTracts] = tract;
        ++this.numberOfTracts;
        this.totalPoints += tract.numberOfPoints();
        if (this.numberOfTracts == this.capacity) {
            this.increaseCapacity();
        }
    }

    public void addTractCollection(TractCollection tractCollection) {
        if (tractCollection.numberOfTracts + this.numberOfTracts >= this.capacity) {
            int n;
            this.capacity = tractCollection.numberOfTracts + this.numberOfTracts + 1;
            Tract[] tractArray = new Tract[this.capacity];
            for (n = 0; n < this.numberOfTracts; ++n) {
                tractArray[n] = this.tracts[n];
            }
            n = this.numberOfTracts;
            for (int i = 0; i < tractCollection.numberOfTracts; ++i) {
                tractArray[n + i] = tractCollection.tracts[i];
            }
            this.numberOfTracts = n + tractCollection.numberOfTracts;
            this.tracts = tractArray;
        } else {
            for (int i = 0; i < tractCollection.numberOfTracts; ++i) {
                this.tracts[this.numberOfTracts + i] = tractCollection.tracts[i];
            }
            this.numberOfTracts += tractCollection.numberOfTracts;
        }
    }

    public String toString() {
        return "tractography.TractCollection\nTotal points: " + this.totalPoints + "\nTotal Tracts: " + this.numberOfTracts + "\n";
    }

    public Tract getTract(int n) {
        if (n < 0 || n > this.numberOfTracts) {
            throw new IndexOutOfBoundsException("Illegal Tract index: " + n);
        }
        return this.tracts[n];
    }

    public void replaceTract(Tract tract, int n) {
        if (n < 0 || n > this.numberOfTracts) {
            return;
        }
        this.totalPoints -= this.tracts[n].numberOfPoints();
        this.tracts[n] = tract;
        this.totalPoints += tract.numberOfPoints();
    }

    public static TractCollection removeShortTracts(TractCollection tractCollection, int n) {
        TractCollection tractCollection2 = new TractCollection(tractCollection.numberOfTracts + 1, 10.0);
        for (int i = 0; i < tractCollection.numberOfTracts; ++i) {
            if (tractCollection.getTract(i).numberOfPoints() < n) continue;
            tractCollection2.addTract(tractCollection.getTract(i));
        }
        return tractCollection2;
    }

    public void writeRawTracts(DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < this.numberOfTracts(); ++i) {
            this.tracts[i].writeRaw(dataOutputStream);
        }
    }
}

