/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.AxialDistribution;
import numerics.Vector3D;
import tractography.PICoRandomizer;

public abstract class SimplePICoRandomizer
implements PICoRandomizer {
    private final AxialDistribution[][][][] pdfs;

    protected SimplePICoRandomizer(int n, int n2, int n3) {
        this.pdfs = new AxialDistribution[n][n2][n3][];
    }

    @Override
    public final Vector3D[] getRandomizedPDs(int n, int n2, int n3) {
        if (this.pdfs[n][n2][n3] == null) {
            this.pdfs[n][n2][n3] = this.getPDFs(n, n2, n3);
        }
        Vector3D[] vector3DArray = new Vector3D[this.pdfs[n][n2][n3].length];
        for (int i = 0; i < this.pdfs[n][n2][n3].length; ++i) {
            vector3DArray[i] = this.pdfs[n][n2][n3][i].nextVector();
        }
        return vector3DArray;
    }

    @Override
    public final double pdf(int n, int n2, int n3, int n4, Vector3D vector3D) {
        if (this.pdfs[n][n2][n3] == null) {
            this.pdfs[n][n2][n3] = this.getPDFs(n, n2, n3);
        }
        return this.pdfs[n][n2][n3][n4].pdf(vector3D);
    }

    protected abstract AxialDistribution[] getPDFs(int var1, int var2, int var3);
}

