/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import misc.LoggedException;
import numerics.Point3D;
import tractography.FreeFormROI;
import tractography.RegionOfInterest;
import tractography.Voxel;

public final class PointListROI
implements RegionOfInterest {
    private final FreeFormROI voxelROI;
    private final Point3D[] points;
    private final Voxel[] voxels;
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;

    public PointListROI(Point3D[] point3DArray, int n, int n2, int n3, double d, double d2, double d3) {
        this(point3DArray, new int[]{n, n2, n3}, new double[]{d, d2, d3});
    }

    public PointListROI(Point3D[] point3DArray, int[] nArray, double[] dArray) {
        this.xDataDim = nArray[0];
        this.yDataDim = nArray[1];
        this.zDataDim = nArray[2];
        this.xVoxelDim = dArray[0];
        this.yVoxelDim = dArray[1];
        this.zVoxelDim = dArray[2];
        this.points = new Point3D[point3DArray.length];
        System.arraycopy(point3DArray, 0, this.points, 0, this.points.length);
        short[][][] sArray = new short[this.xDataDim][this.yDataDim][this.zDataDim];
        this.voxels = new Voxel[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            int n = (int)(this.points[i].x / this.xVoxelDim);
            int n2 = (int)(this.points[i].y / this.yVoxelDim);
            int n3 = (int)(this.points[i].z / this.zVoxelDim);
            this.voxels[i] = new Voxel(n, n2, n3);
            sArray[n][n2][n3] = 1;
        }
        this.voxelROI = new FreeFormROI(sArray, dArray);
    }

    public static PointListROI readPoints(String string, int[] nArray, double[] dArray) {
        Point3D[] point3DArray = null;
        ArrayList<Point3D> arrayList = new ArrayList<Point3D>(100);
        try {
            String[] stringArray;
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null && (stringArray = string2.split("\\s+")).length >= 3) {
                Point3D point3D = new Point3D(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]));
                arrayList.add(point3D);
                string2 = bufferedReader.readLine();
            }
            point3DArray = new Point3D[arrayList.size()];
            arrayList.toArray(point3DArray);
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        return new PointListROI(point3DArray, nArray, dArray);
    }

    @Override
    public boolean containsVoxel(int n, int n2, int n3) {
        return this.voxelROI.containsVoxel(n, n2, n3);
    }

    @Override
    public boolean containsMMPoint(Point3D point3D) {
        return this.voxelROI.containsMMPoint(point3D);
    }

    @Override
    public Voxel[] getVoxels() {
        Voxel[] voxelArray = new Voxel[this.voxels.length];
        System.arraycopy(this.voxels, 0, voxelArray, 0, this.voxels.length);
        return voxelArray;
    }

    @Override
    public Point3D[] getSeedPoints() {
        Point3D[] point3DArray = new Point3D[this.points.length];
        System.arraycopy(this.points, 0, point3DArray, 0, this.points.length);
        return point3DArray;
    }

    @Override
    public int numberOfRegions() {
        return 1;
    }

    @Override
    public RegionOfInterest getRegion(int n) {
        if (n == 0) {
            return this;
        }
        throw new IllegalArgumentException("ROI index out of bounds. This ROI contains " + this.numberOfRegions() + " regions");
    }
}

