/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Vector3D;
import tractography.BootstrapTractographyImage;
import tractography.PICoRandomizer;

public class PICoBootstrapRandomizer
implements PICoRandomizer {
    private final BootstrapTractographyImage image;
    private final Vector3D[][][][] pds;

    public PICoBootstrapRandomizer(BootstrapTractographyImage bootstrapTractographyImage) {
        this.image = bootstrapTractographyImage;
        this.pds = new Vector3D[bootstrapTractographyImage.xDataDim()][bootstrapTractographyImage.yDataDim()][bootstrapTractographyImage.zDataDim()][];
    }

    @Override
    public Vector3D[] getRandomizedPDs(int n, int n2, int n3) {
        this.pds[n][n2][n3] = this.image.getPDs(n, n2, n3);
        return this.pds[n][n2][n3];
    }

    @Override
    public double pdf(int n, int n2, int n3, int n4, Vector3D vector3D) {
        if (this.pds[n][n2][n3][n4] == null) {
            this.getRandomizedPDs(n, n2, n3);
        }
        return Math.abs(this.pds[n][n2][n3][n4].dot(vector3D));
    }
}

