/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Random;
import numerics.AxialDistribution;
import numerics.BinghamDistribution;
import numerics.ConvergenceException;
import numerics.Vector3D;
import numerics.WatsonDistribution;
import tractography.PICoTractographyImage;
import tractography.SimplePICoRandomizer;

public class PICoBinghamRandomizer
extends SimplePICoRandomizer {
    private final PICoTractographyImage image;
    private final Random ran;

    protected PICoBinghamRandomizer(PICoTractographyImage pICoTractographyImage, Random random) {
        super(pICoTractographyImage.xDataDim(), pICoTractographyImage.yDataDim(), pICoTractographyImage.zDataDim());
        this.image = pICoTractographyImage;
        this.ran = random;
    }

    @Override
    protected AxialDistribution[] getPDFs(int n, int n2, int n3) {
        double[] dArray = this.image.getPICoPDFParams(n, n2, n3);
        Vector3D[] vector3DArray = this.image.getEigenvectors(n, n2, n3);
        AxialDistribution[] axialDistributionArray = new AxialDistribution[vector3DArray.length / 3];
        for (int i = 0; i < axialDistributionArray.length; ++i) {
            try {
                Vector3D[] vector3DArray2 = new Vector3D[]{vector3DArray[3 * i], vector3DArray[3 * i + 1], vector3DArray[3 * i + 2]};
                axialDistributionArray[i] = BinghamDistribution.getBinghamDistribution(vector3DArray2, new double[]{dArray[2 * i], dArray[2 * i + 1]}, this.ran);
                continue;
            }
            catch (ConvergenceException convergenceException) {
                double d = dArray[2 * i];
                double d2 = dArray[2 * i + 1];
                if (d < d2 && d2 == 0.0) {
                    axialDistributionArray[i] = new WatsonDistribution(vector3DArray[3 * i + 2], d, this.ran);
                    continue;
                }
                throw new RuntimeException("Can't get distribution for pdf " + n + ", " + n2 + ", " + n3 + " with params " + dArray[2 * i] + " " + dArray[2 * i + 1]);
            }
        }
        return axialDistributionArray;
    }
}

