/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import misc.LoggedException;
import tractography.OutsideLUTRangeException;

public class LookupTable {
    private final int valuesPerPosition;
    private final double[][][] lut;
    private final int dimension;
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;
    private final double zMin;
    private final double zMax;
    private final double xStep;
    private final double yStep;
    private final double zStep;

    public LookupTable(double[][][] dArray, double[] dArray2, double[] dArray3, int n) {
        this.lut = dArray;
        this.xMin = dArray2[0];
        this.xMax = dArray2[1];
        this.yMin = dArray2[2];
        this.yMax = dArray2[3];
        this.zMin = dArray2[4];
        this.zMax = dArray2[5];
        this.xStep = dArray3[0];
        this.yStep = dArray3[1];
        this.zStep = dArray3[2];
        this.valuesPerPosition = n;
        if (dArray.length == 1) {
            if (dArray[0].length == 1) {
                this.dimension = 1;
                if ((1 + (int)Math.round((this.zMax - this.zMin) / this.zStep)) * n != dArray[0][0].length) {
                    throw new IllegalArgumentException("LUT has the wrong dimensions for given range and step size: zRange " + this.zMin + " " + this.zMax + " step " + this.zStep + " values per position " + n);
                }
            } else {
                this.dimension = 2;
                if (1 + (int)Math.round((this.yMax - this.yMin) / this.yStep) != dArray[0].length || n * (1 + (int)Math.round((this.zMax - this.zMin) / this.zStep)) != dArray[0][0].length) {
                    throw new IllegalArgumentException("LUT has the wrong dimensions for given range and step size: yRange " + this.yMin + " " + this.yMax + " zRange " + this.zMin + " " + this.zMax + " step " + this.yStep + " " + this.zStep + " values per position " + n);
                }
            }
        } else {
            this.dimension = 3;
            if (1 + (int)Math.round((this.xMax - this.xMin) / this.xStep) != dArray.length || 1 + (int)Math.round((this.yMax - this.yMin) / this.yStep) != dArray[0].length || n * (1 + (int)Math.round((this.zMax - this.zMin) / this.zStep)) != dArray[0][0].length) {
                throw new IllegalArgumentException("LUT has the wrong dimensions for given range and step size: xRange " + this.xMin + " " + this.xMax + " yRange " + this.yMin + " " + this.yMax + " zRange " + this.zMin + " " + this.zMax + " step " + this.xStep + " " + this.yStep + " " + this.zStep + " values per position " + n + ". LUT dimensions: " + dArray.length + " " + dArray[0].length + " " + dArray[0][0].length);
            }
        }
    }

    public double[] getValues(double d, double d2, double d3, boolean bl, boolean bl2) throws OutsideLUTRangeException {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (bl2) {
            if (d3 < this.zMin) {
                d3 = this.zMin;
            } else if (d3 > this.zMax) {
                d3 = this.zMax;
            }
        } else if (d3 < this.zMin || d3 > this.zMax) {
            throw new OutsideLUTRangeException("LUT index " + d + " " + d2 + " " + d3 + " is outside LUT range.");
        }
        d6 = (d3 - this.zMin) / this.zStep;
        if (this.dimension > 1) {
            if (bl2) {
                if (d2 < this.yMin) {
                    d2 = this.yMin;
                } else if (d2 > this.yMax) {
                    d2 = this.yMax;
                }
            } else if (d2 < this.yMin || d2 > this.yMax) {
                throw new OutsideLUTRangeException("LUT index " + d + " " + d2 + " is outside LUT range.");
            }
            d5 = (d2 - this.yMin) / this.yStep;
        }
        if (this.dimension > 2) {
            if (bl2) {
                if (d < this.xMin) {
                    d = this.xMin;
                } else if (d > this.xMax) {
                    d = this.xMax;
                }
            } else if (d < this.xMin || d > this.xMax) {
                throw new OutsideLUTRangeException("LUT index " + d + " " + d2 + " is outside LUT range.");
            }
            d4 = (d - this.xMin) / this.xStep;
        }
        double[] dArray = new double[this.valuesPerPosition];
        if (this.dimension == 1) {
            int n = (int)d6;
            double d7 = d6 - (double)n;
            if (d3 == this.zMax) {
                n = (int)Math.round(d6);
                d7 = 0.0;
            }
            if (bl) {
                for (int i = 0; i < this.valuesPerPosition; ++i) {
                    double d8 = this.lut[0][0][this.valuesPerPosition * n + i];
                    double d9 = 0.0;
                    d9 = d3 < this.zMax ? this.lut[0][0][this.valuesPerPosition * (n + 1) + i] : d8;
                    dArray[i] = (1.0 - d7) * d8 + d7 * d9;
                }
            } else {
                int n2 = d7 > 0.5 ? n + 1 : n;
                for (int i = 0; i < this.valuesPerPosition; ++i) {
                    dArray[i] = this.lut[0][0][this.valuesPerPosition * n2 + i];
                }
            }
        } else if (this.dimension == 2) {
            int n = (int)d5;
            int n3 = (int)d6;
            double d10 = d5 - (double)n;
            double d11 = d6 - (double)n3;
            if (d2 == this.yMax) {
                n = (int)Math.round(d5);
                d10 = 0.0;
            }
            if (d3 == this.zMax) {
                n3 = (int)Math.round(d6);
                d11 = 0.0;
            }
            if (bl) {
                for (int i = 0; i < this.valuesPerPosition; ++i) {
                    int n4 = n;
                    int n5 = n3;
                    int n6 = d2 == this.yMax ? n4 : n4 + 1;
                    int n7 = d3 == this.zMax ? n5 : n5 + 1;
                    double d12 = this.lut[0][n4][this.valuesPerPosition * n5 + i];
                    double d13 = this.lut[0][n4][this.valuesPerPosition * n7 + i];
                    double d14 = this.lut[0][n6][this.valuesPerPosition * n5 + i];
                    double d15 = this.lut[0][n6][this.valuesPerPosition * n7 + i];
                    double[] dArray2 = new double[4];
                    dArray[i] = (1.0 - d10) * (1.0 - d11) * d12 + d10 * (1.0 - d11) * d14 + (1.0 - d10) * d11 * d13 + d10 * d11 * d15;
                }
            } else {
                int n8 = d10 < 0.5 ? n : n + 1;
                int n9 = d11 < 0.5 ? n3 : n3 + 1;
                for (int i = 0; i < this.valuesPerPosition; ++i) {
                    dArray[i] = this.lut[0][n8][this.valuesPerPosition * n9 + i];
                }
            }
        } else {
            int n = (int)d4;
            int n10 = (int)d5;
            int n11 = (int)d6;
            double d16 = d4 - (double)n;
            double d17 = d5 - (double)n10;
            double d18 = d6 - (double)n11;
            if (d == this.xMax) {
                n = (int)Math.round(d4);
                d16 = 0.0;
            }
            if (d2 == this.yMax) {
                n10 = (int)Math.round(d5);
                d17 = 0.0;
            }
            if (d3 == this.zMax) {
                n11 = (int)Math.round(d6);
                d18 = 0.0;
            }
            if (bl) {
                for (int i = 0; i < this.valuesPerPosition; ++i) {
                    int n12 = n;
                    int n13 = n10;
                    int n14 = n11;
                    int n15 = d == this.xMax ? n12 : n12 + 1;
                    int n16 = d2 == this.yMax ? n13 : n13 + 1;
                    int n17 = d3 == this.zMax ? n14 : n14 + 1;
                    double d19 = this.lut[n12][n13][this.valuesPerPosition * n14 + i];
                    double d20 = this.lut[n12][n13][this.valuesPerPosition * n17 + i];
                    double d21 = this.lut[n12][n16][this.valuesPerPosition * n14 + i];
                    double d22 = this.lut[n12][n16][this.valuesPerPosition * n17 + i];
                    double d23 = this.lut[n15][n13][this.valuesPerPosition * n14 + i];
                    double d24 = this.lut[n15][n13][this.valuesPerPosition * n17 + i];
                    double d25 = this.lut[n15][n16][this.valuesPerPosition * n14 + i];
                    double d26 = this.lut[n15][n16][this.valuesPerPosition * n17 + i];
                    double[] dArray3 = new double[]{(1.0 - d16) * (1.0 - d17) * (1.0 - d18), (1.0 - d16) * (1.0 - d17) * d18, (1.0 - d16) * d17 * (1.0 - d18), (1.0 - d16) * d17 * d18, d16 * (1.0 - d17) * (1.0 - d18), d16 * (1.0 - d17) * d18, d16 * d17 * (1.0 - d18), d16 * d17 * d18};
                    dArray[i] = d19 * dArray3[0] + d20 * dArray3[1] + d21 * dArray3[2] + d22 * dArray3[3] + d23 * dArray3[4] + d24 * dArray3[5] + d25 * dArray3[6] + d26 * dArray3[7];
                }
            } else {
                int n18 = d16 < 0.5 ? n : n + 1;
                int n19 = d17 < 0.5 ? n10 : n10 + 1;
                int n20 = d18 < 0.5 ? n11 : n11 + 1;
                for (int i = 0; i < this.valuesPerPosition; ++i) {
                    dArray[i] = this.lut[n18][n19][this.valuesPerPosition * n20 + i];
                }
            }
        }
        return dArray;
    }

    public double[] getValues(double d, boolean bl, boolean bl2) throws OutsideLUTRangeException {
        if (this.dimension == 1) {
            return this.getValues(0.0, 0.0, d, bl, bl2);
        }
        throw new OutsideLUTRangeException("LUT requires " + this.dimension + " indices");
    }

    public double[] getValues(double d, double d2, boolean bl, boolean bl2) throws OutsideLUTRangeException {
        if (this.dimension == 2) {
            return this.getValues(0.0, d, d2, bl, bl2);
        }
        throw new OutsideLUTRangeException("LUT requires " + this.dimension + " indices");
    }

    public double xMin() {
        return this.xMin;
    }

    public double yMin() {
        return this.yMin;
    }

    public double xMax() {
        return this.xMax;
    }

    public double yMax() {
        return this.yMax;
    }

    public double zMin() {
        return this.zMin;
    }

    public double zMax() {
        return this.zMax;
    }

    public double xStep() {
        return this.xStep;
    }

    public double yStep() {
        return this.yStep;
    }

    public double zStep() {
        return this.zStep;
    }

    public int dimension() {
        return this.dimension;
    }

    public int valuesPerPosition() {
        return this.valuesPerPosition;
    }

    public static LookupTable readLUT(String string) {
        FileInputStream fileInputStream = null;
        if (string == null) {
            throw new LoggedException("Tried to read LUT, but file name is null");
        }
        try {
            fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream, 0x400000));
            double d = dataInputStream.readDouble();
            double d2 = dataInputStream.readDouble();
            double d3 = dataInputStream.readDouble();
            double d4 = dataInputStream.readDouble();
            double d5 = dataInputStream.readDouble();
            double d6 = dataInputStream.readDouble();
            double d7 = dataInputStream.readDouble();
            double d8 = dataInputStream.readDouble();
            double d9 = dataInputStream.readDouble();
            int n = (int)dataInputStream.readDouble();
            double[][][] dArray = new double[1 + (int)Math.round((d2 - d) / d7)][1 + (int)Math.round((d4 - d3) / d8)][n * (1 + (int)Math.round((d6 - d5) / d9))];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < dArray[0][0].length / n; ++j) {
                    for (int k = 0; k < dArray[0].length; ++k) {
                        for (int i2 = 0; i2 < dArray.length; ++i2) {
                            dArray[i2][k][j * n + i] = dataInputStream.readDouble();
                        }
                    }
                }
            }
            dataInputStream.close();
            LookupTable lookupTable = new LookupTable(dArray, new double[]{d, d2, d3, d4, d5, d6}, new double[]{d7, d8, d9}, n);
            return lookupTable;
        }
        catch (IOException iOException) {
            throw new LoggedException(Thread.currentThread().getName(), iOException);
        }
    }
}

