/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import data.VoxelOrderDataSource;
import misc.DT;
import misc.LoggedException;
import numerics.Vector3D;
import tractography.PD_TractographyImage;

public class DT_TractographyImage
extends PD_TractographyImage {
    private final DT[][][][] tensors;
    private final double[][][][] mix;

    public DT_TractographyImage(DT[][][][] dTArray, double[][][][] dArray, int[][][] nArray, int[] nArray2, double[] dArray2) {
        super(nArray2, dArray2, 1);
        this.tensors = dTArray;
        this.mix = dArray;
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    this.numPDs[i][j][k] = nArray[i][j][k];
                }
            }
        }
        this.computeIsotropicMask();
    }

    public DT_TractographyImage(VoxelOrderDataSource voxelOrderDataSource, int n, int[] nArray, double[] dArray) {
        super(nArray, dArray, 1);
        this.tensors = new DT[this.xDataDim][this.yDataDim][this.zDataDim][];
        this.mix = new double[this.xDataDim][this.yDataDim][this.zDataDim][];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    double[] dArray2 = voxelOrderDataSource.nextVoxel();
                    if (n == 1) {
                        this.numPDs[k][j][i] = dArray2[0] < 0.0 ? 0 : 1;
                        this.tensors[k][j][i] = new DT[this.numPDs[k][j][i]];
                        if (this.tensors[k][j][i].length == 1) {
                            this.tensors[k][j][i][0] = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
                            this.mix[k][j][i] = new double[]{1.0};
                            continue;
                        }
                        this.mix[k][j][i] = new double[0];
                        continue;
                    }
                    int n2 = this.numPDs[k][j][i] = dArray2[0] < 0.0 ? 0 : (int)dArray2[2];
                    if (this.numPDs[k][j][i] < 0 || this.numPDs[k][j][i] > n) {
                        throw new LoggedException("Invalid number of components in input data. Check -inputmodel and -numpds options");
                    }
                    this.tensors[k][j][i] = new DT[this.numPDs[k][j][i]];
                    this.mix[k][j][i] = new double[this.numPDs[k][j][i]];
                    for (int i2 = 0; i2 < this.numPDs[k][j][i]; ++i2) {
                        int n3 = 4 + i2 * 7;
                        this.mix[k][j][i][i2] = dArray2[n3 - 1];
                        this.tensors[k][j][i][i2] = new DT(dArray2[n3], dArray2[n3 + 1], dArray2[n3 + 2], dArray2[n3 + 3], dArray2[n3 + 4], dArray2[n3 + 5]);
                    }
                }
            }
        }
        this.computeIsotropicMask();
    }

    protected DT_TractographyImage(DT_TractographyImage dT_TractographyImage) {
        super(new int[]{dT_TractographyImage.xDataDim, dT_TractographyImage.yDataDim, dT_TractographyImage.zDataDim}, new double[]{dT_TractographyImage.xVoxelDim, dT_TractographyImage.yVoxelDim, dT_TractographyImage.zVoxelDim}, 1);
        this.tensors = new DT[this.xDataDim][this.yDataDim][this.zDataDim][];
        this.mix = new double[this.xDataDim][this.yDataDim][this.zDataDim][];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.numPDs[k][j][i] = dT_TractographyImage.numPDs[k][j][i];
                    this.tensors[k][j][i] = new DT[this.numPDs[k][j][i]];
                    this.mix[k][j][i] = new double[this.numPDs[k][j][i]];
                    for (int i2 = 0; i2 < this.numPDs[k][j][i]; ++i2) {
                        this.tensors[k][j][i][i2] = dT_TractographyImage.tensors[k][j][i][i2];
                        this.mix[k][j][i][i2] = dT_TractographyImage.mix[k][j][i][i2];
                    }
                }
            }
        }
        this.computeIsotropicMask();
    }

    public void computeIsotropicMask(double d) {
        this.isotropicMask = new boolean[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (this.numPDs[k][j][i] == 0) {
                        this.isotropicMask[k][j][i] = true;
                        continue;
                    }
                    if (this.numPDs[k][j][i] != 1 || !(this.tensors[k][j][i][0].fa() < d)) continue;
                    this.isotropicMask[k][j][i] = true;
                }
            }
        }
    }

    @Override
    public Vector3D[] getPDs(int n, int n2, int n3) {
        if (this.vectors[n][n2][n3] == null) {
            this.vectors[n][n2][n3] = new Vector3D[this.tensors[n][n2][n3].length];
            for (int i = 0; i < this.tensors[n][n2][n3].length; ++i) {
                double[][] dArray = this.tensors[n][n2][n3][i].sortedEigenSystem();
                this.vectors[n][n2][n3][i] = new Vector3D(dArray[1][0], dArray[2][0], dArray[3][0]);
            }
        }
        return super.getPDs(n, n2, n3);
    }

    public DT[] getDTs(int n, int n2, int n3) {
        return this.tensors[n][n2][n3];
    }

    public double[] getMix(int n, int n2, int n3) {
        return this.mix[n][n2][n3];
    }

    public static final DT_TractographyImage getDT_TractographyImage(String string, String string2, int n, double[][][] dArray, double d, int[] nArray, double[] dArray2) {
        int n2 = 8;
        if (n > 1) {
            n2 = 3 + n * 7;
        }
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n2, string2);
        DT_TractographyImage dT_TractographyImage = new DT_TractographyImage(voxelOrderDataSource, n, nArray, dArray2);
        if (dArray != null) {
            dT_TractographyImage.computeIsotropicMask(dArray, d);
        } else if (d > 0.0) {
            dT_TractographyImage.computeIsotropicMask(d);
        }
        return dT_TractographyImage;
    }
}

