/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import numerics.Complex;
import numerics.SphericalHarmonics;
import sphfunc.ImagSH;
import sphfunc.LinearBasisFunction;
import sphfunc.LinearBasisSum;
import sphfunc.RealSH;

public class EvenSHS
extends LinearBasisSum {
    private int maxOrder;

    public EvenSHS(double[] dArray, int n) {
        this.maxOrder = n;
        this.c = new double[SphericalHarmonics.evenFuncsUpTo(this.maxOrder)];
        for (int i = 0; i < this.c.length; ++i) {
            this.c[i] = dArray[i + 2];
        }
    }

    @Override
    public double getRadius(double d, double d2) {
        double d3 = 0.0;
        int n = 0;
        for (int i = 0; i <= this.maxOrder; i += 2) {
            try {
                Complex complex = SphericalHarmonics.Y(i, 0, d, d2);
                d3 += this.c[n] * complex.real();
                ++n;
                for (int j = 1; j <= i; ++j) {
                    complex = SphericalHarmonics.Y(i, j, d, d2);
                    d3 += 2.0 * this.c[n] * complex.real() - 2.0 * this.c[n + 1] * complex.imag();
                    n += 2;
                }
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return d3;
    }

    @Override
    public double getRadius(double d, double d2, double d3) {
        double[] dArray = this.toAngles(d, d2, d3);
        return this.getRadius(dArray[0], dArray[1]);
    }

    public String toString() {
        String string = "";
        for (int i = 0; i <= this.maxOrder; i += 2) {
            for (int j = -i; j <= i; ++j) {
                string = string + this.getCoeff(i, j) + "\n";
            }
            string = string + "\n";
        }
        return string;
    }

    public Complex getCoeff(int n, int n2) {
        if (n > this.maxOrder || Math.abs(n2) > n || n % 2 != 0) {
            return new Complex(0.0, 0.0);
        }
        int n3 = (n - 1) * ((n - 2) / 2 + 1);
        if (n2 == 0) {
            return new Complex(this.c[n3], 0.0);
        }
        int n4 = 2 * Math.abs(n2) - 1;
        Complex complex = new Complex(this.c[n3 + n4], this.c[n3 + n4 + 1]);
        if (n2 < 0) {
            complex = n2 % 2 == 0 ? complex.conjugate() : complex.conjugate().negate();
        }
        return complex;
    }

    @Override
    public double anisotropy() {
        int n = 0;
        double d = this.c[n];
        double d2 = d * d;
        ++n;
        for (int i = 2; i <= this.maxOrder; i += 2) {
            d2 += this.c[n] * this.c[n];
            ++n;
            for (int j = 0; j < 2 * i; ++j) {
                d2 += 2.0 * this.c[n] * this.c[n];
                ++n;
            }
        }
        return d2 == 0.0 ? 0.0 : Math.sqrt((d2 - d * d) / d2);
    }

    private int getOrder(int n) {
        int n2 = 0;
        for (int i = 1; i < n; i += 2 * (n2 += 2) + 1) {
        }
        return n2;
    }

    @Override
    public LinearBasisFunction basisFunction(int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (n3 == 0) {
                n3 += 2;
                continue;
            }
            if (n2 == n3 && !bl) {
                n3 += 2;
                n2 = 0;
                bl = true;
                continue;
            }
            if (n2 == 0) {
                n2 = 1;
                continue;
            }
            if (bl) {
                bl = false;
                continue;
            }
            bl = true;
            ++n2;
        }
        double d = 1.0;
        if (n2 > 0) {
            double d2 = d = bl ? 2.0 : -2.0;
        }
        if (bl) {
            return new RealSH(n3, n2, d);
        }
        return new ImagSH(n3, n2, d);
    }

    @Override
    public String getSettings() {
        String string = "basis type = sh\norder = " + this.maxOrder + "\n\n";
        return string;
    }
}

