/*
 * Decompiled with CFR 0.152.
 */
package simulation.measurement;

import imaging.Scheme;
import java.util.logging.Logger;
import misc.LoggedException;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.Substrate;
import simulation.measurement.PGSEscan;
import simulation.measurement.SyntheticScan;

public class ScanFactory {
    public static final int PGSE_SCAN = 0;
    public static final int TWICE_REFOCUSED = 1;
    private static Logger logger = Logger.getLogger("simulation.measurement.ScanFactory");

    public static final SyntheticScan getMeasurementModule(SimulationParams simulationParams, Scheme scheme, Substrate substrate, Walker[] walkerArray) {
        if (SimulationParams.scanType == 0) {
            return new PGSEscan(simulationParams, scheme, substrate, walkerArray);
        }
        if (SimulationParams.scanType == 1) {
            if (scheme.getVersion() != 2) {
                throw new LoggedException("Twice refocssed spin-echo sequence requires a type 2 scheme file");
            }
            return new PGSEscan(simulationParams, scheme, substrate, walkerArray);
        }
        throw new LoggedException("sythetic scan type " + SimulationParams.scanType + " not known. no synthetic scan returned");
    }
}

