/*
 * Decompiled with CFR 0.152.
 */
package simulation.measurement;

import data.OutputManager;
import data.StandardTestFunctions;
import imaging.Scheme;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.Substrate;
import simulation.measurement.SyntheticScan;
import tools.CL_Initializer;

public class PGSEscan
implements SyntheticScan {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int D = 3;
    private final int N_walkers;
    private Walker[] walker;
    private final double[][] gradient;
    private final double snr;
    private double noiseDev;
    private final MTRandom twister = new MTRandom(1744790527L);
    private final int numMeas;
    private static final double GAMMA = 2.6751987E8;
    private final double[] G;
    private final double[] delta;
    private final double[] DELTA;
    private final double dt;
    private final double[] firstBlockStart;
    private final double[] firstBlockEnd;
    private final double[] secondBlockStart;
    private final double[] secondBlockEnd;
    private final Substrate substrate;
    private final int scanType = 0;

    protected PGSEscan(SimulationParams simulationParams, Scheme scheme, Substrate substrate, Walker[] walkerArray) {
        int n;
        this.numMeas = scheme.numMeasurements();
        this.G = new double[this.numMeas];
        this.delta = new double[this.numMeas];
        this.DELTA = new double[this.numMeas];
        this.gradient = new double[this.numMeas][];
        this.firstBlockStart = new double[this.numMeas];
        this.firstBlockEnd = new double[this.numMeas];
        this.secondBlockStart = new double[this.numMeas];
        this.secondBlockEnd = new double[this.numMeas];
        for (n = 0; n < this.numMeas; ++n) {
            int n2;
            this.G[n] = scheme.getModG(n);
            this.delta[n] = scheme.getDelta(n);
            this.DELTA[n] = scheme.getDELTA(n);
            this.gradient[n] = scheme.getQ(n);
            double d = 0.0;
            for (n2 = 0; n2 < this.gradient[n].length; ++n2) {
                d += this.gradient[n][n2] * this.gradient[n][n2];
            }
            if ((d = Math.sqrt(d)) > 0.0) {
                n2 = 0;
                while (n2 < this.gradient[n].length) {
                    double[] dArray = this.gradient[n];
                    int n3 = n2++;
                    dArray[n3] = dArray[n3] / d;
                }
            }
            if (!(this.delta[n] >= this.DELTA[n])) continue;
            this.logger.warning("WARNING! gradient block duration in measurement " + n + " (delta=" + this.delta[n] + "s) in synthetic scan is longer than interval between blocks (" + this.DELTA[n] + "s)");
        }
        this.snr = CL_Initializer.SNR;
        this.substrate = substrate;
        this.N_walkers = simulationParams.getN_walkers();
        this.walker = walkerArray;
        this.dt = simulationParams.getDt();
        for (n = 0; n < this.numMeas; ++n) {
            this.firstBlockStart[n] = scheme.getHalfP90(n);
            this.firstBlockEnd[n] = this.firstBlockStart[n] + this.delta[n];
            this.secondBlockStart[n] = this.firstBlockStart[n] + this.DELTA[n];
            this.secondBlockEnd[n] = this.secondBlockStart[n] + this.delta[n];
        }
    }

    @Override
    public double getPhaseShift(Walker walker, double d, int n, double d2) {
        double d3 = 1.0;
        if (d < this.firstBlockStart[n]) {
            return 0.0;
        }
        if (d >= this.firstBlockEnd[n] && d < this.secondBlockStart[n]) {
            if (d >= this.firstBlockEnd[n] && d2 < this.firstBlockEnd[n]) {
                double d4 = this.firstBlockEnd[n] - d2;
                double d5 = 0.0;
                for (int i = 0; i < 3; ++i) {
                    d5 += this.gradient[n][i] * (walker.r[i] - walker.r0[i]);
                }
                double d6 = 2.6751987E8 * this.G[n] * d5 * d4;
                return d3 * d6;
            }
            return 0.0;
        }
        if (d >= this.secondBlockEnd[n]) {
            if (d >= this.secondBlockEnd[n] && d2 < this.secondBlockEnd[n]) {
                double d7 = this.secondBlockEnd[n] - d2;
                double d8 = 0.0;
                for (int i = 0; i < 3; ++i) {
                    d8 += this.gradient[n][i] * (walker.r[i] - walker.r0[i]);
                }
                double d9 = 2.6751987E8 * this.G[n] * d8 * d7;
                return d3 * d9;
            }
            return 0.0;
        }
        if (d >= this.secondBlockStart[n]) {
            d3 = -1.0;
        }
        if (d >= this.secondBlockStart[n] && d2 < this.secondBlockStart[n]) {
            double d10 = d - this.secondBlockStart[n];
            double d11 = 0.0;
            for (int i = 0; i < 3; ++i) {
                d11 += this.gradient[n][i] * (walker.r[i] - walker.r0[i]);
            }
            double d12 = 2.6751987E8 * this.G[n] * d11 * d10;
            return d3 * d12;
        }
        double d13 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d13 += this.gradient[n][i] * (walker.r[i] - walker.r0[i]);
        }
        double d14 = 2.6751987E8 * this.G[n] * d13 * this.dt;
        return d3 * d14;
    }

    public static double getPhaseShift(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double[] dArray2, double d7) {
        double d8 = 1.0;
        if (d < d3) {
            return 0.0;
        }
        if (d >= d4 && d < d5) {
            if (d >= d4 && d2 < d4) {
                double d9 = d4 - d2;
                double d10 = 0.0;
                for (int i = 0; i < 3; ++i) {
                    d10 += dArray2[i] * dArray[i];
                }
                return d8 * 2.6751987E8 * d7 * d10 * d9;
            }
            return 0.0;
        }
        if (d >= d6) {
            if (d >= d6 && d2 < d6) {
                double d11 = d6 - d2;
                double d12 = 0.0;
                for (int i = 0; i < 3; ++i) {
                    d12 += dArray2[i] * dArray[i];
                }
                return d8 * 2.6751987E8 * d7 * d12 * d11;
            }
            return 0.0;
        }
        if (d >= d5) {
            d8 = -1.0;
        }
        if (d >= d5 && d2 < d5) {
            double d13 = d - d5;
            double d14 = 0.0;
            for (int i = 0; i < 3; ++i) {
                d14 += dArray2[i] * dArray[i];
            }
            return d8 * 2.6751987E8 * d7 * d14 * d13;
        }
        double d15 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d15 += dArray2[i] * dArray[i];
        }
        double d16 = d - d2;
        double d17 = d8 * 2.6751987E8 * d7 * d15 * d16;
        return d17;
    }

    @Override
    public final double getMagnetisationChange(double[] dArray, double d) {
        return 0.0;
    }

    @Override
    public final int getScanType() {
        return 0;
    }

    @Override
    public double[] getSignals() {
        FileWriter fileWriter;
        double d;
        double d2;
        int n;
        double[] dArray = new double[this.numMeas];
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        int n3 = 0;
        double[][] dArray2 = StandardTestFunctions.getRotationMatrix().entries;
        for (n = 0; n < this.gradient.length; ++n) {
            double[] dArray3 = new double[3];
            d2 = 0.0;
            dArray3[0] = this.gradient[n][0] * dArray2[0][0] + this.gradient[n][1] * dArray2[0][1] + this.gradient[n][2] * dArray2[0][2];
            dArray3[1] = this.gradient[n][0] * dArray2[1][0] + this.gradient[n][1] * dArray2[1][1] + this.gradient[n][2] * dArray2[1][2];
            dArray3[2] = this.gradient[n][0] * dArray2[2][0] + this.gradient[n][1] * dArray2[2][1] + this.gradient[n][2] * dArray2[2][2];
            d2 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
            if (d2 > 0.0) {
                dArray3[0] = dArray3[0] / d2;
                dArray3[1] = dArray3[1] / d2;
                dArray3[2] = dArray3[2] / d2;
            }
            this.gradient[n] = dArray3;
        }
        if (this.snr > 0.0) {
            this.noiseDev = (double)this.N_walkers / this.snr;
        }
        this.logger.info("generating " + this.gradient.length + " signals");
        for (n = 0; n < this.gradient.length; ++n) {
            double d5 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
            n2 = 0;
            n3 = 0;
            for (int i = 0; i < this.walker.length; ++i) {
                d2 = this.walker[i].getPhaseShift(n);
                d5 += Math.cos(d2);
                if (this.substrate.intracellular(this.walker[i])) {
                    d3 += Math.cos(d2);
                    ++n2;
                    continue;
                }
                d4 += Math.cos(d2);
                ++n3;
            }
            double d6 = 0.0;
            if (this.snr > 0.0) {
                d6 = this.twister.nextGaussian() * this.noiseDev;
            }
            d5 += d6;
            if (this.snr > 0.0) {
                d6 = this.twister.nextGaussian() * this.noiseDev;
            }
            dArray[n] = Math.sqrt(d5 * d5 + d6 * d6);
            double d7 = d3;
            double d8 = d4;
            d = 2.6751987E8 * this.delta[n] * this.G[n] * (2.6751987E8 * this.delta[n] * this.G[n]) * (this.DELTA[n] - this.delta[n] / 3.0);
            double d9 = Math.exp(-d * CL_Initializer.DIFF_CONST);
            this.logger.info("signal = " + dArray[n] + "  intra= " + d7 + " extra= " + d8 + " (" + n2 + " in, " + n3 + " out)" + " free = " + d9);
        }
        int n4 = 50;
        int[] nArray = new int[n4];
        double[] dArray4 = new double[3];
        for (int i = 0; i < this.walker.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray4[j] = this.walker[i].r[j] - this.walker[i].r0[j];
            }
            d = Math.atan2(dArray4[1], dArray4[0]) + Math.PI;
            int n5 = (int)(d / (Math.PI * 2) * (double)n4);
            if (n5 >= nArray.length) {
                n5 %= nArray.length;
            }
            int n6 = n5;
            nArray[n6] = nArray[n6] + 1;
        }
        try {
            fileWriter = new FileWriter("angDist3.csv");
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        double d10 = Math.PI * 2 / (double)n4;
        for (int i = 0; i < nArray.length; ++i) {
            double d11 = (double)nArray[i] / ((double)this.walker.length * d10);
            double d12 = (double)i * (Math.PI * 2 / (double)n4);
            try {
                fileWriter.write(d12 + "," + d11 + "\n");
                continue;
            }
            catch (IOException iOException) {
                throw new LoggedException(iOException);
            }
        }
        try {
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        return dArray;
    }

    @Override
    public double[] getCompartmentalSignals(boolean bl) {
        int n;
        double[] dArray = new double[this.numMeas];
        int n2 = 0;
        boolean bl2 = false;
        double[][] dArray2 = StandardTestFunctions.getRotationMatrix().entries;
        for (n = 0; n < this.gradient.length; ++n) {
            double[] dArray3 = new double[3];
            double d = 0.0;
            dArray3[0] = this.gradient[n][0] * dArray2[0][0] + this.gradient[n][1] * dArray2[0][1] + this.gradient[n][2] * dArray2[0][2];
            dArray3[1] = this.gradient[n][0] * dArray2[1][0] + this.gradient[n][1] * dArray2[1][1] + this.gradient[n][2] * dArray2[1][2];
            dArray3[2] = this.gradient[n][0] * dArray2[2][0] + this.gradient[n][1] * dArray2[2][1] + this.gradient[n][2] * dArray2[2][2];
            d = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
            if (d > 0.0) {
                dArray3[0] = dArray3[0] / d;
                dArray3[1] = dArray3[1] / d;
                dArray3[2] = dArray3[2] / d;
            }
            this.gradient[n] = dArray3;
        }
        if (this.snr > 0.0) {
            this.noiseDev = (double)this.N_walkers / this.snr;
        }
        this.logger.info("generating " + this.gradient.length + " signals");
        for (n = 0; n < this.gradient.length; ++n) {
            double d = 0.0;
            n2 = 0;
            bl2 = false;
            int n3 = 100;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            for (int i = 0; i < this.walker.length; ++i) {
                double d4 = this.walker[i].getPhaseShift(n);
                if (d4 < d2) {
                    d2 = d4;
                }
                if (d4 > d3) {
                    d3 = d4;
                }
                d += Math.cos(d4);
                if (this.substrate.intracellular(this.walker[i]) != bl) continue;
                d += Math.cos(d4);
                ++n2;
            }
            double d5 = 0.0;
            if (this.snr > 0.0) {
                d5 = this.twister.nextGaussian() * this.noiseDev;
            }
            d += d5;
            if (this.snr > 0.0) {
                d5 = this.twister.nextGaussian() * this.noiseDev;
            }
            dArray[n] = Math.sqrt(d * d + d5 * d5);
        }
        return dArray;
    }

    @Override
    public final void update(int n) {
    }

    @Override
    public int getNumMeasurements() {
        return this.numMeas;
    }

    public static void main(String[] stringArray) {
        String string;
        double d;
        int n;
        int n2 = 3;
        double[] dArray = new double[2];
        int n3 = -1;
        double[] dArray2 = new double[2];
        int n4 = -1;
        double[] dArray3 = new double[2];
        int n5 = -1;
        CL_Initializer.CL_init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-Grange")) {
                dArray[0] = Double.parseDouble(stringArray[i + 1]);
                dArray[1] = Double.parseDouble(stringArray[i + 2]);
                n3 = Integer.parseInt(stringArray[i + 3]);
                CL_Initializer.markAsParsed(i, 4);
                continue;
            }
            if (stringArray[i].equals("-delrange")) {
                dArray2[0] = Double.parseDouble(stringArray[i + 1]);
                dArray2[1] = Double.parseDouble(stringArray[i + 2]);
                n4 = Integer.parseInt(stringArray[i + 3]);
                CL_Initializer.markAsParsed(i, 4);
                continue;
            }
            if (!stringArray[i].equals("-DELrange")) continue;
            dArray3[0] = Double.parseDouble(stringArray[i + 1]);
            dArray3[1] = Double.parseDouble(stringArray[i + 2]);
            n5 = Integer.parseInt(stringArray[i + 3]);
            CL_Initializer.markAsParsed(i, 4);
        }
        CL_Initializer.checkParsing(stringArray);
        CL_Initializer.initImagingScheme();
        Scheme scheme = CL_Initializer.imPars;
        double[][] dArrayArray = new double[scheme.numMeasurements()][];
        for (int i = 0; i < scheme.numMeasurements(); ++i) {
            dArrayArray[i] = scheme.getQ(i);
            double d2 = scheme.getModQ(i);
            if (!(d2 > 0.0)) continue;
            int n6 = 0;
            while (n6 < dArrayArray[i].length) {
                double[] dArray4 = dArrayArray[i];
                int n7 = n6++;
                dArray4[n7] = dArray4[n7] / d2;
            }
        }
        OutputManager outputManager = new OutputManager();
        double[] dArray5 = new double[n3 + 1];
        double[] dArray6 = new double[n5 + 1];
        double[] dArray7 = new double[n4 + 1];
        dArray5[0] = dArray[0];
        dArray5[n3] = dArray[1];
        if (n3 > 0) {
            for (n = 1; n < n3; ++n) {
                d = (dArray[1] - dArray[0]) / (double)n3;
                dArray5[n] = dArray[0] + (double)n * d;
            }
        }
        dArray7[0] = dArray2[0];
        dArray7[n4] = dArray2[1];
        if (n4 > 0) {
            for (n = 1; n < n4; ++n) {
                d = (dArray2[1] - dArray2[0]) / (double)n4;
                dArray7[n] = dArray2[0] + (double)n * d;
            }
        }
        dArray6[0] = dArray3[0];
        dArray6[n5] = dArray3[1];
        if (n5 > 0) {
            for (n = 1; n < n5; ++n) {
                d = (dArray3[1] - dArray3[0]) / (double)n5;
                dArray6[n] = dArray3[0] + (double)n * d;
            }
        }
        if ((string = SimulationParams.trajFile) == null) {
            throw new LoggedException("trajectories filename has not been set.");
        }
        Object var16_22 = null;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n8 = 0;
        double[] dArray8 = new double[scheme.numMeasurements()];
        for (int i = 0; i < dArray6.length; ++i) {
            for (int j = 0; j < dArray7.length; ++j) {
                double d6;
                double d7;
                double d8;
                DataInputStream dataInputStream;
                System.err.println("i= " + i + " j= " + j);
                if (dArray7[j] > dArray6[i]) continue;
                try {
                    dataInputStream = new DataInputStream(new FileInputStream(string));
                    double d9 = dataInputStream.readDouble();
                    if (d9 < dArray7[j] + dArray6[i]) continue;
                    d8 = dataInputStream.readDouble();
                    d7 = dataInputStream.readDouble();
                    d6 = d9 / d7;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
                double[][][] dArray9 = new double[(int)d8][n2][2];
                double d10 = 0.0;
                double d11 = dArray7[j];
                double d12 = dArray6[i];
                double d13 = dArray6[i] + dArray7[j];
                double[] dArray10 = new double[n2];
                try {
                    int n9;
                    int n10;
                    int n11;
                    block12: for (n11 = 0; n11 < (int)d7; ++n11) {
                        for (n10 = 0; n10 < (int)d8; ++n10) {
                            double d14 = dataInputStream.readDouble();
                            int n12 = dataInputStream.readInt();
                            for (n9 = 0; n9 < n2; ++n9) {
                                dArray10[n9] = dataInputStream.readDouble();
                                if (d14 >= d10 && d14 < d11) {
                                    double[] dArray11 = dArray9[n12][n9];
                                    dArray11[0] = dArray11[0] + dArray10[n9];
                                    continue;
                                }
                                if (!(d14 >= d12) || !(d14 < d13)) continue;
                                double[] dArray12 = dArray9[n12][n9];
                                dArray12[1] = dArray12[1] + dArray10[n9];
                            }
                            if (d14 > d13) continue block12;
                        }
                    }
                    for (n11 = 0; n11 < dArray5.length; ++n11) {
                        for (n10 = 0; n10 < dArrayArray.length; ++n10) {
                            dArray8[n10] = 0.0;
                            for (int k = 0; k < dArray9.length; ++k) {
                                double d15 = 0.0;
                                for (n9 = 0; n9 < n2; ++n9) {
                                    d15 += dArrayArray[n10][n9] * (dArray9[k][n9][1] - dArray9[k][n9][0]);
                                }
                                int n13 = n10;
                                dArray8[n13] = dArray8[n13] + Math.cos(d15 *= 2.6751987E8 * dArray5[n11] * d6);
                            }
                            ++n8;
                        }
                        outputManager.output(dArray8);
                    }
                    dataInputStream.close();
                    continue;
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
        }
        outputManager.close();
        d4 = Math.sqrt((d5 /= (double)n8) - (d3 /= (double)n8) * d3);
        System.err.println("mean = " + d5 + "\tstdDev = " + d4);
    }
}

