/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import simulation.SimulationParams;
import simulation.geometry.CellularLattice;

public class StripedCellularLattice
extends CellularLattice {
    private final int stripeThickness;

    public StripedCellularLattice(double d, int n, int n2, SimulationParams simulationParams) {
        super(d, n, simulationParams);
        this.stripeThickness = n2;
        this.initLattice();
    }

    @Override
    public void initLattice() {
        for (int i = 0; i < this.occupiedLength; ++i) {
            int n = 0;
            int n2 = 1;
            for (int j = 0; j < 3; ++j) {
                int n3 = i / n2 % this.L;
                if (j != 1) {
                    n += n3;
                }
                n2 *= this.L;
            }
            this.occupied[i] = n / this.stripeThickness % 2 == 1;
        }
    }

    public static void main(String[] stringArray) {
    }
}

