/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import misc.LoggedException;
import simulation.geometry.Triangle;

public class PLYreader {
    private static Logger logger = Logger.getLogger("simulation.geometry.PLYreader");
    private static HashMap<Triangle, ArrayList<Triangle>> coplanarMap = null;

    protected static final Collection<Triangle> readPLYfile(String string, double d, double d2) {
        int n;
        int n2;
        StringTokenizer stringTokenizer;
        String string2;
        BufferedReader bufferedReader;
        String string3 = null;
        int n3 = 0;
        int n4 = 0;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        try {
            string2 = bufferedReader.readLine();
            if (!string2.equalsIgnoreCase("ply")) {
                throw new LoggedException(string + " is not a PLY file");
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        try {
            logger.info("reading PLY header");
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringTokenizer = new StringTokenizer(string2, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3.equalsIgnoreCase("element")) {
                        string3 = stringTokenizer.nextToken();
                        if (string3.equalsIgnoreCase("vertex")) {
                            string3 = stringTokenizer.nextToken();
                            n3 = Integer.parseInt(string3);
                        }
                        if (string3.equalsIgnoreCase("face")) {
                            string3 = stringTokenizer.nextToken();
                            n4 = Integer.parseInt(string3);
                        }
                    }
                    if (!string3.equalsIgnoreCase("end_header")) continue;
                    logger.info("end of header");
                    break;
                }
                if (!string3.equalsIgnoreCase("end_header")) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        double[][] dArray = new double[n3][3];
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = bufferedReader.readLine();
                stringTokenizer = new StringTokenizer(string2, " ");
                for (n = 0; n < 3; ++n) {
                    string3 = stringTokenizer.nextToken();
                    dArray[n2][n] = Double.parseDouble(string3) / d;
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        ArrayList<Triangle> arrayList = new ArrayList<Triangle>(n4);
        n2 = 0;
        coplanarMap = new HashMap();
        try {
            for (n = 0; n < n4; ++n) {
                int n5;
                Object object32;
                int n6;
                Object object2;
                ++n2;
                string2 = bufferedReader.readLine();
                stringTokenizer = new StringTokenizer(string2, " ");
                string3 = stringTokenizer.nextToken();
                int n7 = Integer.parseInt(string3);
                if (n7 < 3) {
                    logger.warning("found a polygon with " + n7 + " vertices. skipping.");
                    continue;
                }
                if (n7 == 3) {
                    object2 = new double[n7][3];
                    for (n6 = 0; n6 < n7; ++n6) {
                        string3 = stringTokenizer.nextToken();
                        int n8 = Integer.parseInt(string3);
                        for (int i = 0; i < 3; ++i) {
                            object2[n6][i] = dArray[n8][i];
                        }
                    }
                    arrayList.add(new Triangle(object2[0], object2[1], object2[2], d2));
                    continue;
                }
                if (n7 == 4) {
                    object2 = new int[n7];
                    for (n6 = 0; n6 < n7; ++n6) {
                        string3 = stringTokenizer.nextToken();
                        object2[n6] = (double[])Integer.parseInt(string3);
                    }
                    ++n2;
                    double[][] dArray2 = new double[n7][3];
                    for (int i = 0; i < n7; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            dArray2[i][j] = dArray[object2[i]][j];
                        }
                    }
                    Triangle triangle = new Triangle(dArray2[0], dArray2[1], dArray2[2], d2);
                    Triangle triangle2 = new Triangle(dArray2[0], dArray2[2], dArray2[3], d2);
                    arrayList.add(triangle);
                    arrayList.add(triangle2);
                    ArrayList arrayList2 = new ArrayList();
                    object32 = new ArrayList();
                    arrayList2.add(triangle2);
                    ((ArrayList)object32).add(triangle);
                    coplanarMap.put(triangle, arrayList2);
                    coplanarMap.put(triangle2, (ArrayList<Triangle>)object32);
                    continue;
                }
                object2 = new int[n7];
                for (n6 = 0; n6 < n7; ++n6) {
                    string3 = stringTokenizer.nextToken();
                    object2[n6] = (double[])Integer.parseInt(string3);
                }
                double[] dArray3 = new double[]{0.0, 0.0, 0.0};
                for (n5 = 0; n5 < n7; ++n5) {
                    for (int i = 0; i < 3; ++i) {
                        int n8 = i;
                        dArray3[n8] = dArray3[n8] + dArray[object2[n5]][i];
                    }
                }
                n5 = 0;
                while (n5 < 3) {
                    int n9 = n5++;
                    dArray3[n9] = dArray3[n9] / (double)n7;
                }
                n2 += n7 - 1;
                double[][] dArray4 = new double[n7][3];
                for (int i = n7; i > 0; --i) {
                    for (int j = 0; j < 3; ++j) {
                        dArray4[i - 1][j] = dArray[object2[i - 1]][j];
                    }
                }
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                for (int i = n7; i > 0; --i) {
                    object32 = new Triangle(dArray4[i - 1], dArray4[i % n7], dArray3, d2);
                    arrayList.add((Triangle)object32);
                    arrayList3.add(object32);
                }
                for (Object object32 : arrayList3) {
                    ArrayList<Triangle> arrayList4 = new ArrayList<Triangle>();
                    for (Triangle triangle : arrayList3) {
                        if (triangle == object32) continue;
                        arrayList4.add(triangle);
                    }
                    coplanarMap.put((Triangle)object32, arrayList4);
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        logger.info("read and constructed " + n4 + " faces using " + n2 + " triangles");
        return arrayList;
    }

    protected static final HashMap<Triangle, ArrayList<Triangle>> getCoplanarListMap() throws LoggedException {
        if (coplanarMap == null) {
            throw new LoggedException("coplanar triangle map has not been initialised before being fetched");
        }
        return coplanarMap;
    }

    public static void main(String[] stringArray) {
        String string = new String("shark.ply");
        double d = 1.0;
        System.err.print("reading " + string + "... ");
        Collection<Triangle> collection = PLYreader.readPLYfile(string, d, 0.0);
        System.err.println("done\n");
        System.err.flush();
        Iterator<Triangle> iterator = collection.iterator();
        int n = 0;
        System.err.println("read " + collection.size() + " triangles:");
        while (iterator.hasNext()) {
            Triangle triangle = iterator.next();
            System.err.println(n++ + " " + triangle);
        }
        System.err.println("all done");
    }
}

