/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

public class Line {
    private final int D = 3;
    private final double lowerX;
    private final double lowerY;
    private final double upperX;
    private final double upperY;
    private final double len;
    private final double[] normal = new double[3];

    public Line(double d, double d2, double d3, double d4) {
        this.lowerX = d;
        this.lowerY = d2;
        this.upperX = d3;
        this.upperY = d4;
        this.len = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        this.normal[0] = -(d4 - d2);
        this.normal[1] = d3 - d;
        double d5 = Math.sqrt(this.normal[0] * this.normal[0] + this.normal[1] * this.normal[1]);
        this.normal[0] = this.normal[0] / d5;
        this.normal[1] = this.normal[1] / d5;
        this.normal[2] = 0.0;
    }

    public boolean crossedBy(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, double[] dArray5) {
        int n;
        double[] dArray6 = this.getIntersectionParams(dArray[0], dArray[1], dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
        double d2 = 0.0;
        for (int i = 0; i < 2; ++i) {
            d2 += dArray2[i] * dArray2[i];
        }
        if ((d2 = Math.sqrt(d2)) / d <= 1.0E-14) {
            return false;
        }
        if (dArray6[0] > d2) {
            return false;
        }
        if (dArray6[0] < 0.0) {
            return false;
        }
        double d3 = 0.0;
        double d4 = dArray6[0] / d2;
        double[] dArray7 = new double[2];
        for (n = 0; n < 2; ++n) {
            dArray7[n] = dArray[n] + d4 * dArray2[n];
            d3 += (dArray[n] + d4 * dArray2[n]) * this.normal[n];
        }
        if (dArray6[0] < 1.0E-14 * d && bl && d3 == dArray4[0]) {
            return false;
        }
        if (dArray6[1] < 0.0) {
            return false;
        }
        if (dArray6[1] > this.len) {
            return false;
        }
        for (n = 0; n < 2; ++n) {
            dArray3[n] = this.normal[n];
        }
        dArray3[2] = 0.0;
        dArray4[0] = d3;
        dArray5[0] = dArray6[0] / d2;
        return true;
    }

    public double[] normal() {
        return new double[]{this.normal[0], this.normal[1], this.normal[2]};
    }

    public double[] midpoint() {
        return new double[]{(this.upperX + this.lowerX) / 2.0, (this.upperY + this.lowerY) / 2.0};
    }

    private double[] getIntersectionParams(double d, double d2, double d3, double d4) {
        double d5 = d;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = this.lowerX;
        double d10 = this.lowerY;
        double d11 = this.upperX;
        double d12 = this.upperY;
        double d13 = this.det(d5, d6, d7, d8);
        double d14 = d5 - d7;
        double d15 = this.det(d9, d10, d11, d12);
        double d16 = d9 - d11;
        double d17 = this.det(d13, d14, d15, d16);
        double d18 = this.det(d5 - d7, d6 - d8, d9 - d11, d10 - d12);
        double d19 = d17 / d18;
        d14 = d6 - d8;
        d16 = d10 - d12;
        d17 = this.det(d13, d14, d15, d16);
        double d20 = d17 / d18;
        double[] dArray = new double[]{d19 - d, d20 - d2};
        double d21 = dArray[0] * (d3 - d) + dArray[1] * (d4 - d2);
        double d22 = d21 > 0.0 ? 1.0 : -1.0;
        double d23 = d22 * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        dArray[0] = d19 - this.lowerX;
        dArray[1] = d20 - this.lowerY;
        d21 = dArray[0] * (this.upperX - this.lowerX) + dArray[1] * (this.upperY - this.lowerY);
        d22 = d21 > 0.0 ? 1.0 : -1.0;
        double d24 = d22 * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        return new double[]{d23, d24};
    }

    private double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    public static void main(String[] stringArray) {
        int n;
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        Line line = new Line(d, d2, d3, d4);
        double[] dArray = new double[]{0.0, 0.5, 0.0};
        double[] dArray2 = new double[]{2.0, 0.0, 0.0};
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[3];
        dArray = new double[]{1.534991029659386, 1.4898035067115134, 0.0};
        dArray2 = new double[]{0.08780893648850929, -0.048524543557529, 0.0};
        line = new Line(1.6, 1.5, 1.580901699437496, 1.5587785252292472);
        double d5 = 0.0;
        for (n = 0; n < dArray2.length; ++n) {
            d5 += dArray2[n] * dArray2[n];
        }
        d5 = Math.sqrt(d5);
        System.err.println("\nproblem case\n\n");
        boolean bl = line.crossedBy(dArray, dArray2, dArray3, dArray4, false, d5, dArray5);
        System.err.println("walkerPos =(" + dArray[0] + "," + dArray[1] + ")");
        System.err.println("end pos =(" + (dArray[0] + dArray2[0]) + "," + (dArray[1] + dArray2[1]) + ")");
        System.err.println("line lower = (" + line.lowerX + "," + line.lowerY + ")");
        System.err.println("line upper = (" + line.upperX + "," + line.upperY + ")");
        System.err.println("crosses is " + bl);
        System.err.println("normal = (" + dArray3[0] + "," + dArray3[1] + "," + dArray3[2] + ")");
        System.err.println("d = " + dArray4[0]);
        System.err.println("intDist= (" + dArray5[0] + "," + dArray5[1] + "," + dArray5[2] + ")");
        dArray = new double[]{1.53, 1.48, 0.0};
        dArray2 = new double[]{0.09, -0.04, 0.0};
        line = new Line(1.6, 1.5, 1.58, 1.56);
        d5 = 0.0;
        for (n = 0; n < dArray2.length; ++n) {
            d5 += dArray2[n] * dArray2[n];
        }
        d5 = Math.sqrt(d5);
        System.err.println("\ntest case for awkwardness\n\n");
        bl = line.crossedBy(dArray, dArray2, dArray3, dArray4, false, d5, dArray5);
        System.err.println("walkerPos =(" + dArray[0] + "," + dArray[1] + ")");
        System.err.println("end pos =(" + (dArray[0] + dArray2[0]) + "," + (dArray[1] + dArray2[1]) + ")");
        System.err.println("line lower = (" + line.lowerX + "," + line.lowerY + ")");
        System.err.println("line upper = (" + line.upperX + "," + line.upperY + ")");
        System.err.println("crosses is " + bl);
        System.err.println("normal = (" + dArray3[0] + "," + dArray3[1] + "," + dArray3[2] + ")");
        System.err.println("d = " + dArray4[0]);
        System.err.println("intDist= (" + dArray5[0] + "," + dArray5[1] + "," + dArray5[2] + ")");
    }
}

