/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.util.logging.Logger;
import numerics.Vector3D;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.CylinderSubstrate;
import simulation.geometry.FacetCylinder;

public class FacetCylinderSubstrate
extends CylinderSubstrate {
    private final int D = 3;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final FacetCylinder cylinder;

    public FacetCylinderSubstrate(double d, double d2, int n, SimulationParams simulationParams) {
        super(new double[]{d, d, d}, simulationParams);
        if (d2 > d / 2.0) {
            this.logger.warning("cylinder radius " + d2 + "is greater than separation " + d / 2.0 + "in Facetted Cylinder");
        }
        Vector3D vector3D = new Vector3D(new double[]{0.0, 0.0, 1.0});
        Vector3D vector3D2 = new Vector3D(new double[]{d / 2.0, d / 2.0, 0.0});
        this.cylinder = new FacetCylinder(vector3D, vector3D2, d2, n, simulationParams.getP());
    }

    @Override
    public boolean crossesMembrane(Walker walker, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, boolean[] blArray, double[] dArray5) {
        int n;
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray7[n] = walker.r[n] + dArray[n];
            double d2 = Math.floor(dArray7[n] / this.L[n]);
            dArray7[n] = dArray7[n] - d2 * this.L[n];
        }
        n = this.cylinder.crosses(dArray7, dArray2, dArray3, dArray4, bl, d, dArray6, blArray, dArray5) ? 1 : 0;
        return n != 0;
    }

    @Override
    public double getPeakCoord() {
        return this.L[0] / 2.0;
    }

    @Override
    public double[] getSubstrateSize() {
        return this.L;
    }

    @Override
    public boolean intracellular(Walker walker) {
        return this.cylinder.inside(walker.r);
    }

    public static void main(String[] stringArray) {
    }
}

