/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import numerics.GammaRandom;
import numerics.MTRandom;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.geometry.BasicCylinder;
import simulation.geometry.Cylinder;
import simulation.geometry.CylinderSubstrate;
import tools.CL_Initializer;

public class DistributedRadiusCylinderSubstrate
extends CylinderSubstrate {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int D = 3;
    private final double[] l;
    private double[][] P;
    private double[] radius;
    private static final double border = DiffusionSimulation.border;
    private final ArrayList<double[]> clones = new ArrayList();

    public DistributedRadiusCylinderSubstrate(double d, int n, double d2, double d3, SimulationParams simulationParams) {
        super(new double[]{d, d, d}, simulationParams);
        int n2;
        int n3;
        int n4;
        int n5;
        MTRandom mTRandom = new MTRandom(CL_Initializer.seed);
        GammaRandom gammaRandom = new GammaRandom((long)CL_Initializer.seed + 8273L, d2, d3);
        if (n == 0) {
            this.logger.warning("number of cylinders is zero!");
        }
        this.l = new double[]{d, d, d};
        this.radius = new double[n];
        for (int i = 0; i < n; ++i) {
            this.radius[i] = gammaRandom.nextGamma();
        }
        double d4 = 0.0;
        for (int i = 0; i < this.radius.length; ++i) {
            d4 += Math.PI * this.radius[i] * this.radius[i];
        }
        double d5 = this.l[0] * this.l[1];
        if (d4 >= d5) {
            this.logger.warning("total area of specified gamma-distributed cylinders (" + d4 + ") is greater than cross section of substrate (" + d5 + ")");
        }
        Arrays.sort(this.radius);
        double[] dArray = new double[this.radius.length];
        for (n5 = 0; n5 < this.radius.length; ++n5) {
            dArray[this.radius.length - n5 - 1] = this.radius[n5];
        }
        this.radius = dArray;
        this.P = new double[n][3];
        n5 = n;
        for (n4 = 0; n4 < this.radius.length; ++n4) {
            boolean bl = true;
            ArrayList<double[]> arrayList = null;
            for (n3 = 0; bl && n3 < 10000; ++n3) {
                double d6;
                this.P[n4][0] = this.l[0] * mTRandom.nextDouble();
                this.P[n4][1] = this.l[1] * mTRandom.nextDouble();
                bl = false;
                for (n2 = 0; n2 < n4; ++n2) {
                    double d7 = (this.P[n4][0] - this.P[n2][0]) * (this.P[n4][0] - this.P[n2][0]) + (this.P[n4][1] - this.P[n2][1]) * (this.P[n4][1] - this.P[n2][1]);
                    if (!(d7 < (this.radius[n4] + this.radius[n2]) * (this.radius[n4] + this.radius[n2]))) continue;
                    bl = true;
                    break;
                }
                for (n2 = 0; n2 < this.clones.size(); ++n2) {
                    double[] dArray2 = this.clones.get(n2);
                    d6 = (this.P[n4][0] - dArray2[0]) * (this.P[n4][0] - dArray2[0]) + (this.P[n4][1] - dArray2[1]) * (this.P[n4][1] - dArray2[1]);
                    if (!(d6 < (this.radius[n4] + dArray2[3]) * (this.radius[n4] + dArray2[3]))) continue;
                    bl = true;
                    break;
                }
                arrayList = this.checkForCloning(this.P[n4], this.radius[n4]);
                block7: for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    int n6;
                    double[] dArray3 = arrayList.get(n2);
                    d6 = dArray3[3];
                    for (n6 = 0; n6 < n4; ++n6) {
                        double d8 = (dArray3[0] - this.P[n6][0]) * (dArray3[0] - this.P[n6][0]) + (dArray3[1] - this.P[n6][1]) * (dArray3[1] - this.P[n6][1]);
                        if (!(d8 < (d6 + this.radius[n6]) * (d6 + this.radius[n6]))) continue;
                        bl = true;
                        break;
                    }
                    for (n6 = 0; n6 < this.clones.size(); ++n6) {
                        double d9;
                        double[] dArray4 = this.clones.get(n6);
                        double d10 = (dArray3[0] - dArray4[0]) * (dArray3[0] - dArray4[0]) + (dArray3[1] - dArray4[1]) * (dArray3[1] - dArray4[1]);
                        if (!(d10 < (d6 + (d9 = dArray4[3])) * (d6 + d9))) continue;
                        bl = true;
                        continue block7;
                    }
                }
            }
            if (n3 == 10000) {
                this.logger.warning("could only place " + (n4 + 1) + " of " + n + " cylinders on substrate");
                n5 = n4;
                break;
            }
            if (bl) continue;
            this.clones.addAll(arrayList);
        }
        d4 = 0.0;
        for (n4 = 0; n4 < n5; ++n4) {
            d4 += Math.PI * this.radius[n4] * this.radius[n4];
        }
        double d11 = d4 / d5;
        this.logger.info("intracellular volume fraction " + d11);
        n3 = n5;
        this.initClones();
        int n7 = n3 + this.clones.size();
        this.cylinder = new Cylinder[n7];
        for (n2 = 0; n2 < n3; ++n2) {
            this.cylinder[n2] = new BasicCylinder(this.P[n2], this.radius[n2], SimulationParams.sim_p);
        }
        for (n2 = n3; n2 < this.cylinder.length; ++n2) {
            double[] dArray5 = new double[3];
            double[] dArray6 = this.clones.get(n2 - n3);
            for (int i = 0; i < 3; ++i) {
                dArray5[i] = dArray6[i];
            }
            this.cylinder[n2] = new BasicCylinder(dArray5, dArray6[3], SimulationParams.sim_p);
        }
        this.setCylinders(this.cylinder);
    }

    @Override
    public double[] getSubstrateSize() {
        return this.l;
    }

    @Override
    public double getPeakCoord() {
        return this.l[0] / 2.0;
    }

    private ArrayList<double[]> checkForCloning(double[] dArray, double d) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (int i = 0; i < 2; ++i) {
            int n;
            double[] dArray2;
            if (dArray[i] - d <= border) {
                dArray2 = new double[4];
                for (n = 0; n < 3; ++n) {
                    dArray2[n] = n == i ? dArray[n] + this.L[n] : dArray[n];
                }
                dArray2[3] = d;
                arrayList.add(dArray2);
            }
            if (!(this.L[0] - (dArray[i] + d) <= border)) continue;
            dArray2 = new double[4];
            for (n = 0; n < 3; ++n) {
                dArray2[n] = n == i ? dArray[n] - this.L[n] : dArray[n];
            }
            dArray2[3] = d;
            arrayList.add(dArray2);
        }
        if (this.L[0] - (dArray[0] + d) <= border && this.L[1] - (dArray[1] + d) <= border) {
            double[] dArray3 = new double[]{dArray[0] - this.L[0], dArray[1] - this.L[1], dArray[2], d};
            arrayList.add(dArray3);
        }
        if (dArray[0] - d <= border && dArray[1] - d <= border) {
            double[] dArray4 = new double[]{dArray[0] + this.L[0], dArray[1] + this.L[1], dArray[2], d};
            arrayList.add(dArray4);
        }
        if (this.L[0] - (dArray[0] + d) <= border && dArray[1] - d <= border) {
            double[] dArray5 = new double[]{dArray[0] - this.L[0], dArray[1] + this.L[1], dArray[2], d};
            arrayList.add(dArray5);
        }
        if (dArray[0] - d <= border && this.L[1] - (dArray[1] + d) <= border) {
            double[] dArray6 = new double[]{dArray[0] + this.L[0], dArray[1] - this.L[1], dArray[2], d};
            arrayList.add(dArray6);
        }
        return arrayList;
    }

    protected void initClones() {
        int n;
        double[][] dArrayArray = new double[this.P.length + this.clones.size()][];
        for (n = 0; n < this.P.length; ++n) {
            dArrayArray[n] = new double[3];
            for (int i = 0; i < 3; ++i) {
                dArrayArray[n][i] = this.P[n][i];
            }
        }
        for (n = 0; n < this.clones.size(); ++n) {
            double[] dArray = this.clones.get(n);
            dArrayArray[n + this.P.length] = dArray;
        }
        this.P = dArrayArray;
        this.cylinder = new Cylinder[this.P.length];
    }

    public final void drawCrossSection() {
        int n = 20;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("gamma_cyls.csv"));
            for (int i = 0; i < this.cylinder.length; ++i) {
                double d = this.cylinder[i].getRadius();
                for (int j = 0; j < n; ++j) {
                    double d2 = (double)j / (double)n * 2.0 * Math.PI;
                    double d3 = (double)(j + 1) / (double)n * 2.0 * Math.PI;
                    double d4 = this.P[i][0] + d * Math.cos(d2);
                    double d5 = this.P[i][1] + d * Math.sin(d2);
                    double d6 = this.P[i][0] + d * Math.cos(d3);
                    double d7 = this.P[i][1] + d * Math.sin(d3);
                    bufferedWriter.write(d4 + "," + d5 + "\n");
                    bufferedWriter.write(d6 + "," + d7 + "\n");
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

