/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.util.logging.Logger;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.Cylinder;
import simulation.geometry.Substrate;

public abstract class CylinderSubstrate
extends Substrate {
    Logger logger = Logger.getLogger(this.getClass().getName());
    protected double[] L;
    protected Cylinder[] cylinder;
    protected final int D = 3;
    protected int[] cylCrossed;
    protected double[] cyl_p;
    protected double[] shortestDist;
    protected double[] intOriginDist;
    protected double[][] intNormal;
    protected boolean[] intInside;
    private int lastCrossed = -1;

    public CylinderSubstrate(double[] dArray, SimulationParams simulationParams) {
        super(simulationParams, dArray);
        this.L = dArray;
    }

    @Override
    public boolean crossesMembrane(Walker walker, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, boolean[] blArray, double[] dArray5) {
        int n;
        int n2;
        double d2 = 0.0;
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[1];
        boolean[] blArray2 = new boolean[1];
        double[] dArray8 = new double[1];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            d2 += dArray2[n2] * dArray2[n2];
        }
        this.getSubstrateCoords(walker.r, dArray, dArray6);
        d2 = Math.sqrt(d2);
        if (d2 / d <= 1.0E-14) {
            return false;
        }
        n2 = 0;
        boolean bl2 = bl;
        for (n = 0; n < this.cylinder.length; ++n) {
            if (bl) {
                if (n == this.lastCrossed) {
                    blArray2[0] = blArray[0];
                    bl2 = true;
                } else {
                    blArray2[0] = this.cylinder[n].inside(dArray6);
                    bl2 = false;
                }
            }
            if (!this.cylinder[n].crosses(dArray6, dArray2, dArray3, dArray4, bl2, d, dArray7, blArray2, dArray8)) continue;
            this.shortestDist[n2] = dArray7[0];
            this.intOriginDist[n2] = dArray4[0];
            for (int i = 0; i < 3; ++i) {
                this.intNormal[n2][i] = dArray3[i];
            }
            this.intInside[n2] = blArray2[0];
            this.cylCrossed[n2] = n;
            this.cyl_p[n2] = dArray8[0];
            this.intFactor[n2] = 0.9999;
            ++n2;
        }
        if (this.checkBoundaryIntersection(dArray6, dArray, dArray2, dArray3, dArray4, bl, d, dArray7, blArray2, dArray8)) {
            this.shortestDist[n2] = dArray7[0];
            this.intOriginDist[n2] = dArray4[0];
            for (n = 0; n < 3; ++n) {
                this.intNormal[n2][n] = dArray3[n];
            }
            this.intInside[n2] = blArray2[0];
            this.cylCrossed[n2] = -1;
            this.cyl_p[n2] = dArray8[0];
            this.intFactor[n2] = 1.0;
            ++n2;
        }
        if (n2 == 1) {
            dArray4[0] = this.intOriginDist[0];
            for (n = 0; n < 3; ++n) {
                dArray3[n] = this.intNormal[0][n];
            }
            blArray[0] = this.intInside[0];
            this.lastCrossed = this.cylCrossed[0];
            dArray5[0] = this.cyl_p[0];
            factor = this.intFactor[0];
            return true;
        }
        if (n2 > 1) {
            int n3;
            double d3 = Double.MAX_VALUE;
            int n4 = -1;
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(this.shortestDist[n3] < d3)) continue;
                d3 = this.shortestDist[n3];
                n4 = n3;
                this.lastCrossed = this.cylCrossed[n3];
            }
            if (n4 == -1) {
                return false;
            }
            dArray4[0] = this.intOriginDist[n4];
            for (n3 = 0; n3 < 3; ++n3) {
                dArray3[n3] = this.intNormal[n4][n3];
            }
            blArray[0] = this.intInside[n4];
            dArray5[0] = this.cyl_p[n4];
            factor = this.intFactor[n4];
            return true;
        }
        return false;
    }

    @Override
    public abstract double[] getSubstrateSize();

    @Override
    public abstract double getPeakCoord();

    @Override
    public void init() {
    }

    public void setSubstrateDims(double[] dArray) {
        this.L = dArray;
    }

    @Override
    public boolean intracellular(Walker walker) {
        for (int i = 0; i < this.cylinder.length; ++i) {
            if (!this.cylinder[i].inside(walker.r)) continue;
            return true;
        }
        return false;
    }

    final void setCylinders(Cylinder[] cylinderArray) {
        this.cylinder = cylinderArray;
        this.cylCrossed = new int[cylinderArray.length + 1];
        this.cyl_p = new double[cylinderArray.length + 1];
        this.shortestDist = new double[cylinderArray.length + 1];
        this.intOriginDist = new double[cylinderArray.length + 1];
        this.intNormal = new double[cylinderArray.length + 1][3];
        this.intInside = new boolean[cylinderArray.length + 1];
        this.intFactor = new double[cylinderArray.length + 1];
    }
}

