/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.util.logging.Logger;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.dynamics.StepGenerator;
import simulation.dynamics.Walker;
import simulation.geometry.Substrate;
import tools.CL_Initializer;

public class SpatiallyVaryingStepGenerator
implements StepGenerator {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final SimulationParams simParams;
    private final Substrate substrate;
    private final MTRandom stepTwister = new MTRandom(CL_Initializer.seed + 17);
    private final double[] step = new double[3];

    public SpatiallyVaryingStepGenerator(SimulationParams simulationParams, Substrate substrate) {
        this.simParams = simulationParams;
        this.substrate = substrate;
    }

    @Override
    public double getBorder() {
        return 0.0;
    }

    @Override
    public double[] getStep(Walker walker) {
        double d = this.substrate.getDiffusivityAt(walker.r);
        double d2 = Math.sqrt(6.0 * d / this.simParams.getDt());
        double d3 = Math.PI * 2 * this.stepTwister.nextDouble();
        double d4 = 2.0 * this.stepTwister.nextDouble() - 1.0;
        double d5 = Math.cos(d3);
        double d6 = Math.sin(d3);
        double d7 = Math.sqrt(1.0 - d4 * d4);
        this.step[0] = d2 * d5 * d7;
        this.step[1] = d2 * d6 * d7;
        this.step[2] = d2 * d4;
        return this.step;
    }

    @Override
    public int getType() {
        return 2;
    }

    public static void main(String[] stringArray) {
    }
}

