/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import imaging.Scheme;
import java.util.logging.Logger;
import tools.CL_Initializer;

public class SimulationParams {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static boolean sim_separate_runs = false;
    public static int sim_inflamm_increments = 10;
    public static int sim_N_walkers = 10000;
    public static int sim_tmax = 100000;
    public static double sim_p = 0.0;
    public static int sim_initial = 1;
    public static int sim_geomType = 5;
    public static double sim_L = 20.0;
    public static double sim_l = 1.0;
    public static int sim_stripethickness = 3;
    public static double sim_p_perc = 0.5;
    public static double sim_fixedFrac = 0.75;
    public static int sim_modFill = 4;
    public static int sim_modFree = 1;
    public static double sim_voxelSize = 10.0;
    public static int sim_stepType = 1;
    public static boolean sim_delta_set = false;
    public static double sim_delta;
    public static boolean sim_DELTA_set;
    public static double sim_DELTA;
    public static boolean sim_G_set;
    public static double sim_G;
    public static int sim_cyl_pack;
    public static int sim_cyl_dist_size;
    public static double sim_cyl_min_r;
    public static double sim_cyl_max_r;
    public static double sim_cyl_r;
    public static double sim_cyl_R;
    public static double sim_cyl_r1;
    public static double sim_cyl_D1;
    public static double sim_cyl_D2;
    public static double sim_cAngle;
    public static int sim_num_cylinders;
    public static int sim_num_facets;
    public static String sim_plyfile;
    public static int sim_spatial_grid_size;
    public static int sim_amender_type;
    public static int scanType;
    public static final int SPIKE = 0;
    public static final int UNIFORM = 1;
    public static final int SPECIAL = 2;
    public static final int INTRACELLULAR = 3;
    public static final int EXTRACELLULAR = 4;
    public static final int NOCOMPS = 0;
    public static final int EXTRAONLY = 1;
    public static final int INTRAONLY = 2;
    public static final int ALLCOMPS = 3;
    private final int N_walkers;
    private final int tmax;
    private final double dt;
    private final int stepType;
    private double[] stepParams;
    private final double voxelSize;
    private final double p;
    private final int initial;
    private final int geometryType;
    private final Object[] geometryParams;
    public static String trajFile;
    public int buffsize = 0x100000;
    public static double duration;
    public static boolean trajectories;
    public static boolean substrateInfo;
    public static int sim_onlyRun;
    public static int sim_compartmentSignal;

    public SimulationParams(int n, int n2, double d, int n3, int n4, Object[] objectArray, int n5, double d2, Scheme scheme) {
        this.N_walkers = n;
        this.tmax = n2;
        this.p = d;
        this.geometryType = n4;
        this.geometryParams = objectArray;
        this.stepType = n5;
        this.voxelSize = d2;
        double d3 = 0.0;
        for (int i = 0; i < scheme.numMeasurements(); ++i) {
            if (!(d3 < scheme.getDelta(i) + scheme.getDELTA(i))) continue;
            d3 = scheme.getDelta(i) + scheme.getDELTA(i);
        }
        double d4 = scheme.getHalfP90(0);
        this.dt = (d4 + d3) / (double)n2;
        if (scheme.getDelta(0) / this.dt < 50.0) {
            this.logger.warning("WARNING: There are only " + (int)(scheme.getDelta(0) / this.dt) + "timesteps in the gradient block. Less than 50 not recommended to" + "achieve good averaging");
        }
        trajectories = false;
        this.initial = n3;
    }

    public SimulationParams(int n, int n2, double d, int n3, int n4, Object[] objectArray, int n5, double d2, double d3) {
        this.N_walkers = n;
        this.tmax = n2;
        this.p = d;
        this.geometryType = n4;
        this.geometryParams = objectArray;
        this.stepType = n5;
        this.voxelSize = d2;
        this.dt = d3 / (double)n2;
        duration = d3;
        trajectories = true;
        this.initial = n3;
    }

    public double getDt() {
        return this.dt;
    }

    public int getN_walkers() {
        return this.N_walkers;
    }

    public int getTmax() {
        return this.tmax;
    }

    public static void main(String[] stringArray) {
    }

    public double getP() {
        return this.p;
    }

    public int getGeometryType() {
        return this.geometryType;
    }

    public Object[] getGeometryParams() {
        return this.geometryParams;
    }

    public int getInitialConditions() {
        return this.initial;
    }

    public double[] getStepParams() {
        return this.stepParams;
    }

    public void setStepParams(double[] dArray) {
        this.stepParams = dArray;
    }

    public int getStepType() {
        return this.stepType;
    }

    public double getVoxelSize() {
        return this.voxelSize;
    }

    static {
        sim_DELTA_set = false;
        sim_G_set = false;
        sim_cyl_pack = 2;
        sim_cyl_dist_size = 20;
        sim_cyl_min_r = 0.0;
        sim_cyl_max_r = 2.0E-5;
        sim_cyl_r = 1.0E-5;
        sim_cyl_R = 3.0E-5;
        sim_cyl_r1 = sim_cyl_r / 2.0;
        sim_cyl_D1 = CL_Initializer.DIFF_CONST;
        sim_cyl_D2 = CL_Initializer.DIFF_CONST;
        sim_cAngle = 1.5707963267948966;
        sim_num_cylinders = 20;
        sim_num_facets = 0;
        sim_plyfile = null;
        sim_spatial_grid_size = 10;
        sim_amender_type = 0;
        scanType = 0;
        trajFile = null;
        trajectories = false;
        substrateInfo = false;
        sim_onlyRun = -1;
        sim_compartmentSignal = 0;
    }
}

