/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.SVAnalyticalFunction;
import numerics.WatsonDistribution;

public class WatsonD
extends SVAnalyticalFunction {
    public WatsonD() {
        super(true);
    }

    @Override
    public double evaluate(double d) {
        if (d < 700.0) {
            return WatsonDistribution.hyper1F1(1.5, 2.5, d, 1.0E-10) / (3.0 * WatsonDistribution.hyper1F1(0.5, 1.5, d, 1.0E-10));
        }
        return Math.exp(WatsonDistribution.logHyper1F1(1.5, 2.5, d, 1.0E-10) - Math.log(3.0) - WatsonDistribution.logHyper1F1(0.5, 1.5, d, 1.0E-10));
    }

    @Override
    public SVAnalyticalFunction differentiated() {
        return new SVAnalyticalFunction(false){

            @Override
            public double evaluate(double d) {
                if (d < 700.0) {
                    double d2 = WatsonDistribution.hyper1F1(0.5, 1.5, d, 1.0E-10);
                    double d3 = WatsonDistribution.hyper1F1(1.5, 2.5, d, 1.0E-10);
                    double d4 = WatsonDistribution.hyper1F1(2.5, 3.5, d, 1.0E-10);
                    return 0.2 * (d4 / d2) - 0.1111111111111111 * (d3 / d2) * (d3 / d2);
                }
                double d5 = WatsonDistribution.logHyper1F1(0.5, 1.5, d, 1.0E-10);
                double d6 = WatsonDistribution.logHyper1F1(1.5, 2.5, d, 1.0E-10);
                double d7 = WatsonDistribution.logHyper1F1(2.5, 3.5, d, 1.0E-10);
                return 0.2 * Math.exp(d7 - d5) - 0.1111111111111111 * Math.exp(2.0 * (d6 - d5));
            }

            @Override
            public String toString() {
                return "\\frac{3}{p^2 + 2p} \\frac{M(\\frac{5}{2}, \\frac{p}{2} + 2, \\kappa)}{M(\\frac1{2}, \\frac{p}{2}, \\kappa)} - \\left( \\frac1{p} \\frac{M(\\frac{3}{2}, \\frac{p}{2} + 1, \\kappa)}{M(\\frac{1}{2}, \\frac{p}{2}, \\kappa)} \\right)^2";
            }
        };
    }

    @Override
    public String toString() {
        return "D_3(\\kappa) = \\frac{M(\\frac{3}{2}, \\frac{p}{2} + 1, \\kappa)}{pM(\\frac1{2}, \\frac{p}{2}, \\kappa)}";
    }
}

