/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import Jama.Matrix;
import numerics.Point3D;
import numerics.RealMatrix;

public class Vector3D {
    public final double x;
    public final double y;
    public final double z;

    public static Vector3D vectorFromSPC(double d, double d2, double d3) {
        double d4 = d * Math.sin(d2);
        return new Vector3D(d4 * Math.cos(d3), d4 * Math.sin(d3), d * Math.cos(d2));
    }

    public Vector3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Vector3D(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public Vector3D(Point3D point3D, Point3D point3D2) {
        this.x = point3D.x - point3D2.x;
        this.y = point3D.y - point3D2.y;
        this.z = point3D.z - point3D2.z;
    }

    public double dot(Vector3D vector3D) {
        return vector3D.x * this.x + vector3D.y * this.y + vector3D.z * this.z;
    }

    public Vector3D cross(Vector3D vector3D) {
        return new Vector3D(this.y * vector3D.z - vector3D.y * this.z, vector3D.x * this.z - this.x * vector3D.z, this.x * vector3D.y - vector3D.x * this.y);
    }

    public Vector3D negated() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D plus(Vector3D vector3D) {
        return new Vector3D(this.x + vector3D.x, this.y + vector3D.y, this.z + vector3D.z);
    }

    public Vector3D minus(Vector3D vector3D) {
        return new Vector3D(this.x - vector3D.x, this.y - vector3D.y, this.z - vector3D.z);
    }

    public Vector3D normalized() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Vector3D(this.x / d, this.y / d, this.z / d);
    }

    public double mod() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double modSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3D scaled(double d) {
        return new Vector3D(this.x * d, this.y * d, this.z * d);
    }

    public String toString() {
        return "Vector3D: " + this.x + "\t" + this.y + "\t" + this.z + "\t";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Vector3D)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Vector3D vector3D = (Vector3D)object;
        return this.x == vector3D.x && this.y == vector3D.y && this.z == vector3D.z;
    }

    public int hashCode() {
        return (int)(13.0 * this.x + 29.0 * this.y + 31.0 * this.z);
    }

    public RealMatrix toRealMatrix() {
        RealMatrix realMatrix = new RealMatrix(3, 1);
        realMatrix.entries[0][0] = this.x;
        realMatrix.entries[1][0] = this.y;
        realMatrix.entries[2][0] = this.z;
        return realMatrix;
    }

    public Matrix toJamaMatrix() {
        Matrix matrix = new Matrix(3, 1);
        matrix.set(0, 0, this.x);
        matrix.set(1, 0, this.y);
        matrix.set(2, 0, this.z);
        return matrix;
    }

    public static double[] thetaPhi(Vector3D vector3D) {
        double[] dArray = new double[2];
        dArray[0] = Math.acos(vector3D.z);
        dArray[1] = vector3D.x == 0.0 && vector3D.y == 0.0 ? 0.0 : (vector3D.y == 0.0 ? (vector3D.x > 0.0 ? 0.0 : Math.PI) : (vector3D.x == 0.0 ? (vector3D.y > 0.0 ? 1.5707963267948966 : 4.71238898038469) : (vector3D.x > 0.0 && vector3D.y > 0.0 ? Math.atan(vector3D.y / vector3D.x) : (vector3D.x < 0.0 && vector3D.y > 0.0 ? Math.PI + Math.atan(vector3D.y / vector3D.x) : (vector3D.x < 0.0 && vector3D.y < 0.0 ? Math.PI + Math.atan(vector3D.y / vector3D.x) : Math.PI * 2 + Math.atan(vector3D.y / vector3D.x))))));
        return dArray;
    }
}

